/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) posixlog.c: version 25.1 created on 12/2/91 at 16:47:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)posixlog.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1989 ARIX	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ARIX	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"posixlog:posixlog.c	1.1"			*/

#ident	"@(#)posixlog:posixlog.c	25.1"

/* Original utility written for POSIX, mer */

/* This utility must be setuid, so that the comments written cannot
   be read by anyone other than bin or root */

#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>

/* Default file name to store messages in */
#define	FILE_NAME	"/etc/log_messages"
#define MAX_MESSAGE_LEN 255

void	get_user_info (), make_message ();
struct	passwd	*getpwuid ();
struct	group	*getgrgid ();

main (argc, argv)
int	argc;
char	**argv;
{
	char	message [MAX_MESSAGE_LEN];
	char	who_is_it [80];
	char	date [80];
	char	line_to_file [MAX_MESSAGE_LEN + 160];
	long	time_o_day;
	int	fd, line_length;

	if (argc < 2)

		usage ();

	/* Assembles the message from its seperate componants */
	make_message (argc - 1, &argv[1], message);

	/* Assembler user information */
	get_user_info (who_is_it);

	time (&time_o_day);
	cftime (date, "", &time_o_day);

	/* Put the whole works together */
	sprintf (line_to_file, "%s\n%s\n%s\n\n", who_is_it, date, message);
	line_length = strlen (message) + strlen (date) + strlen (who_is_it) + 4;

	if ( (fd = open (FILE_NAME, O_CREAT | O_WRONLY | O_APPEND, 0664)) 
	     == -1){

		fprintf (stderr, "posixlog: Unable to open log file\n");
		exit (1);
	}
	else

		/* This has to be done in case umask was non-zero */
		chmod (FILE_NAME, 0600);

	if (write (fd, line_to_file, line_length) != line_length){

		fprintf (stderr, "posixlog: Unable to store complete message\n");
		exit (1);
	}

	close (fd);
	exit (0);
}

/* Each word in the message is a asperate argument.  This is per the
   requirements of the POSIX standard */
void
make_message (count, begin_mess, message)
int	count;
char	**begin_mess, *message;
{
	sprintf (message, "%s", begin_mess[0]);
	begin_mess++;

	while (--count){

		sprintf (message + strlen (message), " %s", begin_mess[0]);
		begin_mess++;
	}

	return;
}


void
get_user_info (who_is_it)
char	*who_is_it;
{
	struct	passwd *pw;
	struct	group *grp;
	uid_t	uid;
	gid_t	gid;
	char	u_name [32], g_name [32];

	pw = getpwuid ( uid = getuid () );
	grp = getgrgid ( gid = getgid () );

	if (pw == NULL)

		sprintf (u_name, "%d", uid);

	else

		strcat (u_name, pw->pw_name);

	if (grp == NULL)

		sprintf (g_name, "%d", gid);

	else

		strcat (g_name, grp->gr_name);

	sprintf (who_is_it, "user (%s)  group (%s)", u_name, g_name);

	return;
}


int
usage ()
{
	fprintf (stderr, "usage: posixlog your_message\n");
	exit (1);
}
