/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) posixconf.c: version 25.1 created on 12/2/91 at 16:47:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)posixconf.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1989 ARIX	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ARIX	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"posixconf:posixconf.c	1.1"			*/

#ident	"@(#)posixconf:posixconf.c	25.1"

/* Original utility written for POSIX, mer */

#include <sys/types.h>
#include <stdio.h>

#define	NUM_SYSCONF_CALLS 15
#define NUM_PATHCONF_CALLS 17 /* This is two larger than the actual #, since
				 POSIX & FIPS have different values for 
				 two posixconf values */

ushort	find_the_string ();

/* These macros are used to determine whether the parameter requested
   was a sysconf or pathconf call */
#define	IS_SYSCONF	1
#define	IS_PATHCONF	2

struct	unistd_v {

	char	*posix_param;
	ushort	unistd_v;
	};

struct	unistd_v sysconf_v [NUM_SYSCONF_CALLS] = {

	{"_SC_ARG_MAX", 1},
	{"_SC_CHILD_MAX", 2},
	{"_SC_CLK_TCK", 3},
	{"_SC_NGROUPS_MAX", 4},
	{"_SC_OPEN_MAX", 5},
	{"_SC_PASS_MAX", 6},
	{"_SC_PID_MAX", 7},
	{"_SC_UID_MAX", 8},
	{"_SC_EXIT_SIGHUP", 9},
	{"_SC_KILL_PID_NEG1", 10},
	{"_SC_KILL_SAVED", 11},
	{"_SC_PGID_CLEAR", 12},
	{"_SC_JOB_CONTROL", 13},
	{"_SC_SAVED_IDS", 14},
	{"_SC_VERSION", 15}
};
struct	unistd_v pathconf_v [NUM_PATHCONF_CALLS] = {

	{"_PC_FCHR_MAX", 1},
	{"_PC_LINK_MAX", 2},
	{"_PC_MAX_CANNON", 3},
	{"_PC_MAX_CANON", 3},
	{"_PC_MAX_INPUT", 4},
	{"_PC_NAME_MAX", 5},
	{"_PC_PATH_MAX", 6},
	{"_PC_PIPE_BUF", 7},
	{"_PC_CHOWN_RESTRICTED", 8},
	{"_PC_CHOWN_SUP_GRP", 9},
	{"_PC_DIR_DOTS", 10},
	{"_PC_GROUP_PARENT", 11},
	{"_PC_LINK_DIR", 12},
	{"_PC_NO_TRUNC", 13},
	{"_PC_UTIME_OWNER", 14},
	{"_PC_V_DISABLE", 15},
	{"_PC_VDISABLE", 15}
};

main (argc, argv)
int	argc;
char	**argv;
{
	ushort	which_list, offset;
	int	call_value;

	/* sysconf has 1 parameter, pathconf has two */
	if (argc < 2 || argc > 3)

		usage ();

	/* If item isn't on either list, give usage & exit */
	if (! (which_list = find_the_string (argv[1], &offset)))

		usage ();

	/* Value is a sysconf value, try and get it */
	if ( which_list == IS_SYSCONF ){

		if ( (call_value = sysconf (sysconf_v[offset].unistd_v)) == -1){

			fprintf (stderr, "posixconf: System no longer recognizes this value\n");
			exit (1);
		}

		fprintf (stdout, "%ld\n", call_value);
		exit (0);
	}

	/* Value is a pathconf value, try and get it, but
	   first make sure the path exists */
	if ( which_list == IS_PATHCONF ){

		if (argc < 3){

			fprintf (stderr, "posixconf: pathconf values require a valid path\n");
			exit (1);
		}
		if ( access (argv[2], 00) == -1){

			fprintf (stderr, "posixconf: %s does not exist\n",
			         argv[2]);
			exit (1);
		}

		if ( (call_value = pathconf (argv[2], pathconf_v[offset].unistd_v
		    )) == -1){

			fprintf (stderr, "posixconf: System no longer recognizes this value\n");
			exit (1);
		}

		fprintf (stdout, "%ld\n", call_value);
		exit (0);
	}

}


/* This routine determines whether the parameter exists, and if so,
   whether it is a sysconf or pathconf parameter */
ushort
find_the_string (posix_define, offset)
char	*posix_define;
ushort	*offset;
{
	int	count;

	for (count = 0; count < NUM_SYSCONF_CALLS; count++){

		if (strcmp (posix_define, sysconf_v[count].posix_param) == 0){

			*offset = count;
			return (IS_SYSCONF);
		}
	}

	for (count = 0; count < NUM_PATHCONF_CALLS; count++){

		if (strcmp (posix_define, pathconf_v[count].posix_param) == 0){

			*offset = count;
			return (IS_PATHCONF);
		}
	}

	return (0);		/* The requested parameter wasn't on
				   the list of allowed sysconf &
				   pathconf calls */
}


int
usage ()
{
	fprintf (stderr, "usage: posixconf sysconf_value | pathconf_value path\n");
		exit (1);
}
