/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pwgen.c: version 25.1 created on 12/2/91 at 16:46:28	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pwgen.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	char *pwgen()	-- compute random but easily remembered password
 *
 *	pwgen		-- test program demonstrating pwgen()
 */

#include <stdio.h>

/* This seed script is pretty good since the full ps output is only
   given to processes running as root, but probably should be replaced by
   reads to /dev/mem at rapidly changing locations unavailable to anyone
   but root.  Remember, except during testing, this function only invoked
   by processies with suid to root permission. */

#define SEED "IFS=' '; export IFS; exec 2>/dev/null;\
	(/bin/ps -el&/bin/ps -ef&/bin/date&wait;)|/bin/sum -r;\
	(/bin/ps -ef&/bin/ps -el&/bin/date&wait;)|/bin/sum -r;"
   /* MUST have IFS redefine to prevent IFS trojan horse attack!!! */

static char *p;

union seed {		/* the seed is available as a long or 2 shorts */
	long	l;
	unsigned short	u[2];
	} seed;

long lrand48();
#define RN lrand48()

char vowel[]="aeiouAEIOU";
char cons[]="bcdfghjklmnpqrstvwxyzBCDFGHJKLMNPQRSTVWXYZ";
char num[]="0123456789";

syl()
{
    switch (RN%2)	/* 2 sylable formats */
    {
    case 0:		/* consonant-vowel-consonant */
	*p++ = cons[RN%42];
	*p++ = vowel[RN%10];
	*p++ = cons[RN%42];
	break;
    case 1:		/* consonant-vowel */
	*p++ = cons[RN%42];
	*p++ = vowel[RN%10];
	break;
    }
}

setseed()
{
	int i,j;
	FILE *pipe;
/* run the shell script to get a totally unpredictable seed */
	if ((pipe=popen(SEED,"r")) == NULL )
		errorabt("popen failed");
	for ( i=0 ; i<2 ; i++ ) 
	    if (fscanf(pipe,"%hu %d", &seed.u[i], &j) != 2 || j == 0)
		errorabt("seed script bad data output");
	if (pclose(pipe) != 0)
		errorabt("seed script terminated abnormally");

/* set the seed value and churn it a bit */
	srand48(seed.l);
	for ( i=0 ; i<99 ; i++ ) lrand48();
}

char *pwgen(fmts)
int fmts; 
{
static char pword[10];	/* where the password itself will be assembled */

/* check to see that the random number generator has been primed */
	if (seed.l == 0L) setseed();

/* compute a prototype password */
	p = pword;
	fmts--;             /* This is an adjustment to make the code*/
			    /* and the documentation match*/

	if (fmts > 0 && fmts < 7) {	/* formats in range 1..6 legal */
	    switch (RN%fmts)
	    {
	    case 0:		/* SSNN */
		syl();
		syl();
		*p++ = num[RN%10];
		*p++ = num[RN%10];
		break;
	    case 1:		/* NNSS */
		*p++ = num[RN%10];
		*p++ = num[RN%10];
		syl();
		syl();
		break;
	    case 2:		/* NSSN */
		*p++ = num[RN%10];
		syl();
		syl();
		*p++ = num[RN%10];
		break;
	    case 3:		/* SNNS */
		syl();
		*p++ = num[RN%10];
		*p++ = num[RN%10];
		syl();
		break;
	    case 4:		/* SNSN */
		syl();
		*p++ = num[RN%10];
		syl();
		*p++ = num[RN%10];
		break;
	    case 5:		/* NSNS */
		*p++ = num[RN%10];
		syl();
		*p++ = num[RN%10];
		syl();
		break;
	    }
	}
	else {		/* PASSWDOPTS has a value out of the range 1..6 */
		syl();		/* 3 sylable only format */
		syl();
		syl();
	}
	*p = '\0';
	return(pword);
}

errorabt(s)
char *s;
{
	fprintf(stderr, "pwgen: %s\n", s);
	abort();
}
