/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passwd.c: version 25.1 created on 12/2/91 at 16:46:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passwd.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)passwd:passwd.c	1.4.1.10"
/*
 * passwd is a program whose sole purpose is to manage 
 * the password file. It allows system administrator
 * to add, change and display password attributes.
 * Non privileged user can change password or display 
 * password attributes which corresponds to their login name.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <shadow.h>
#include <time.h>
#include <ctype.h>        /* isalpha(c), isdigit(c), islower(c), toupper(c) */
#include <sys/security.h>
#include <sys/priv.h>
#include <grp.h>
#include <auth.h>

/* flags  indicate password attributes to be modified */

#define LFLAG 0x001		/* lock user's password  */
#define DFLAG 0x002		/* delete user's  password */
#define MFLAG 0x004		/* set max field -- # of days passwd is valid */	
#define NFLAG 0x008		/* set min field -- # of days between passwd changes */
#define SFLAG 0x010		/* display password attributes */
#define FFLAG 0x020		/* expire  user's password */
#define AFLAG 0x040		/* display password attributes for all users*/
#define PFLAG 0x080		/* change user's password */  
#define SAFLAG 0x050		/* display password attributes for all users */

#define FMTFLAG 0x200		/* set the fmt for passwd gen */
#define UNLFLAG 0x400		/* unlock the password field */
#define GRPFLAG 0x800		/* set a passwd on a group */

#define NOLOCK	0
#define TMPLOCK	1
#define RETIRE	2

/* exit  code */
#define SUCCESS	0	/* succeeded */
#define NOPERM	1	/* No permission */
#define BADSYN	2	/* Incorrect syntax */
#define FMERR	3	/* File manipulation error */
#define FATAL	4	/* Old file can not be recover */
#define FBUSY	5	/* Lock file busy */
#define BADOPT	6	/* Invalid argument to option */
 
/* define error messages */
#define MSG_NP	"Permission denied"
#define MSG_NV "Invalid argument to option"
#define MSG_BS	"Invalid combination of options"
#define MSG_FE	"Unexpected failure. Password file unchanged."
#define MSG_FF	"Unexpected failure. Password file missing."
#define MSG_FB	"Password file(s) busy. Try again later."

#define MSG_GB	"Group file(s) busy. Try again later."
#define MSG_GF	"Unexpected failure. Group file missing."
#define MSG_GE	"Unexpected failure. Group file unchanged."

/* return code from ckarg() routine */
#define FAIL 		-1

#define NUMCP	13	/* number of characters for valid password */
#define MINLENGTH 6  	/* for passwords */

#define DAY_WEEK 7	/* days per weeks */
#define DIG_CH	63	/* A character represents upto 64 
			   digits in a radix-64 notation */
#define SEC_WEEK (24 * DAY_WEEK * 60 * 60 )    /* seconds per week */

/*	 Convert base-64 ASCII string to long integer.  *
 * 	 Convert long integer to maxweek, minweeks.     *
 * 	 Convert current time from seconds to weeks.	*
 */ 	
#define CNV_AGE()	{\
	when = (long) a64l(pwd->pw_age);\
	maxweeks = when & 077;\
	minweeks = (when >> 6) & 077;\
	now = time ((long *) 0) / SEC_WEEK;\
}

/* print password status */
/*
   lock status changed from lock == 2 retire to
   lock >= 2 to retain the date/time that the 
   account has been locked - 1/22/90
*/

#define PRT_STATUS(lock) {\
	if ( lock == 1 ) \
		(void)fprintf(stdout, "Locked" );\
	else if ( lock >= 2 ) \
		(void)fprintf(stdout, "Retired since %s", killlf(ctime(&lock)));\
	else \
		(void)fprintf(stdout, "Enabled " );\
}

#define PRT_PWD(pwdp)	{\
	if (*pwdp == NULL) \
		fprintf(stdout, "No Password   ");\
	else if (strlen(pwdp) < NUMCP) \
		fprintf(stdout, "Account Locked" );\
	else\
		fprintf(stdout, "Password      ");\
}
#define PRT_AGE()


#define PRT_MODE(pw_mode) {\
	if ( PASS_NEED(pw_mode)  ) \
		(void)fprintf(stdout, "  PasswdRequired");\
	else \
		(void)fprintf(stdout, "  PasswdOptional" );\
	if ( NO_CHANGE(pw_mode) )\
		(void)fprintf(stdout, "  NotUserChangable");\
	else \
		(void)fprintf(stdout, "  UserChangable   " );\
	if (AUTO_PASS(pw_mode)) \
		(void)fprintf(stdout, "  AutoGen=%d",pw_mode);\
	else \
		(void)fprintf(stdout, "  AutoGen=%d (any passwd)",pw_mode);\
}

extern int optind;
extern struct passwd *getpwent();
extern struct passwd *getpwnam();
extern char *pwgen();
struct passwd *pwd;


char 	lkstring[] = "*LK*";		/*lock string  to lock user's password*/
char	nullstr[] = "";
/* usage message of non privileged user */
char 	usage[]  = "	Usage:\n\tpasswd [-s] [name]\n";
/* usage message of privileged user */
char 	sausage[]  = "	 Usage:\n\tpasswd [name]\n\tpasswd  [-l|-d|-r|-u]  [-n min] [-f] [-x max] name\n\tpasswd -s [-a]\n\tpasswd -m format name \n";
char	opwbuf[10];
char	*pw, *uname, *prognamep;
int 	uid, retval,opwlen;
int 	 mindays, maxdays;		/* password aging information */
int	pwfmt;
int 	when;
long	a64l();
char 	*l64a();
time_t 	now, maxweeks, minweeks;
char	*crypt ();

int	lkflag;
int	lifeflags = 0;
ushort usr_exist = 0;
usrauth_t *ua;
usrauth_t *getuaent();
usrstat_t *us;
usrstat_t *getusent();
int 	suserflg;


main (argc, argv)
int argc;
char *argv[];
{
	extern char *crypt();
	extern char *getpass();
	extern char  *getlogin();

	/* passwd calls getpass() to get the password. The getpass() routine
	   returns at most 8 charaters. Therefore, array of 10 chars is
	   sufficient.
	*/
	char	pwbuf[10];			
	char	buf[10];
	char 	*p, *o;
	char 	saltc[2];	 /* crypt() takes 2 char string as a salt */
	 int	count; 		 /* count verifications */
	long 	salt;
	int 	insist;
	int 	flags;
	int	c;
	int  options;   /* flags returned from ckarg */
	int 	i, j, k, flag;	/* for triviality checks */
	int 	pwlen;  /* length of old passwords */
	struct	passwd *tmp_pwd;
	priv_t	pv;     
	int	autopass = 0;

	flag = 0;
	insist = 0;		/* # of times the program  prompts 
				 * for valid password */
	count = 0;

	prognamep = argv[0];	
	uid = getuid();		/* get the user id */
	
	if ( access(USRAUTH,0) == 0)
		usr_exist = 1; 

	/*        gratuity check - make sure we run as setuid or at
	 *        least with the proper effective privileges 
	 */
	if ( !priv(P_SEC, geteuid())) {
		fprintf( stderr, 
		"passwd must be privileged to function properly\n" );
		exit(NOPERM);
	} 

	if ( getpriv( &pv ) == -1 ) 
		suserflg = (getuid() == 0);
	else 
		suserflg = (((pv.real & P_SEC ) == P_SEC ) || 
		            ((pv.real & P_SYSADM) == P_SYSADM ));
	
	if (argc > 1) 
		/* 
		 * ckarg() parses the arguments. In case of an error, 
		 * it sets the retval and returns FAIL (-1). It return
		 * the value which indicate which password attributes
		 * to modified 
		 */

		switch (options = ckarg( argc, argv)) { 
		case FAIL:		/* failed */
			exit(retval); 
		case SAFLAG:		/* display password attributes */
			if (usr_exist)
				exit(ua_display((char *) NULL));
			else
				exit(pwd_display((char *) NULL));
		default:	
			break;
		}

	argc -= optind;

	if (argc < 1 ) {
		if ((uname = getlogin()) == NULL) { 
			(void) fprintf(stderr, "%s", suserflg ? sausage :usage);
			exit(NOPERM);
		} else if (!options)	
			(void) fprintf(stderr, "%s:  Changing password for %s\n",
				 prognamep,  uname);
	} else {
		if ( options & GRPFLAG ) {
			if ((uname = getlogin()) == NULL) {
				(void) fprintf(stderr, "%s", suserflg ? sausage :usage);
				exit(NOPERM);
			}
		}
		else
			uname = argv[optind];
	}

	if ( ! ( tmp_pwd =  getpwuid( uid ) ) ) {
		fprintf( stderr, "can't id  user of passwd\n" );
		exit(NOPERM);
	}

	if ( (!suserflg) && strcmp( uname, tmp_pwd->pw_name )) {
		fprintf( stderr, "permisson denied\n" );
		exit(NOPERM);
	}

	if ((pwd = getpwnam(uname)) == NULL || 
            (usr_exist &&  (ua = getuanam(uname)) == NULL)) { 
		(void) fprintf(stderr, "no user %s in user_auth\n", uname ); 
		exit(NOPERM);
	}

	if ( ua )
		us = getusent(ua->ua_uid);
	if ( (!suserflg) && (uid != (ua ? ua->ua_uid : pwd->pw_uid))) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_NP);
		exit(NOPERM);
	}
	if ( ua && NO_CHANGE(ua->ua_mode) && !suserflg ) {
		fprintf( stderr, "password locked: permission denied\n" );
		exit(NOPERM);
	}

	switch (options) {
	case SFLAG:		/* display password attributes */
		if (usr_exist)
			exit(ua_display(uname));
		else
			exit(pwd_display(uname));

	case GRPFLAG :	/* change the group passwd */
		/* Can't be reached until fixed */	
		break;

	case 0:			/* changing user password */
		options = PFLAG;
		if ( usr_exist ) 
			retval = ck_uapasswd();
		else 
			retval = ck_pwdpasswd();
		break;

	default:		/* changing user password attributes */
		exit(update(options));
		break;
	}

	/* 
	 *Do not change passwd if the retval is greater than zero (NOPERM)
	 */
	if (retval)
		exit(retval);
	

tryagn:
	if( insist >= 3) {       /* three chances to meet triviality standard */
		(void) fprintf(stderr, "Too many failures - try later\n", prognamep);
		exit(NOPERM);
	}

	/* 
	   Add code here if you want the group file to have auto passwd
	   generation.
	*/

	/* add the automatic password generator function */
	if ( usr_exist && (AUTO_PASS(ua->ua_mode))) {
		fprintf(stderr, "generating new password....\n" );
		autopass = 1;
		strcpy( pwbuf, pwgen(AUTO_PASS(ua->ua_mode )));
		fprintf(stderr, "proposed passwd: %s\n", pwbuf );
	}
	else
		(void) strcpy (pwbuf, getpass ("New password:"));
	pwlen = strlen (pwbuf);

	/* Make sure new password is long enough */

	if ( !suserflg && (pwlen < MINLENGTH ) ) { 
		(void) fprintf(stderr, "Password is too short - must be at least 6 digits\n");
		insist++;
		goto tryagn;
	}

	/* Check the circular shift of the logonid */
	 
	if ( !suserflg  && circ(uname, pwbuf) ) {
		(void) fprintf(stderr, "Password cannot be circular shift of logonid\n");
		insist++;
		goto tryagn;
	}

	/* Insure passwords contain at least two alpha characters */
	/* and one numeric or special character */               

	flags = 0;
	flag = 0;
	p = pwbuf;

	if ( !suserflg && ( autopass == 0 )) {
		while (c = *p++) {
			if (isalpha(c) && flag )
				 flags |= 1;
			else if (isalpha(c) && !flag ) {
				flags |= 2;
				flag = 1;
			} else if (isdigit(c) ) 
				flags |= 4;
			else 
				flags |= 8;
		}
		 
		/*		7 = lca,lca,num
		 *		7 = lca,uca,num
		 *		7 = uca,uca,num
		 *		11 = lca,lca,spec
		 *		11 = lca,uca,spec
		 *		11 = uca,uca,spec
		 *		15 = spec,num,alpha,alpha
		 */
		 
		if ( flags != 7 && flags != 11 && flags != 15  ) {
			(void) fprintf(stderr,"Password must contain at least two alphabetic characters and\n");
			(void) fprintf(stderr,"at least one numeric or special character.\n");
			insist++;
			goto tryagn;
		}
	}
	if ( ! suserflg ) {
		p = pwbuf;
		o = opwbuf;
		if ( pwlen >= opwlen) {
			i = pwlen;
			k = pwlen - opwlen;
		} else {
			i = opwlen;
			k = opwlen - pwlen;
		}
		for ( j = 1; j  <= i; j++ ) 
			if ( *p++ != *o++ ) 
				k++;
		if ( k  <  3 ) {
			(void) fprintf(stderr, "Passwords must differ by at least 3 positions\n");
			insist++;
			goto tryagn;
		}
	}

	/* Ensure password was typed correctly, user gets three chances */

	(void) strcpy (buf, getpass ("Re-enter new password:"));
	if (strcmp (buf, pwbuf)) {
		if (++count > 2) { 
			(void) fprintf(stderr, "%s: Too many tries; try again later\n", prognamep);
			exit(NOPERM);
		} else
			(void) fprintf(stderr, "They don't match; try again.\n");
		goto tryagn;
	}
	if ( autopass )
		for ( i = 0; i < 32; i++ )
			printf( "\n\n" );

	/* Construct salt, then encrypt the new password */
	(void) time(&salt);
	salt += getpid();

	saltc[0] = salt & 077;
	saltc[1] = (salt >> 6) & 077;
	for (i=0; i<2; i++) {
		c = saltc[i] + '.';
		if (c>'9') c += 7;
		if (c>'Z') c += 6;
		saltc[i] = c;
	}
	pw = crypt (pwbuf, saltc);
	exit(update(options));
}

/* ck_pwdpasswd():  Verify user old password. It also check 
 * password aging information to varify that user is authorized
 * to change password.
 */ 
  
int
ck_pwdpasswd()
{
	if ( pwd->pw_passwd[0] && ( !suserflg) )
	{
		(void) strcpy (opwbuf, getpass ("Old password:"));
		opwlen = strlen(opwbuf);       /* get length of old password */
		pw = crypt (opwbuf, pwd->pw_passwd);
		if (strcmp (pw, pwd->pw_passwd) != 0) {
			(void) fprintf(stderr, "Sorry.\n");
			return (NOPERM);
		}
	} else
		opwbuf[0] = '\0';
	/* password age checking applies */
	if (*pwd->pw_age != NULL) {
		CNV_AGE();
		when >>= 12 ;
		if (when <= now) {
			if (!suserflg && ( now < when + minweeks)) { 
				(void) fprintf(stderr, "%s:  Sorry: < %ld weeks since the last change\n", prognamep, minweeks);
				return (NOPERM);
			}
			if ( minweeks > maxweeks && !suserflg) { 
				(void) fprintf(stderr, "%s: You may not change this password\n", prognamep);
				return (NOPERM);
			}
		}
	}
	return (SUCCESS);
}


/* ck_uapasswd():  Verify user old password. It also checks
 * password aging information to verify that user is authorized
 * to change password.
 */ 

int
ck_uapasswd()
{
	if ( ua->ua_passwd[0] && (!suserflg )) {
		(void) strcpy (opwbuf, getpass ("Old password:"));
		opwlen = strlen(opwbuf);       /* get length of old password */
		pw = crypt (opwbuf, ua->ua_passwd);
		if (strcmp (pw, ua->ua_passwd) != 0) {
			(void) fprintf(stderr, "Sorry.\n");
			return (NOPERM);
		}
	} else
		opwbuf[0] = '\0';
	/* password age checking applies */
	lifeflags = 0;
	if (ua->ua_max_pwdlife < 0) {
		lifeflags |= MFLAG;	/* set max field */
		maxdays = ua->ua_max_pwdlife * -1;
	}
	if (ua->ua_min_pwdlife < 0) {
		lifeflags |= NFLAG;	/* set min field */
		mindays = ua->ua_min_pwdlife * -1;
	}
	if (lifeflags) {
		ua_update(lifeflags);
	}

	if (ua->ua_max_pwdlife) { 
		now = DAY_NOW;
		if (us->us_pwdchg <= now) {
			if (!suserflg && (now < (us->us_pwdchg+ua->ua_min_pwdlife))) {
				fprintf(stderr,
			"%s: Sorry: less than %ld days since the last change\n",
					prognamep, ua->ua_min_pwdlife);
				return (NOPERM);
			}
			if (!suserflg && (ua->ua_min_pwdlife > ua->ua_max_pwdlife)) { 
				fprintf(stderr,
				"%s: You may not change this password\n",
					prognamep);
				return (NOPERM);
			}
		}
	}
	return (SUCCESS);
}


int 
update(flag)
int flag;
{
	register int ret;

	/* lock the password file */
	if (lckpwdf() != 0) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FB);
		return (FBUSY);
	}

	if ( access(USRAUTH,0) == 0) {
		if (!usr_exist) {
			(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
			(void) ulckpwdf();
			return(FMERR);
		} else 
			ret = ua_update(flag);

	} else {
		if (usr_exist) {
			(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
			(void) ulckpwdf();
			return(FMERR);
		} else
			ret = pwd_update(flag);
	}
	(void) ulckpwdf();
	return (ret);
}

/************************************************************
 *							    *
 * pwd_update(): updates the password file.	    *
 * It takes "flag" as an argument to determine which        *
 * password attributes to modify. It returns 0 for success  *
 * and  > 0 for failure.			            *
 *							    *
 ***********************************************************/

int
pwd_update(flag)
int flag;
{
	register int i;
	extern int errno;
	struct stat buf;
	FILE *tpfp;
	int usr_flag;

	

	/* ignore all the signals */

	for (i=1; i < NSIG; i++)
		(void) sigset(i, SIG_IGN);

 	/* Clear the errno. It is set because SIGKILL can not be ignored. */

	errno = 0;

	/* Mode  of the passwd file should be 444 or less */

	if (stat(PASSWD, &buf) < 0) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}
	(void) umask(~(buf.st_mode & 0444));

	if ((tpfp = fopen(PASSTEMP, "w")) == NULL) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}

	/*
	 *	copy passwd  files to temps, replacing matching lines
	 *	with new password attributes.
	 */

	/* entry should be there -- we just checked it */

	while ((pwd = getpwent()) != NULL) {
	   if (strcmp(pwd->pw_name, uname) == 0) { 
		/* LFLAG and DFLAG should be checked before FFLAG.
		   FFLAG clears the lastchg field. We do not
		   want lastchg field to be set if one execute
		   passwd -d -f name or passwd -l -f name.
		*/

		if (flag & LFLAG) {	 /* lock password */
			pwd->pw_passwd = pw;
			if (*pwd->pw_age != NULL) {
				CNV_AGE();
				when = maxweeks + (minweeks << 6) + (now << 12);
				pwd->pw_age = l64a(when);
			}
		} 
		if (flag & DFLAG) {	 /* delete password */
			pwd->pw_passwd = nullstr;
			if (*pwd->pw_age != NULL) {
				CNV_AGE();
				when = maxweeks + (minweeks << 6) + (now << 12);
				pwd->pw_age = l64a(when);
			}
		} 
		if (flag & FFLAG) {	 /* expire password attributes*/
	 		if (strlen(pwd->pw_passwd) < NUMCP) 
				*pwd->pw_passwd = NULL;
			pwd->pw_age = '\0';
		}
		/* MFLAG should be checked before NFLAG.  One 
		 * can not set min field without setting max field.
		 * If aging is off, force to expire a user password --
		 * set lastchg field to 0.
		*/
		if (flag & MFLAG)  { 	/* set max field */
			if ( maxdays == -1) {
				pwd->pw_age = nullstr; 
			} else  {
				if (*pwd->pw_age == NULL) {  
					minweeks  = 0;
					when = 0;
				} else
					CNV_AGE();
				maxweeks = (maxdays + (DAY_WEEK -1)) / DAY_WEEK;
				maxweeks = maxweeks > DIG_CH ? DIG_CH : maxweeks;
				when = maxweeks + (minweeks << 6) + (when & ~0xfff);
				if (when == 0)
					pwd->pw_age = ".";
				else
					pwd->pw_age = l64a(when);
			}
		}
		if (flag & NFLAG) {   /* set min field */
			if (*pwd->pw_age == NULL)  {
				(void) fprintf(stderr,"%s\n %s", MSG_BS, sausage); 
				(void) unlink(PASSTEMP);
				return (BADSYN);
			}
			CNV_AGE();
			minweeks = (mindays + (DAY_WEEK  - 1)) / DAY_WEEK;
			minweeks = minweeks > DIG_CH ? DIG_CH : minweeks;
			when = maxweeks + (minweeks << 6) + (when & ~0xfff);
			if (when == 0)
				pwd->pw_age = ".";
			else
				pwd->pw_age = l64a(when);
		}
		if (flag & PFLAG)  {	/* change password */
		    if(( ua = getuanam(uname) ) != NULL) {
			us = getusent(ua->ua_uid);
			usr_flag++;
			strncpy( ua->ua_passwd,pw,NAME_MAX );
			us->us_pwdchg = DAY_NOW;
		    }
		    else {
			pwd->pw_passwd = pw;
			if (*pwd->pw_age != NULL) {
				CNV_AGE();
				if (maxweeks  == 0) {   /* turn off aging */
					pwd->pw_age = nullstr;
				} else  {
					when = maxweeks + (minweeks << 6) + (now << 12);
					pwd->pw_age = l64a(when);
				}
			}
		    }

		}
	   }
		if(usr_flag ) {
			if( updateuaent( ua, us, DO_BOTH ) < 0 ) {
				fprintf( stderr, "Cannot update %s\n",USRAUTH );
				return( FMERR );
			}
		}
		if (putpwent (pwd, tpfp) != 0) { 
			(void) unlink(PASSTEMP);
			(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
			return (FMERR);
		}

	}
	(void) fclose (tpfp);
	return(update_pfile(PASSWD,OPASSWD,PASSTEMP));
}

int 
update_pfile(pfilep, opfilep, tpfilep)
char *pfilep;		/* password file */
char *opfilep;		/* old passwd file */
char *tpfilep;		/* temparory password file */
{
	/*
	 *	Rename temp file back to  appropriate passwd file.
	 */

	/* remove old passwd file */
	if (unlink(opfilep) && access(opfilep, 0) == 0) {
		(void) unlink(tpfilep);
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		(void) ulckpwdf();
		return (FMERR);
	}

	/* line password file to old passwd file */
	if (link(pfilep, opfilep)) {
		(void) unlink(tpfilep);
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}

	/* unlink passwd file */
	if (unlink(pfilep)) {
		(void) unlink(tpfilep);
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}

	/* link temparory password file to password file */
	if (link(tpfilep, pfilep)) {
		(void) unlink(pfilep);
		if (link (opfilep, pfilep)) { 
			(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FF);
			return (FATAL);
		}
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}

	/* unlink temparory password file. If fails, don't care because 
	  password file is already updated */

	(void) unlink(tpfilep);
	return(SUCCESS);
}

/************************************************************
 *							    *
 * ua_update(): updates the user_auth password file.	    *
 * It takes "flag" as an argument to determine which        *
 * password attributes to modify. It returns 0 for success  *
 * and  > 0 for failure.			            *
 *							    *
 ***********************************************************/

int
ua_update(flag)
int flag;
{
	register int i;
	extern int errno;
	usrauth_t *ua;	/* pointer to a shadow password entry */
	usrstat_t *us;
	struct stat buf;
	FILE *tsfp;

	/* ignore all the signals */

	for (i=1; i < NSIG; i++)
		(void) sigset(i, SIG_IGN);

 	/* Clear the errno. It is set because SIGKILL can not be ignored. */

	errno = 0;

	/* Mode  of the shadow file should be 400 or 000 */

	if (stat(USRAUTH, &buf) < 0) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FE);
		return (FMERR);
	}

	/*
	 *	copy passwd  files to temps, replacing matching lines
	 *	with new password attributes.
	 */

	/* entry should be there -- we just checked it */

	setuaent();

	while ((ua = getuaent()) != NULL) {

		if ((strcmp(ua->ua_name, uname) == 0) && (ua->ua_acctstat < RETIRE)) { 
			/* LFLAG and DFLAG should be checked before FFLAG.
			   FFLAG clears the sp_lstchg field. We do not
			   want sp_lstchg field to be set if one execute
			   passwd -d -f name or passwd -l -f name.
			*/

			us = getusent(ua->ua_uid);

			if (flag & FMTFLAG ) {
				us->us_pwdchg = DAY_NOW;
				ua->ua_mode &= ~PWGEN_MASK;
				ua->ua_mode += (char) pwfmt;
			}
			if (flag & UNLFLAG ) {
				ua->ua_acctstat = NOLOCK;
			}
			if (flag & LFLAG) {	 /* lock password */
				if ( lkflag == RETIRE )
					ua->ua_acctstat = time((long *)0);
				else
					ua->ua_acctstat = LOCKED;
				us->us_pwdchg = DAY_NOW;
			} 

			if (flag & DFLAG) {	 /* delete password */
				strcpy( ua->ua_passwd,nullstr);
				us->us_pwdchg = DAY_NOW;
			} 
			if (flag & FFLAG)	{ /* expire password attributes*/
				us->us_pwdchg = (long) 0;
				ua->ua_min_pwdlife = 0;
				ua->ua_max_pwdlife = 0;
				ua->ua_acctstat = NOLOCK;
				ua->ua_mode &= ~(NO_PASS_NEED | NO_PASS_CHANGE);
				ua->ua_mode &= ~PWGEN_MASK;
			}
			/*
			 * Check max life first.
			 */
			if (flag & MFLAG)  { 	/* set max field */
				if (maxdays == -1) { 	/* turn off aging */
					ua->ua_max_pwdlife = 0;
					ua->ua_min_pwdlife = 0;
					flag &= ~NFLAG;
				} else {
					if (ua->ua_max_pwdlife == 0)
						us->us_pwdchg = 0;
					ua->ua_max_pwdlife = maxdays;
				}
			}
			if (flag & NFLAG) {   /* set min field */
				if (mindays == -1) {
					ua->ua_min_pwdlife = 0;
					if (ua->ua_max_pwdlife < 0)
						ua->ua_max_pwdlife = 0;
				} else {
					ua->ua_min_pwdlife = mindays;
					if (ua->ua_max_pwdlife < mindays)
						ua->ua_max_pwdlife = mindays;
				}
			}
			if (flag & PFLAG)  {	/* change password */
				strcpy( ua->ua_passwd,pw );
				/* update the last change field */
				us->us_pwdchg = DAY_NOW;
				/* turn off aging */
				if (ua->ua_max_pwdlife == 0) {
					ua->ua_min_pwdlife = 0;
					ua->ua_max_pwdlife = 0;
				}
			}
			if ( updateuaent ( ua, us, DO_BOTH) < 0 ) { 
			    (void) fprintf(stderr, "error from updateuaent\n");
			    return (FMERR);
			}
		return( SUCCESS );

		}
	}

	return( SUCCESS );
}



circ( s, t )
char *s, *t;
{
	char c, *p, *o, *r, buff[25], ubuff[25], pubuff[25];
	int i, j, k, l, m;
	 
	m = 2;
	i = strlen(s);
	o = &ubuff[0];
	for ( p = s; c = *p++; *o++ = c ) 
		if ( islower(c) )
			 c = toupper(c);
	*o = '\0';
	o = &pubuff[0];
	for ( p = t; c = *p++; *o++ = c ) 
		if ( islower(c) ) 
			c = toupper(c);

	*o = '\0';
	 
	p = &ubuff[0];
	while ( m-- ) {
		for ( k = 0; k  <=  i; k++) {
			c = *p++;
			o = p;
			l = i;
			r = &buff[0];
			while (--l) 
				*r++ = *o++;
			*r++ = c;
			*r = '\0';
			p = &buff[0];
			if ( strcmp( p, pubuff ) == 0 ) 
				return (1);
		}
		p = p + i;
		r = &ubuff[0];;
		j = i;
		while ( j-- ) 
			*--p = *r++;
	}
	return (SUCCESS);
}

/********************************************************
 *							*
 * ckarg(): This function parses and verifies the 	*
 * arguments.  It takes two parameters:			*
 * argc => # of arguments				*
 * argv => pointer to an argument			*
 * In case of an error it prints the appropriate error 	*
 * message, sets the retval and returns FAIL(-1).	* 		
 *							*
 ********************************************************/

int
ckarg(argc, argv)
int argc;
char **argv;
{
	extern char *optarg;
	char *char_p;
	register int c, flag = 0;

	while ((c = getopt(argc, argv, "alurdfsx:m:n:")) != EOF) {
		switch (c) {
		case 'm':	/* set the password generator */
			if (ckuid() != 0 )
				return FAIL;
			pwfmt = (int) strtol(optarg, &char_p, 10 );
			if ((pwfmt<0) || (pwfmt>7)) {
				fprintf( stderr, "bad format argument\n" );
				return FAIL;
			}
			flag |= FMTFLAG;
			break;
		case 'u':
			if (ckuid() != 0)
				return (FAIL);
			if (flag & (DFLAG|SAFLAG|LFLAG)) {
				(void) fprintf(stderr, "%s\n %s", MSG_BS, sausage );
				retval = BADSYN;
				return (FAIL);
			}
			flag |= UNLFLAG;
			break;
		case 'r':
		case 'l':		/* lock the password */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag & (DFLAG|SAFLAG))  {
				(void) fprintf(stderr,"%s\n %s", MSG_BS,sausage);
				retval = BADSYN;
				return (FAIL);
			}
			flag |= LFLAG;
			if (c == 'r' ) 
				lkflag = RETIRE; 
			else 
				lkflag = TMPLOCK;
			pw = &lkstring[0];
			break;
		case 'd':	/* delete the password */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag & (LFLAG|SAFLAG)) {
				(void) fprintf(stderr,"%s\n %s", MSG_BS, sausage); 
				retval = BADSYN;
				return (FAIL);
			}
			flag |= DFLAG;
			pw = nullstr;
			break;
		case 'x':		/* set the max date */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag & SAFLAG) {
				(void) fprintf(stderr,"%s\n %s", MSG_BS, sausage);
				retval = BADSYN;
				return (FAIL);
			}
			flag |= MFLAG;
			if ((maxdays = (int) strtol(optarg, &char_p, 10)) < -1
			    || *char_p != '\0' || strlen(optarg)  <= 0) {
				(void) fprintf(stderr, "%s: %s -x\n", prognamep, MSG_NV);
				retval = BADOPT;
				return (FAIL);
			}
			break;
		case 'n':		/* set the min date */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag & SAFLAG) { 
				(void) fprintf(stderr,"%s\n %s", MSG_BS, sausage);
				retval = BADSYN;
				return (FAIL);
			}
			flag |= NFLAG;
			if (((mindays = (int) strtol(optarg, &char_p,10)) < 0 
			    || *char_p != '\0') || strlen(optarg)  <= 0) {
				(void) fprintf(stderr, "%s: %s -n\n", prognamep, MSG_NV);
				retval = BADOPT;
				return (FAIL);
			} 
			break;
		case 's':		/* display password attributes */
			if (flag && (flag != AFLAG)) { 
				(void) fprintf(stderr,"%s %\n", MSG_BS, sausage);
				retval = BADSYN;
				return (FAIL);
			} 
			flag |= SFLAG;
			break;
		case 'a':		/* display password attributes */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag && (flag != SFLAG)) { 
				(void) fprintf(stderr,"%s\n %s", MSG_BS,sausage);
				retval = BADSYN;
				return (FAIL);
			} 
			flag |= AFLAG;
			break;
		case 'f':		/* expire password attributes */
			/* Only privileged process can execute this */
			if (ckuid() != 0)
				return (FAIL);
			if (flag & SAFLAG) { 
				(void) fprintf(stderr,"%s\n %s", MSG_BS, 
				            suserflg ? sausage : usage);
				retval = BADSYN;
				return (FAIL);
			} 
			flag |= FFLAG;
			break;
		case '?':
			(void) fprintf(stderr,"%s", suserflg ? sausage : usage);
			retval = BADSYN;
			return (FAIL);
		}
	}

	argc -=  optind;
	if (argc > 1) {
		fprintf(stderr,"%s", suserflg ? sausage : usage);
		retval = BADSYN;
		return (FAIL);
	}

	/* If no options are specified or only the show option */
	/* is specified, return because no option error checking */
	/* is needed */
	if (!flag || (flag == SFLAG)) 
		return (flag);

	if (flag == AFLAG) {
		(void) fprintf(stderr,"%s", sausage);
		retval = BADSYN;
		return (FAIL);
	}
	if ( flag != SAFLAG && argc < 1 && (flag & (FMTFLAG))) {
		(void) fprintf(stderr,"%s", sausage);
		retval = BADSYN;
		return (FAIL);
	}
	if (flag == SAFLAG && argc >= 1) {
		(void) fprintf(stderr,"%s", sausage);
		retval = BADSYN;
		return (FAIL);
	}
	if ((maxdays == -1) &&  (flag & NFLAG)) {
		(void) fprintf(stderr, "%s: %s -x\n", prognamep, MSG_NV);
		retval = BADOPT;
		return (FAIL);
	}
	return (flag);
}

/******************************************************
 *						      *
 *  pwd_display():  displays password attributes.     * 
 *  It takes user name as a parameter. If the user    *
 *  name is NULL then it displays password attributes *
 *  for all entries on the file. It returns 0 for     *
 * success and positive  number for failure.	      *
 *						      *
 *****************************************************/

int
pwd_display(unamep)
char *unamep;
{
	extern struct tm *gmtime();
	struct tm *tmp;
	int when, maxweeks, minweeks;
	register int found = 0;

	if (unamep != NULL) {
		(void) fprintf(stdout,"%-20s  ",unamep);
		PRT_PWD(pwd->pw_passwd);
		if (*pwd->pw_age != NULL) {
			CNV_AGE();
			when >>= 12;
			if (when) {
				when = when * SEC_WEEK;
				tmp = gmtime (&when);
				(void) fprintf(stdout,"%.2d/%.2d/%.2d  ",(tmp->tm_mon + 1),tmp->tm_mday,tmp->tm_year);
			} else
				(void) fprintf(stdout,"00/00/00  ");
			(void) fprintf(stdout, "%d  %d ", minweeks * DAY_WEEK, maxweeks * DAY_WEEK);
		}
		(void) fprintf(stdout,"\n");
		return (SUCCESS);
	}
	while ((pwd = getpwent()) != NULL) {
		found++;
		(void) fprintf(stdout,"%-20s  ",pwd->pw_name);
		PRT_PWD(pwd->pw_passwd);
		if (*pwd->pw_age != NULL) {
			CNV_AGE();
			when >>= 12;
			if (when) {
				when = when * SEC_WEEK;
				tmp = gmtime (&when);
				(void) fprintf(stdout,"%.2d/%.2d/%.2d  ",(tmp->tm_mon + 1),tmp->tm_mday,tmp->tm_year);
			} else
				(void) fprintf(stdout,"00/00/00  ");
			(void) fprintf(stdout, "%d  %d ", minweeks * DAY_WEEK, maxweeks * DAY_WEEK);
		}
		(void) fprintf(stdout,"\n");
	}
	/* If password files do not have any entries or files are missing, 
	   return fatal error.
	*/

	if (found == 0) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FF);
		return (FATAL);
	}
	return (SUCCESS);
}

/******************************************************
 *						      *
 *  ua_display():  displays password attributes.      * 
 *  It takes user name as a parameter. If the user    *
 *  name is NULL then it displays password attributes *
 *  for all entries on the file. It returns 0 for     *
 * success and positive  number for failure.	      *
 *						      *
 *****************************************************/

int
ua_display(unamep)
char *unamep;
{
	extern struct tm *gmtime();
	struct tm *tmp;
	usrauth_t *ua;
	struct passwd  *pwdp;
	register int found = 0;
	long lstchg;

	if (unamep != NULL) {
		if ((getpwnam(unamep) != NULL) && ((ua = getuanam(unamep)) != NULL)) {
			(void) fprintf(stdout,"%s  ",unamep);
			PRT_PWD(ua->ua_passwd);
			PRT_AGE();

			PRT_STATUS(ua->ua_acctstat);
			PRT_MODE(ua->ua_mode);

			(void) fprintf(stdout,"\n");
			return (SUCCESS);
		} 
		(void) fprintf(stderr, " %s: uname %s does not exist\n", prognamep, unamep);
		return (NOPERM);
	} 
	while ((pwdp = getpwent()) != NULL)
		if ((ua = getuanam(pwdp->pw_name)) != NULL) {
			found++;
			(void) fprintf(stdout,"%s  ",pwdp->pw_name);
			PRT_PWD(ua->ua_passwd);
			PRT_AGE();
		
			PRT_STATUS(ua->ua_acctstat);
			PRT_MODE(ua->ua_mode);

			(void) fprintf(stdout,"\n");
		}
	/* If password files do not have any entries or files are missing, 
	   return fatal error.
	*/

	if (found == 0) {
		(void) fprintf(stderr, "%s: %s\n", prognamep, MSG_FF);
		return (FATAL);
	}
	return (SUCCESS);
}
int
ckuid()
{
	if ( !suserflg ) {
		(void) fprintf(stderr,"%s: %s\n", prognamep, MSG_NP);
		return (retval = NOPERM); 
	} 
	return (SUCCESS);
}

char *killlf( buf )
char *buf;
{
char *p, *strchr();

	if ( p = strchr( buf, '\n' ))
		*p = 0;
        return buf;
}
