/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) utilprof.c: version 25.1 created on 12/2/91 at 16:45:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)utilprof.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>
#include	<values.h>
#include	<auth.h>
#include	"userprof.h"
#include	"loadprof.h"
#include	"passmgmt.h"

prof_flag(id)
{
register prof_t	*ptab;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id)
			return (ptab->pr_flag);
		ptab++;
	}
	return (PR_FLAG_NONE);
}

prof_int(id)
{
register prof_t	*ptab;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id)
			return (ptab->pr_int);
		ptab++;
	}
	return (-1);
}

char *
prof_str(id)
{
register prof_t	*ptab;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id)
			return (strdup(ptab->pr_str));
		ptab++;
	}
	return (NULL);
}

uid_t
prof_uid(id)
{
register prof_t	*ptab;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id)
			return (ptab->pr_uid);
		ptab++;
	}
	return ((uid_t)-1);
}

gid_t
prof_gid(id)
{
register prof_t	*ptab;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id)
			return (ptab->pr_gid);
		ptab++;
	}
	return ((gid_t)-1);
}

prof_role(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
register int		role;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if ((role = chk_role(ptab->pr_str)) < 0)
				return (-1);
			ua_st->ua_role = role;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_pwmode(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
register int		mode;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if ((mode = chk_pwmode(ptab->pr_str)) < 0)
				return (-1);
			ua_st->ua_mode &= ~MODE_MASK;
			ua_st->ua_mode |= (mode << MODE_SHIFT) & MODE_MASK;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_pwgen(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
register int		pwgen;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if ((pwgen = chk_pwgen(ptab->pr_str)) < 0)
				return (-1);
			ua_st->ua_mode &= ~PWGEN_MASK;
			ua_st->ua_mode |= AUTO_PASS(pwgen);
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_stat(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
register int		stat;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if ((stat = chk_stat(ptab->pr_str)) < 0)
				return (-1);
			ua_st->ua_acctstat = (time_t)stat;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_amask(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
int			amask[2];

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			prof_compact(ptab->pr_str);
			if (chk_amask(ptab->pr_str,&amask[0]) < 0)
				return (-1);
			ua_st->ua_amask[0] = amask[0];
			ua_st->ua_amask[1] = amask[1];
			return (0);
		}
		ptab++;
	}
	return (-1);
}

#define	set_twin(x,sh,sm,eh,em)	{ \
	(x).st_hr=(sh); \
	(x).st_min=(sm); \
	(x).et_hr=(eh); \
	(x).et_min=(em); \
}

prof_times(id,ua_st)
register usrauth_t	*ua_st;
{
register prof_t		*ptab;
register char		*sl, *el, *p, *tl, *tmp;
register int		i;

	ptab = &prof_all[0];
	tl = NULL;
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			tl = ptab->pr_str;
			break;
		}
		ptab++;
	}
	if (tl == NULL)
		return (-1);
	i = 0;
	while (tl && *tl && (i < 7)) {
		tmp = tl;
		if (tl = strchr(tl,',')) 
			*tl++ = 0;
		/*
		 * check for NULL in string
		 */
		if (*tmp == NULL) {
			set_twin(ua_st->ua_times[i],0,0,0,0);
			i++;
			continue;
		}
		/*
		 * check for '*' in string
		 */
		if (*tmp == '*') {
			set_twin(ua_st->ua_times[i],0,0,24,0);
			i++;
			continue;
		}
		/*
		 * split times into two halves
		 */
		if (!(p = strchr(tmp,'-')))
			return (-1);
		*p++ = 0;
		sl = strchr(tmp,':');
		el = strchr(p,':');
		/*
		 * check for no mins in time
		 */
		if (!sl && !el) {
			set_twin(ua_st->ua_times[i],(char) atoi(tmp),0,
				(char) atoi(p),0);
		} else	{
			*sl++;	/* skip ':'	*/
			*el++;	/* skip ':'	*/
			/*
			 * check for mins in time
			 */
			if (sl && el) {
				set_twin(ua_st->ua_times[i],
					(char) atoi(tmp),(char) atoi(sl),
					(char) atoi(p),(char) atoi(el));
			} else	{
				/*
				 * check for start mins only & no end mins
				 */
				if (!sl && el) {
					set_twin(ua_st->ua_times[i],
						(char) atoi(tmp),0,
						(char) atoi(p),
						(char) atoi(el));
				} else	{
					/*
					 * check for not start mins & end mins
					 */
					if (sl && !el) {
						set_twin(ua_st->ua_times[i],
							(char) atoi(tmp),
							(char) atoi(sl),
							(char) atoi(p),0);
					} else	{
fprintf(stderr,
	"setprof: prof_times: error converting profile UA_ACCESS_TIMES\n");
					}
				}
			}
		}
		i++;
	}
	return (0);
}

prof_sak(id,ta_st)
register ttyauth_t	*ta_st;
{
register prof_t		*ptab;
register int		role;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if (chk_sak(ptab->pr_str,ta_st) < 0)
				return (-1);
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_min_label(id,ta_st)
register ttyauth_t	*ta_st;
{
register prof_t		*ptab;
register int		role;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if (chk_min_label(ptab->pr_str,ta_st) < 0)
				return (-1);
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_max_label(id,ta_st)
register ttyauth_t	*ta_st;
{
register prof_t		*ptab;
register int		role;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if (chk_max_label(ptab->pr_str,ta_st) < 0)
				return (-1);
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_add_tausers(id)
{
register prof_t		*ptab;
register int		uid;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			uid = chk_tausers(ptab->pr_str);
			if ((uid < 0) && (uid != TA_USERS_ALL))
				return (-1);
			glob_add_uid = (uid_t) uid;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_del_tausers(id)
{
register prof_t		*ptab;
register int		uid;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			uid = chk_tausers(ptab->pr_str);
			if ((uid < 0) && (uid != TA_USERS_ALL))
				return (-1);
			glob_del_uid = (uid_t) uid;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_add_tagroups(id)
{
register prof_t		*ptab;
register int		gid;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			gid = chk_tagroups(ptab->pr_str);
			if ((gid < 0) && (gid != TA_GROUPS_ALL))
				return (-1);
			glob_add_gid = (gid_t) gid;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_del_tagroups(id)
{
register prof_t		*ptab;
register int		gid;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			gid = chk_tagroups(ptab->pr_str);
			if ((gid < 0) && (gid != TA_GROUPS_ALL))
				return (-1);
			glob_del_gid = (gid_t) gid;
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_devlist(id)
{
register prof_t		*ptab;
register int		gid;

	ptab = &prof_all[0];
	while (ptab->pr_name) {
		if (ptab->pr_id == id) {
			if (chk_devlist(ptab->pr_str) < 0)
				return (-1);
			return (0);
		}
		ptab++;
	}
	return (-1);
}

prof_match(p,vtab)
register char		*p;
register valtab_t	*vtab;
{
	if (vtab) {
		while (vtab->val_name) {
			if (strcmp(vtab->val_name,p) == 0)
				return (vtab->val_value);
			vtab++;
		}
	}
	return (-1);
}

prof_compact(p)
register char	*p;
{
register char	*p2;

	if (p) {
		while (*p) {
			if ((*p == ' ') || (*p == '\t')) {
				p2 = p;
				while (*p2) {
					*p2 = *(p2+1);
					p2++;
				}
			} else	{
				p++;
			}
		}
	}
}

mkupper(p)
register char	*p;
{
	if (p) {
		while (*p) {
			if ((*p >= 'a') && (*p <= 'z'))
				*p = TOUPPER(*p);
			p++;
		}
	}
}

mkupperlen(p,len)
register char	*p;
{
	if (p) {
		while (*p && len--) {
			if ((*p >= 'a') && (*p <= 'z'))
				*p = TOUPPER(*p);
			p++;
		}
	}
}

bzero(p,size)
register char	*p;
register int	size;
{
	while (size > 0) {
		*p = '\0';
		p++;
		size--;
	}
}
