/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) userprof.h: version 25.1 created on 12/2/91 at 16:45:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)userprof.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifndef	USERPROF_T
#define	USERPROF_T

#if	!__STRICT_STDC__
#define	TOUPPER	_toupper
#else	/* !__STRICT_STDC__ */
#define	TOUPPER	toupper
#endif	/* !__STRICT_STDC__ */

/*
 * The full pathname of home of the profile files.
 */
#define	PROFILE_PATH	"/etc/default"

/*
 * The environment variable name whose value overrides PROFILE_PATH above.
 */
#define	EPROFILE_PATH	"PROFILE_PATH"

/*
 * The default profile name if none was specified.
 */
#define	DEF_PROFILE	"userprof"

/*
 * The default device directory name if none was specified.
 */
#define	DEF_DEVDIR	"/dev/"

#define	PROFNAMESZ	32
#define	PROFLINESZ	2048	/* keep large for device list	*/
#define	NUADEVS		256	/* device list			*/
#define	DEVSKIP		4	/* skip first N entries		*/
#define	DAYS_YR		365
#define	DAYS_WK		7

typedef	struct	valtab {
	char	*val_name;
	int	val_value;
} valtab_t;

typedef	struct	profile	{
	/* definition section */
	char 	*pr_name;
	uint	pr_id;
	uint	pr_type;
	uint	pr_int_max;
	/* section for return values */
	uint	pr_flag;
	union	{
		int	pru_int;
		char 	*pru_str;
		uid_t	pru_uid;
		gid_t	pru_gid;
	} pr_vals;
} prof_t;

/*
 * Some defines to get rid of the union.
 */
#define	pr_int		pr_vals.pru_int
#define	pr_str		pr_vals.pru_str
#define	pr_uid		pr_vals.pru_uid
#define	pr_gid		pr_vals.pru_gid

/*
 * Possible values for the pr_type.
 */
#define	PR_UNFORMATED	0	/* unconverted string from profile file	*/
#define	PR_INT		1	/* for integers				*/
#define	PR_STR		2	/* character pointer to string		*/
#define	PR_UID		3	/* when uid values are changed		*/
#define	PR_GID		4	/* when gid values are changed		*/
#define	PR_ROLE		5	/* when role values are changed		*/
#define	PR_MODE		6	/* when pwd mode bits are changed	*/
#define	PR_PWGEN	7	/* when pwd generator is changed	*/
#define	PR_STAT		8	/* when account status is changed	*/
#define	PR_AMASK	9	/* when audit mask values are changed	*/
#define	PR_TIMES	10	/* to be converted to twin_t structure	*/
#define	PR_SAK		11	/* when SAK flags are changed		*/
#define	PR_LABEL	12	/* when security labels are changed	*/
#define	PR_USERS	13	/* when users list is changed		*/
#define	PR_GROUPS	14	/* when groups list is changed		*/
#define	PR_DEVLIST	15	/* when device list is changed		*/

/*
 * Possible values for the pr_flag.
 */
#define	PR_FLAG_NONE	0	/* not present in profile file		*/
#define	PR_FLAG_NULL	1	/* present in profile file but no value	*/
#define	PR_FLAG_DEFINED	2	/* has a value in the profile file	*/

/*
 * Tag ids for usr_auth fields.
 */
#define	UA_USER_ID		0
#define	UA_GROUP_NAME		1
#define	UA_GROUP_ID		2
#define	UA_GECOS		3
#define	UA_HOME_PATH		4
#define	UA_HOME_DIR		5
#define	UA_SHELL		6
#define	UA_ROLE			7
#define	UA_PASSWORD_MODE	8
#define	UA_PASSWORD_GEN		9
#define	UA_MIN_PASSWORD_LIFE	10
#define	UA_MAX_PASSWORD_LIFE	11
#define	UA_MAX_LOGIN_TRIES	12
#define	UA_ACCT_STATUS		13
#define	UA_AUDIT_MASK		14
#define	UA_ACCESS_TIMES		15
#define	UA_DEVICE_LIST		16

/*
 * Tag ids for dev_auth fields.
 */
#define	TA_MAX_LOGIN_TRIES	50
#define	TA_DELAY		51
#define	TA_SAK_KEYS		52
#define	TA_MAX_INACTIVE		53
#define	TA_MIN_LABEL		54
#define	TA_MAX_LABEL		55
#define	TA_ADD_USERS		56
#define	TA_DEL_USERS		57
#define	TA_ADD_GROUPS		58
#define	TA_DEL_GROUPS		59

#endif	/* USERPROF_T */
