/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setprof.c: version 25.1 created on 12/2/91 at 16:45:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setprof.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include	<auth.h>
#include	<pwd.h>
#include	<grp.h>
#include	"passmgmt.h"
#include	"userprof.h"
#include	"loadprof.h"

extern	uint	optn_mask;	/* from passmgmt.c	*/

setuausprof(pname,logname,pwd_st,ua_st,us_st,info_mask)
register char		*pname, *logname;
register struct	passwd	*pwd_st;
register usrauth_t	*ua_st;
register usrstat_t	*us_st;
register uint		info_mask;
{
register struct	group	*grp;
register char		*gname, *p;
register gid_t		gid;

	if (info_mask & UAUTH_PROFILE) {
		if (!(info_mask & PROFILE_LOADED)) {
			if ((p = getenv(EPROFILE_PATH)) == NULL)
				strcpy(profile_path,PROFILE_PATH);
			else
				strcpy(profile_path,p);
			strcat(profile_path,"/");
			if (pname && *pname) {
				if (*pname == '/')
					strcpy(profile_path,pname);
				else
					strcat(profile_path,pname);
			} else
				strcat(profile_path,DEF_PROFILE);
			if (loadprof(profile_path) <= 0)
				return (-1);
			if (fillprof(prof_all) <= 0)
				return (-1);
			info_mask |= PROFILE_LOADED;
		}
		if (prof_flag(UA_USER_ID) == PR_FLAG_DEFINED) {
			pwd_st->pw_uid = prof_uid(UA_USER_ID);
			optn_mask |= UA_MASK_u;
			optn_mask |= UA_MASK_o;	/* override unique id check */
		}
		if (prof_flag(UA_GROUP_NAME) == PR_FLAG_DEFINED) {
			gname = prof_str(UA_GROUP_NAME);
			if ((grp = getgrnam(gname)) != NULL) {
				pwd_st->pw_gid = grp->gr_gid;
				optn_mask |= UA_MASK_g;
			} else	{
fprintf(stderr,"passmgmt: invalid group name '%s' in profile '%s'\n",
	gname,profile_path);
			}
		}
		/*
		 * By testing for group id after testing for group name we
		 * force group id to override group name.
		 */
		if (prof_flag(UA_GROUP_ID) == PR_FLAG_DEFINED) {
			gid = prof_gid(UA_GROUP_ID);
			if ((grp = getgrgid(gid)) != NULL) {
				pwd_st->pw_gid = grp->gr_gid;
				optn_mask |= UA_MASK_g;
			} else	{
fprintf(stderr,"passmgmt: invalid group id %d in profile '%s'\n",
	(uint)gid,profile_path);
				if (optn_mask & UA_MASK_g) {
fprintf(stderr,"          however, group name '%s' is still in effect\n",
	gname);
				}
			}
		}
		if (prof_flag(UA_GECOS) == PR_FLAG_DEFINED) {
			pwd_st->pw_gecos   = prof_str(UA_GECOS); 
			pwd_st->pw_comment = pwd_st->pw_gecos; 
			optn_mask |= UA_MASK_c;
		}
		if (prof_flag(UA_HOME_PATH) == PR_FLAG_DEFINED) {
			register char	*p, *up, *ud;

			up = prof_str(UA_HOME_PATH);
			if (prof_flag(UA_HOME_DIR) == PR_FLAG_DEFINED)
				ud = prof_str(UA_HOME_DIR);
			else
				ud = logname;
			p = (char *)malloc(strlen(up) + strlen(ud) + 2);
			if (p) {
				strcpy(p,up);
				strcat(p,"/");
				strcat(p,ud);
				pwd_st->pw_dir = p;
				optn_mask |= UA_MASK_h;
			}
		}
		if (prof_flag(UA_SHELL) == PR_FLAG_DEFINED) {
			pwd_st->pw_shell = prof_str(UA_SHELL);
			optn_mask |= UA_MASK_s;
		}
		if (info_mask & UAUTH_FLAG) {
			ua_st->ua_uid = pwd_st->pw_uid;
			us_st->us_uid = ua_st->ua_uid;
			ua_st->ua_gid = pwd_st->pw_gid;
			strncpy(ua_st->ua_gecos,pwd_st->pw_gecos,MAXCOMMENT); 
			strncpy(ua_st->ua_defdir,pwd_st->pw_dir,MAXPATH);
			strncpy(ua_st->ua_defshell,pwd_st->pw_shell,MAXPATH);
			if (prof_flag(UA_ROLE) == PR_FLAG_DEFINED) {
				if (prof_role(UA_ROLE,ua_st) >= 0)
					optn_mask |= UA_MASK_R;
			}
			if (prof_flag(UA_PASSWORD_MODE) == PR_FLAG_DEFINED) {
				if (prof_pwmode(UA_PASSWORD_MODE,ua_st) >= 0)
					optn_mask |= UA_MASK_M;
			}
			if (prof_flag(UA_PASSWORD_GEN) == PR_FLAG_DEFINED) {
				if (prof_pwgen(UA_PASSWORD_GEN,ua_st) >= 0)
					optn_mask |= UA_MASK_G;
			}
			if (prof_flag(UA_MIN_PASSWORD_LIFE) == PR_FLAG_DEFINED){
				ua_st->ua_min_pwdlife =
					prof_int(UA_MIN_PASSWORD_LIFE);
				optn_mask |= UA_MASK_p;
			}
			if (prof_flag(UA_MIN_PASSWORD_LIFE) == PR_FLAG_DEFINED){
				ua_st->ua_max_pwdlife =
					prof_int(UA_MAX_PASSWORD_LIFE);
				optn_mask |= UA_MASK_P;
			}
			if (prof_flag(UA_MAX_LOGIN_TRIES) == PR_FLAG_DEFINED) {
				ua_st->ua_maxtries =
					prof_int(UA_MAX_LOGIN_TRIES);
				optn_mask |= UA_MASK_x;
			}
			if (prof_flag(UA_ACCT_STATUS) == PR_FLAG_DEFINED) {
				if (prof_stat(UA_ACCT_STATUS,ua_st) >= 0)
					optn_mask |= UA_MASK_A;
			}
			if (prof_flag(UA_AUDIT_MASK) == PR_FLAG_DEFINED) {
				if (prof_amask(UA_AUDIT_MASK,ua_st) >= 0)
					optn_mask |= UA_MASK_k;
			}
			if (prof_flag(UA_ACCESS_TIMES) == PR_FLAG_DEFINED) {
				if (prof_times(UA_ACCESS_TIMES,ua_st) >= 0)
					optn_mask |= UA_MASK_T;
			}
			if (prof_flag(UA_DEVICE_LIST) == PR_FLAG_DEFINED) {
				if (prof_devlist(UA_DEVICE_LIST) >= 0)
					optn_mask |= UA_MASK_D;
			}
		}
	}
	return (0);
}

settatsprof(pname,ta_st,ts_st,info_mask)
register char		*pname;
register ttyauth_t	*ta_st;
register ttystat_t	*ts_st;
register uint		info_mask;
{
register char		*p;
register int		val;

	if (info_mask & TAUTH_PROFILE) {
		if (!(info_mask & PROFILE_LOADED)) {
			if ((p = getenv(EPROFILE_PATH)) == NULL)
				strcpy(profile_path,PROFILE_PATH);
			else
				strcpy(profile_path,p);
			strcat(profile_path,"/");
			if (pname && *pname) {
				if (*pname == '/')
					strcpy(profile_path,pname);
				else
					strcat(profile_path,pname);
			} else
				strcat(profile_path,DEF_PROFILE);
			if (loadprof(profile_path) <= 0)
				return (-1);
			if (fillprof(prof_all) <= 0)
				return (-1);
			info_mask |= PROFILE_LOADED;
		}
		if (info_mask & TAUTH_FLAG) {
			if (prof_flag(TA_MAX_LOGIN_TRIES) == PR_FLAG_DEFINED) {
				ta_st->ta_maxtry = prof_int(TA_MAX_LOGIN_TRIES);
				optn_mask |= TA_MASK_r;
			}
			if (prof_flag(TA_DELAY) == PR_FLAG_DEFINED) {
				ta_st->ta_delay = prof_int(TA_DELAY);
				optn_mask |= TA_MASK_D;
			}
			if (prof_flag(TA_SAK_KEYS) == PR_FLAG_DEFINED) {
				if (prof_sak(TA_SAK_KEYS,ta_st) >= 0)
					optn_mask |= TA_MASK_k;
			}
			if (prof_flag(TA_MAX_INACTIVE) == PR_FLAG_DEFINED) {
				ta_st->ta_inactive = prof_int(TA_MAX_INACTIVE);
				optn_mask |= TA_MASK_i;
			}
			if (prof_flag(TA_MIN_LABEL) == PR_FLAG_DEFINED) {
				if (prof_min_label(TA_MIN_LABEL,ta_st) >= 0)
					optn_mask |= TA_MASK_b;
			}
			if (prof_flag(TA_MAX_LABEL) == PR_FLAG_DEFINED) {
				if (prof_max_label(TA_MAX_LABEL,ta_st) >= 0)
					optn_mask |= TA_MASK_B;
			}
			if (prof_flag(TA_ADD_USERS) == PR_FLAG_DEFINED) {
				if (prof_add_tausers(TA_ADD_USERS) >= 0)
					optn_mask |= TA_MASK_u;
			}
			if (prof_flag(TA_DEL_USERS) == PR_FLAG_DEFINED) {
				if (prof_del_tausers(TA_DEL_USERS) >= 0)
					optn_mask |= TA_MASK_U;
			}
			if (prof_flag(TA_ADD_GROUPS) == PR_FLAG_DEFINED) {
				if (prof_add_tagroups(TA_ADD_GROUPS) >= 0)
					optn_mask |= TA_MASK_g;
			}
			if (prof_flag(TA_DEL_GROUPS) == PR_FLAG_DEFINED) {
				if (prof_del_tagroups(TA_DEL_GROUPS) >= 0)
					optn_mask |= TA_MASK_G;
			}
		}
	}
	return (0);
}
