/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setdefs.c: version 25.2 created on 1/24/92 at 15:29:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setdefs.c	25.2	1/24/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <values.h>
#include <pwd.h>
#include <string.h>
#include <auth.h>
#include "loaddefs.h"
#include "passmgmt.h"

#define set_twin(x, sh, sm, eh, em)	{ \
	(x).st_hr=sh; \
	(x).st_min=sm; \
	(x).et_hr=eh; \
	(x).et_min=em; \
}

static	char	nullstr[] = "";	/* null string */
static	char	pwdflr[] = "*";	/* password string for /etc/passwd */
static  char    shlstr[] = "/bin/sh"; /* Default shell */

struct	default_values	defs[DEFAULT_MAX];

setuausdefs(pwd_st,ua_st,us_st,info_mask)
register struct	passwd	*pwd_st;
register usrauth_t	*ua_st;
register usrstat_t	*us_st;
register uint		info_mask;
{
register int		indx;

	load_defs(AUTH_DEFAULT_FILE);

	pwd_st->pw_name		= nullstr;	/* login name */
	pwd_st->pw_passwd	= pwdflr;	/* bogus password */
	pwd_st->pw_uid		= -1;		/* no uid */

	if (defs_flag(LOGIN_GROUP)) 		/* check for default */
		pwd_st->pw_gid	= defs_gid(LOGIN_GROUP);
	else
		pwd_st->pw_gid	= 1;		/* default gid */

	pwd_st->pw_age		= nullstr;	/* no aging info. */
	pwd_st->pw_comment	= nullstr;	/* no comments */
	pwd_st->pw_gecos	= nullstr;

	if (defs_flag(HOME_DIR))		/* check for default */
		pwd_st->pw_dir	= defs_char(HOME_DIR);
	else
		pwd_st->pw_dir	= nullstr;	/* no default directory */

	if (defs_flag(SHELL))			/* check for default */
		pwd_st->pw_shell = defs_char(SHELL);
	else
		pwd_st->pw_shell = shlstr;	/* no default shell */

	if (UAUTH_FLAG & info_mask) {		/* if user_auth is running */
		ua_st->ua_name[0] = 0;		/* no name */
		ua_st->ua_uid = pwd_st->pw_uid;
		if (defs_flag(LOGIN_GROUP)) 	/* check for default */
			ua_st->ua_gid = defs_gid(LOGIN_GROUP);
		else
			ua_st->ua_gid = pwd_st->pw_gid;
		ua_st->ua_passwd[0] = 0;
		strncpy(ua_st->ua_gecos,pwd_st->pw_gecos,MAXCOMMENT);

		if (defs_flag(HOME_DIR))	/* check for default */
			strncpy(ua_st->ua_defdir,defs_char(HOME_DIR),MAXPATH);
		else				/* no default directory */
			strncpy(ua_st->ua_defdir,pwd_st->pw_dir,MAXPATH);

		if (defs_flag(SHELL))		/* check for default */
			strncpy(ua_st->ua_defshell,defs_char(SHELL),MAXPATH);
		else
			strcpy(ua_st->ua_defshell, pwd_st->pw_shell);/* no default shell */

		ua_st->ua_role = USR_ROLE;
		ua_st->ua_mode = 0;

		if (defs_flag(PASSWORD_MIN))	/* check for default */
			ua_st->ua_min_pwdlife = defs_int(PASSWORD_MIN);
		else
			ua_st->ua_min_pwdlife = 0;

		if (defs_flag(PASSWORD_MAX))	/* check for default */
			ua_st->ua_max_pwdlife = defs_int(PASSWORD_MAX);
		else
			ua_st->ua_max_pwdlife = 0;

		if (defs_flag(UNSUCCESS_LOGIN_MAX))
			ua_st->ua_maxtries = defs_int(UNSUCCESS_LOGIN_MAX);
		else
			ua_st->ua_maxtries = 7;

		ua_st->ua_acctstat = NOLOCK;

		for (indx = 0; indx < 2; indx++)
			ua_st->ua_amask[indx] = 0;

		if (defs_flag(ACCESS_TIMES)) {
			register char	*sl, *el, *p, *tl, *tmp;
			register int	i;

			tl = defs_char(ACCESS_TIMES);
			i  = 0;
			while (tl) {
				tmp = tl;
				if (tl = strchr(tl, ','))
					*tl++ = 0;
				/* check for NULL in string */
				if (*tmp == NULL) {
					set_twin(ua_st->ua_times[i],0,0,0,0);
					continue;
				}
				/* check for * in string */
				if (*tmp == '*') {
					set_twin(ua_st->ua_times[i],0,0,24,0);
					continue;
				}
				/* split times into two halves */
				if (!(p = strchr(tmp, '-')))
					return NULL;
				*p++ = 0;
				sl = strchr(tmp, ':');
				el = strchr(p, ':');
				/* check for no mins in time */
				if ((!sl) && (!el)) {
					set_twin(ua_st->ua_times[i],
						(char) atoi(tmp),0,
						(char) atoi(p),0);
				} else {
					*sl++;
					*el++;
					/* check for mins in time */
					if ((sl) && (el)) {
						set_twin(ua_st->ua_times[i],
							(char) atoi(tmp),
							(char) atoi(sl),
							(char) atoi(p),
							(char) atoi(el));
					}
					/*
					 * check for start mins only &
					 * no end mins
					 */
					else if ((!sl) && (el)) {
						set_twin(ua_st->ua_times[i],
							(char) atoi(tmp),0,
							(char) atoi(p),
							(char) atoi(el));
						}
						/*
						 * check for not start mins &
						 * end mins
						 */
						else if ((sl) && (!el)) {
						set_twin(ua_st->ua_times[i],
								(char)atoi(tmp),
								(char)atoi(sl),
								(char)atoi(p),
								0);
							} else {
fprintf(stderr,"passmgmt: error converting default file ACCESS_TIMES\n");
							}
					}
				i++;
			}
		} else	{
			set_twin(ua_st->ua_times[0],0,0, 0, 0);	/* Sunday */
			set_twin(ua_st->ua_times[1],8,0,17, 0);	/* Monday */
			set_twin(ua_st->ua_times[2],8,0,17, 0);	/* Tuesday */
			set_twin(ua_st->ua_times[3],8,0,17, 0);	/* Wednesday */
			set_twin(ua_st->ua_times[4],8,0,17, 0);	/* Thursday */
			set_twin(ua_st->ua_times[5],8,0,17, 0);	/* Friday */
			set_twin(ua_st->ua_times[6],0,0, 0, 0);	/* Saturday */
		}
		us_st->us_uid = ua_st->ua_uid;
		us_st->us_lastlogin = 0;
		us_st->us_last_try = 0;
		us_st->us_pwdchg = DAY_NOW;
		us_st->us_lastsu = 0;
		us_st->us_lastbadsu = 0;
		us_st->us_lastnetlogin = 0;
		us_st->us_badtries = 0;
		us_st->us_reason_failed = 0;
		us_st->us_ttyn[0] = 0;
		us_st->us_ttyn_try[0] = 0;
		us_st->us_ttyn_su[0] = 0;
		us_st->us_ttyn_badsu[0] = 0;
		us_st->us_host[0] = '\0';
		us_st->us_name[0] = '\0';
	}
	return (0);
}

settatsdefs(ta_st,ts_st,info_mask)
register ttyauth_t	*ta_st;
register ttystat_t	*ts_st;
register uint		info_mask;
{
register int	indx;

	if (info_mask & TAUTH_FLAG) {
		ta_st->ta_ttyn[0] = '\0';
		ta_st->ta_maxtry = 7;
		ta_st->ta_delay = 0;
		ta_st->ta_sak.flags    = SAK_CARR; /* SAK definition flags    */
		ta_st->ta_sak.sak_key1 = 0; /* 1st SAK key if SAK_KEYS */
		ta_st->ta_sak.sak_key2 = 0; /* 2nd SAK key if SAK_KEYS */
		ta_st->ta_sak.sak_key3 = 0; /* 3rd SAK key if SAK_KEYS */
		ta_st->ta_inactive = 0;
		ta_st->ta_status = 0;
		ta_st->ta_tsentry = 0;
		ta_st->ta_minlabel.level = 0;
		ta_st->ta_maxlabel.level = 0;
		for (indx = 0; indx < MAXCATLST; indx++) {
			ta_st->ta_minlabel.catlst[indx] = 0;
			ta_st->ta_maxlabel.catlst[indx] = 0;
		}
		for (indx = 0; indx < MAXUG; indx++) {
			ta_st->ta_users[indx]  = -1;
			ta_st->ta_groups[indx] = -1;
		}
		ts_st->ts_lastlogin = 0;
		ts_st->ts_lasttry = 0;
		ts_st->ts_lastuid = -1;
		ts_st->ts_tries = 0;
		ts_st->ts_reason_failed = 0;
	}
}
