/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sendroles.c: version 25.1 created on 12/2/91 at 16:45:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sendroles.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/security.h>
#include	<stdio.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<auth.h>

#define	UID		"/dev/uids"

#define	SYNC_DEV_UIDS	1
#define	APPEND_UIDS	0

kern_uidmap_t	k_uid[500];

uint
read_dev_uid(k_uid, count)
kern_uidmap_t 	*k_uid;
uint		*count;
{
	int	fd;

	*count = 0;
	if (( fd = open(UID, O_RDONLY)) < 0 ) {
		fprintf(stderr, "passmgmt: Cannot open %s\n",UID);
		return(0);
	}
	errno = 0;
	while (read(fd, (k_uid + *count), sizeof(kern_uidmap_t)) > 0) 
		(*count)++;
	if (errno) {
		perror("passmgmt: error reading uid data!");
		return(0);
	}
	close( fd );
	return(1);
}

uint
write_dev_uid(k_uid, count)
kern_uidmap_t 	*k_uid;
uint		count;
{
	int	fd;

	if ( ( fd = open(UID,O_WRONLY) ) < 0 ) {
		fprintf(stderr, "Cannot open %s\n",UID);
		return(0);
	}
	if (write(fd, k_uid, (sizeof(*k_uid) * count)) < 0 ) {
		fprintf(stderr, "Cannot write role structures errno %d\n",
			errno);
		return(0);
	}
	close(fd);
	return(1);
}

dump_dev_uid()
{
	uint		count;
	uint		ndx = 0;

	read_dev_uid(k_uid, &count);
	printf("\nDUMP of /dev/uids, %d entries.\n", count);
	printf("------------------------------------\n");
	for (ndx = 0; ndx < count; ndx++) {

		printf("%d. uid: %d ", ndx, k_uid[ndx].uid);
		printf("role: %d ", k_uid[ndx].role);
		printf("status: %d\n", k_uid[ndx].status);
	}
	exit(1);
}

sendroles()
{
	usrauth_t *ua, *getuaent();
	kern_uidmap_t ku;
	int fd;
	uint uid_ndx = 0;

	/*
	 * Synchronize kernel with usr_auth.
	 *
	 * Basically, Get all current usr_auth entries, update the kernel
	 *	      by writing relevent information.
	 */
	setuaent();
	while ((ua = getuaent()) != NULL) {
		k_uid[uid_ndx].uid  = ua->ua_uid;
		k_uid[uid_ndx].role = ua->ua_role;
		k_uid[uid_ndx].status = 0;
		++uid_ndx;
	}
	if (!write_dev_uid(k_uid, uid_ndx))
		return ( -1 );
	enduaent();
	return (1); /* Completed a writing the roles */
}
