/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sendamask.c: version 25.1 created on 12/2/91 at 16:45:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sendamask.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/synch.h>
#include	<sys/security.h>
#include	<sys/audit.h>
#include	<sys/priv.h>

#define	addmask(m,a)	(((a)<32) ? (m[0]|=(1<<(a))) : (m[1]|=(1<<((a)-32))))

/*
 *	sendamask	download the audit event mask.
 *			This allows the admin to custom the events recorded
 *			to only those that are pertinent.
 *			Stolen from auditc.c - written by jtof
 */
sendamask(amask)
uint	*amask;
{
aud_state_t	aud_info;

	if (amask[0] || amask[1]) {
		if (audit_status(&aud_info))
			return (1);
		if (amask[0])
			amask[0] |= aud_info.mask[0];
		if (amask[1])
			amask[1] |= aud_info.mask[1];
	}
	if (audit_set_mask(amask))
		return (-1);
	return (0);
}

/*
 *	parseamask   the mask is passed to the utility as a string in the
 *		     form of comma seperated ranges or values. Examples
 *		     would be 1-3,5,6,10-20. Note that this parser can't
 *		     tolerate any spaces !
 */
parseamask(buf,amask)
char	*buf;
uint	*amask;
{
char	*p, *rp, *tmp, *strchr();
uint	val1, val2, i;

	p = buf;
	if (!p || !isdigit(*p)) {
		amask[0] = amask[1] = 0;
		return (-1);
	}
	while (p && *p) {
		tmp = p;
		if (p = strchr(tmp,','))
			*p++ = 0;
		else
			if (p = strchr(tmp,'\n'))
				*p++ = 0;
		/*
		 * Figure out if we have a range.
		 */
		if (rp = strchr(tmp,'-')) {
			*rp++ = 0;
			if (((val2 = atoi(rp)) < 1) || (val2 > AUD_MAX_DEF))
				return (-1);
			if (((val1 = atoi(tmp)) < 1) || (val1 > AUD_MAX_DEF))
				return (-1);
			for (i = val1; i <= val2; i++)
				addmask(amask,i-1);
		} else {
			if (((val1 = atoi(tmp)) < 1) || (val1 > AUD_MAX_DEF))
				return (-1);
			addmask(amask,val1-1);
		}
	}
	return (0);
}
