/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passutil.c: version 25.1 created on 12/2/91 at 16:45:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passutil.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<stdio.h>
#include	<shadow.h>
#include	<pwd.h>
#include	<auth.h>
#include	"passmgmt.h"
#include	"passext.h"

/*
 * Try to recover the old password file.
 */
rec_pwd()
{
	if (info_mask & PASS_CHANGED) {
		if (unlink(PASSWD) < 0)
			return (-1);
		if (link(OPASSWD,PASSWD) < 0)
			return (-1);
	}
	return (0);
}

/*
 * Combine two uid_blk's.
 */
uid_bcom(uid_p)
ublk_t *uid_p;
{
	ublk_t *uid_tp;

	uid_tp = uid_p->link;
	uid_p->high = uid_tp->high;
	uid_p->link = uid_tp->link;
	free((char *) uid_tp);
	return (0);
}

/*
 * Add a new uid_blk.
 */
add_ublk(num, uid_p)
int num;
ublk_t *uid_p;
{
	ublk_t *uid_tp;

	if ((uid_tp = (ublk_t *)malloc(sizeof(ublk_t))) == NULL) {
		rid_tmpf();
		file_error(NO_LOCK);
	}
	uid_tp->high = uid_tp->low = num;
	uid_tp->link = uid_p->link;
	uid_p->link = uid_tp;
}

/*
 *	add_uid() adds uid to the link list of used uids.
 *	Here we are using a linked list of uid_blk to keep track of all
 *	the used uids.  Each uid_blk represents a range of used uid,
 *	with low represents the low inclusive end and high represents
 *	the high inclusive end.  In the beginning, we initialize a linked
 *	list of one uid_blk with low = high = (UID_MIN-1).  This was
 *	done in main().
 *	Each time we read in another used uid, we add it onto the linked
 *	list by either making a new uid_blk, decrementing the low of
 *	an existing uid_blk, incrementing the high of an existing
 *	uid_blk, or combining two existing uid_blks.  After we finished
 *	building this linked list, the first available uid above or
 *	equal to UID_MIN is the high of the first uid_blk in the linked
 *	list + 1.
 */
add_uid(uid)
int uid;
{
	ublk_t *uid_p;

	/* Only keep track of the ones above UID_MIN */
	if (uid >= UID_MIN) {
		uid_p = uid_sp;
		while (uid_p != NULL) {
			if (uid_p->link != NULL) {
				if (uid >= uid_p->link->low) {
					uid_p = uid_p->link;
				} else {
				 if ((uid >= uid_p->low) &&
						(uid <= uid_p->high)) {
					uid_p = NULL;
				 } else {
				  if (uid == (uid_p->high+1)) {
					if (++uid_p->high ==
						(uid_p->link->low-1)) {
						uid_bcom(uid_p);
					}
					uid_p = NULL;
				  } else {
				   if (uid == (uid_p->link->low - 1)) {
					uid_p->link->low --;
					uid_p = NULL;
				   } else {
				    if (uid < uid_p->link->low) {
					add_ublk(uid, uid_p);
					uid_p = NULL;
				    }
				   }
				  }
				 }
				}
			} else {
				if (uid == (uid_p->high + 1)) {
					uid_p->high++;
					uid_p = NULL;
				} else {
					if (uid >= uid_p->low &&
						uid <= uid_p->high) {
						uid_p = NULL;
					} else {
						add_ublk(uid, uid_p);
						uid_p = NULL;
					}
				}
			}
		}
	}
}

/*
 * Check for the size of the whole passwd entry.
 */
ck_p_sz(pwp)
struct passwd *pwp;
{
	char *ctp;

	if ((ctp = malloc((unsigned) ENTRY_LENGTH)) == NULL) {
		rid_tmpf();
		file_error(NO_LOCK);
	}

	/* Ensure that the combined length of the individual */
	/* fields will fit in a passwd entry.  The 1 accounts for the */
	/* newline and the 6 accounts for the colons (:'s) */
	if ((strlen(pwp->pw_name) + 1 +
		sprintf(ctp, "%d", pwp->pw_uid) +
		sprintf(ctp, "%d", pwp->pw_gid) +
		strlen(pwp->pw_comment) +
		strlen(pwp->pw_dir)	+
		strlen(pwp->pw_shell) + 6) > (ENTRY_LENGTH-1))
	{
		rid_tmpf();
		bad_arg("New password entry too long");
	}
}

/*
 * Get rid of the temp files.
 */
rid_tmpf()
{
	if (info_mask & PASS_UPDATE) {
		fclose(fp_ptemp);
		if (unlink(PASSTEMP))
			fprintf(stderr,"%s: WARNING cannot unlink %s\n",
				prognamp, PASSTEMP);
	}
}

FILE *
open_temp(temp, orig, modemask)
	char *temp, *orig;
	int modemask;
{
	FILE	*fp;
	struct stat	statbuf;
	int oldumask;

	if (stat(orig,&statbuf) < 0) {
		rid_tmpf();
		file_error(NO_LOCK);
	}
	oldumask = umask((int) ~(statbuf.st_mode & modemask));
	if ((fp = fopen(temp , "w")) == NULL) {
		rid_tmpf();
		file_error(NO_LOCK);
	}
	if (chown(temp,(int)statbuf.st_uid,(int)statbuf.st_gid) != 0) {
		fclose(fp);
		if (unlink(temp) != 0) {
			fprintf(stderr, "%s: WARNING cannot unlink %s\n",
				prognamp, temp);
		}
		rid_tmpf();
		file_error(NO_LOCK);
	}
	umask(oldumask);
	return (fp);
}

/*
 * Move dest to old, src to dest and turn flag on (recover on error).
 */
move_files(src, dest, old, flag, lck_fd)
	char *src, *dest, *old;
	uint flag;
	int lck_fd;
{
	if (unlink(old) && (access(old, 0) == 0)) {
		if (rec_pwd())
			bad_news(lck_fd);
		else
			file_error(lck_fd);
	}
	if (link(dest,old)) {
		if (rec_pwd())
			bad_news(lck_fd);
		else
			file_error(lck_fd);
	}
	if (unlink(dest)) {
		if (rec_pwd())
			bad_news(lck_fd);
		else
			file_error(lck_fd);
	}
	if (link(src,dest)) {
		if (link(old,dest))
			bad_news(lck_fd);
		if (rec_pwd())
			bad_news(lck_fd);
		else
			file_error(lck_fd);
	}
	if (unlink(src))
		fprintf(stderr,
			"%s: WARNING cannot unlink %s\n", prognamp, src);
	info_mask |= flag;
}

/*
 *	Function to move passwd structure to usrauth structure.
 */
copy_to_auth(pwd,ua)
struct	passwd	*pwd;
usrauth_t	*ua;
{
	strncpy(ua->ua_name,pwd->pw_name,NAME_MAX);
	ua->ua_uid = pwd->pw_uid;
	ua->ua_gid = pwd->pw_gid;
	strncpy(ua->ua_gecos,pwd->pw_gecos,MAXCOMMENT);
	if (ua->ua_gecos[0] == NULL)
		strncpy(ua->ua_gecos,pwd->pw_comment,MAXCOMMENT);
	strncpy(ua->ua_defdir,pwd->pw_dir,MAXPATH);
	strncpy(ua->ua_defshell,pwd->pw_shell,MAXPATH);
	return (0);
}
