/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passupd.c: version 25.1 created on 12/2/91 at 16:45:15	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passupd.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include	<pwd.h>
#include	<grp.h>
#include	<errno.h>
#include	<auth.h>
#include	<sys/wait.h>
#include	"passmgmt.h"
#include	"passext.h"

static	char	pwdflr[] = "*";	/* password string for /etc/passwd */

/*
 *	This function will update the standard passwd file, userauth, and
 *	userstat file.
 */
upd_all(logname, pwd, ua, us)
char *logname;
struct passwd *pwd;
usrauth_t *ua;
usrstat_t *us;
{
	struct passwd	*pw_ptr;
	usrauth_t *ua_t;
	int indx, i;

	/*
	 * The while loop for reading PASSWD entries.
	 */
	setpwent();
	i = 0;
	while ((pw_ptr = getpwent()) != NULL) {
		/*
		 * Set up the uid usage blocks to find the first
		 * available uid above UID_MIN, if needed.
		 */
		if (info_mask & NEED_DEF_UID)
			add_uid(pw_ptr->pw_uid);
		/*
		 * Check for unique UID.
		 */
		if (strcmp(logname, pw_ptr->pw_name) &&
				(pw_ptr->pw_uid == pwd->pw_uid) &&
				((optn_mask & UA_MASK_u) &&
				!(optn_mask & UA_MASK_o))) {
			rid_tmpf();	/* get rid of temp files */
			bad_uid("UID in use");
		}
		/*
		 * Check for unique new logname.
		 */
		if ( strcmp(logname, pw_ptr->pw_name) &&
				!strcmp(pw_ptr->pw_name, pwd->pw_name)) {
			rid_tmpf();
			bad_name("logname already exists");
		}
		if (!strcmp(logname, pw_ptr->pw_name)) {
			/*
			 * No good if we want to add an existing logname.
			 */
			if (optn_mask & UA_MASK_a) {
				rid_tmpf();
				bad_name("name already exists");
			}
			info_mask |= FOUND; /* remember we found it */
			/*
			 * If modifying then update field.
			 */
			if (optn_mask & UA_MASK_m) {
				if (optn_mask & UA_MASK_u)
					pw_ptr->pw_uid = pwd->pw_uid;
				if (optn_mask & UA_MASK_g) {
					pw_ptr->pw_gid = pwd->pw_gid;
					upd_group(logname,pw_ptr->pw_gid);
				}
				if (optn_mask & UA_MASK_c) {
					pw_ptr->pw_comment = pwd->pw_comment;
					pw_ptr->pw_gecos = pwd->pw_gecos;
				}
if (optn_mask & UA_MASK_h) {
	if (!access(pwd->pw_dir,0)) {
		fprintf(stderr,
			"%s: can't rename '%s' to existing '%s' directory!\n",
				prognamp,pw_ptr->pw_dir,pwd->pw_dir);
	} else {
		if (!access(pw_ptr->pw_dir,0)) {
			if (rename(pw_ptr->pw_dir,pwd->pw_dir) < 0) {
				fprintf(stderr,
				"%s: Error renaming '%s' directory to '%s'!\n",
					prognamp,pw_ptr->pw_dir,pwd->pw_dir);
				perror("rename");
			} else {
				pw_ptr->pw_dir = pwd->pw_dir;
			}
		} else {
			fprintf(stderr,
		"%s: old directory '%s' doesn't exist, creating '%s'!\n",
			prognamp,pw_ptr->pw_dir,pwd->pw_dir);
			if (mkdir(pwd->pw_dir,0755) < 0) {
				fprintf(stderr,
				"%s: Error creating '%s' directory!\n",
					prognamp,pwd->pw_dir);
				perror("mkdir");
			} else {
				pw_ptr->pw_dir = pwd->pw_dir;
			}
		}
	}
}
				if (optn_mask & UA_MASK_s)
					pw_ptr->pw_shell = pwd->pw_shell;
				ck_p_sz(pw_ptr); /* check entry size */
				if ((ua_t = getuanam(logname)) == NULL)
					fprintf(stderr,
					"Cannot find information on %s\n",
						logname);
				if (optn_mask & UA_MASK_T) {
					for (indx = 0; indx < 7; indx++) {
						ua_t->ua_times[indx].st_hr =
						    ua->ua_times[indx].st_hr;
						ua_t->ua_times[indx].st_min =
						    ua->ua_times[indx].st_min;
						ua_t->ua_times[indx].et_hr =
						    ua->ua_times[indx].et_hr;
						ua_t->ua_times[indx].et_min =
						    ua->ua_times[indx].et_min;
					}
				}
	{
		int minlife, maxlife;

		if (optn_mask & UA_MASK_p)
			minlife = ua->ua_min_pwdlife;
		else
			minlife = ua_t->ua_min_pwdlife;
		if (optn_mask & UA_MASK_P)
			maxlife = ua->ua_max_pwdlife;
		else
			maxlife = ua_t->ua_max_pwdlife;
		if (minlife < 0)
			minlife *= -1;
		if (maxlife < 0)
			maxlife *= -1;
		if (minlife <= maxlife) {
			if (optn_mask & UA_MASK_p)
				ua_t->ua_min_pwdlife = ua->ua_min_pwdlife;
			if (optn_mask & UA_MASK_P)
				ua_t->ua_max_pwdlife = ua->ua_max_pwdlife;
		} else
			fprintf(stderr,
			"Min pwdlife > Max pwdlife, field not updated\n");
	}
				if (optn_mask & UA_MASK_x)
					ua_t->ua_maxtries = ua->ua_maxtries;
				if (optn_mask & UA_MASK_k) {
					ua_t->ua_amask[0] = ua->ua_amask[0];
					ua_t->ua_amask[1] = ua->ua_amask[1];
				}
				if (optn_mask & UA_MASK_R)
					ua_t->ua_role = ua->ua_role;
				if (optn_mask & UA_MASK_M) {
					ua_t->ua_mode &= ~MODE_MASK;
					ua_t->ua_mode |= ua->ua_mode&MODE_MASK;
				}
				if (optn_mask & UA_MASK_G) {
					ua_t->ua_mode &= ~PWGEN_MASK;
					ua_t->ua_mode |= ua->ua_mode&PWGEN_MASK;
				}
				if (optn_mask & UA_MASK_A)
					ua_t->ua_acctstat = ua->ua_acctstat;
				copy_to_auth(pw_ptr,ua_t);
				if ((ua->ua_uid < 0) ||
					(updateuaent(ua_t, us, JUST_UA) < 0)) {
						fprintf(stderr,
						"Cannot update %s\n",USRAUTH);
						rid_tmpf();
						file_error(NO_LOCK);
				}
				if (ndevs && (optn_mask & UA_MASK_D))
					update_devlist(logname);
				if (optn_mask & UA_MASK_R) {
					if (sendroles() < 0) {
						fprintf(stderr,
			"%s: Error during the down load of modified roles\n",
							prognamp);
						perror("sendroles");
					}
				}
				if (optn_mask & UA_MASK_k) {
					if (sendamask(&ua_t->ua_amask[0]) < 0) {
						fprintf(stderr,
						"%s: cannot set audit mask.\n",
							prognamp);
						perror("sendamask");
						return (1);
					}
				}
			}
		}
		/*
		 * If the name is not in the userauth file.
		 */
		if ((getuanam(pw_ptr->pw_name)) == NULL) {
			pw_ptr->pw_passwd = pwdflr;
			copy_to_auth(pw_ptr,ua);
			if ((ua->ua_uid < 0) ||
				(updateuaent(ua, us, DO_BOTH) < 0)) {
					fprintf(stderr,"Cannot update %s\n",
						USRAUTH);
					rid_tmpf();
					file_error(NO_LOCK);
			}
			fprintf(stderr,"Updating user: %s to %s\n",
				pw_ptr->pw_name,USRAUTH);
		}
		if (putpwent(pw_ptr,fp_ptemp)) {
			rid_tmpf();
			file_error(NO_LOCK);
		}
		i++;
	}
	endpwent();
	/*
	 * Cannot find the target entry and we are deleting or modifying.
	 */
	if (!(info_mask & FOUND) && (optn_mask & (UA_MASK_d|UA_MASK_m))) {
		rid_tmpf();
		bad_name("id does not exist");
	}
	/*
	 * Deleting (retire) the account.
	 */
	if (optn_mask & UA_MASK_d) {
		if ((ua = getuanam(logname)) != NULL) {
 			ua->ua_acctstat = RETIRE;
			if ((ua->ua_uid < 0) ||
				(updateuaent(ua, us, JUST_UA) < 0)) {
					fprintf(stderr,"Cannot update %s\n",
						USRAUTH);
					rid_tmpf();
					file_error(NO_LOCK);
			}
		} else {
			fprintf(stderr,"Cannot find %s in %s cannot RETIRE\n",
				logname,USRAUTH);
		}
	}
	/*
	 * First available uid above UID_MIN is ...
	 */
	if (info_mask & NEED_DEF_UID) {
		pwd->pw_uid = uid_sp->high + 1;
		ua->ua_uid = pwd->pw_uid;
		us->us_uid = pwd->pw_uid;
	}
	/*
	 * Write out the added entry now.
	 */
	if (optn_mask & UA_MASK_a) {
		ck_p_sz(pwd);	/* Check entry size */
		if (pwd->pw_uid > UID_MAX) {
			bad_uid("UID is larger than Maximum UID");
			rid_tmpf();
			file_error(NO_LOCK);
		}
		copy_to_auth(pwd,ua);
		if (!access(pwd->pw_dir,0)) {
			fprintf(stderr,
				"%s: home directory '%s' already exists!\n",
					prognamp,pwd->pw_dir);
		} else {
			if (mkdir(pwd->pw_dir,0755) < 0) {
				fprintf(stderr,
				"%s: Error creating '%s' directory!\n",
					prognamp,pwd->pw_dir);
				perror("mkdir");
			}
			if (chown(pwd->pw_dir, pwd->pw_uid, pwd->pw_gid) < 0) {
				fprintf(stderr,
				"%s: Error changing ownership of '%s' directory!\n",
					prognamp,pwd->pw_dir);
				perror("chown");
			}
		}
		if ((ua->ua_uid < 0) || (updateuaent(ua,us,DO_BOTH) < 0)) {
			fprintf(stderr,"Cannot update '%s'\n",USRAUTH);
			perror("updateuaent");
			rid_tmpf();
			file_error(NO_LOCK);
		}
		if (ndevs && (optn_mask & UA_MASK_D))
			update_devlist(pwd->pw_name);
		if (optn_mask & UA_MASK_R) {
			if (sendroles() < 0) {
				fprintf(stderr,
			"Error during the down load of new user roles\n");
				perror("sendroles");
				errno = 0;
			}
		}
		if (optn_mask & UA_MASK_k) {
			if (sendamask(&ua_t->ua_amask[0]) < 0) {
				fprintf(stderr,
					"%s: cannot set new audit mask.\n",
					prognamp);
				perror("sendamask");
				errno = 0;
			}
		}
		if (putpwent(pwd,fp_ptemp)) {
			rid_tmpf();
			file_error(NO_LOCK);
		}
	}
	fclose(fp_ptemp);
}

upd_group(logname, gid)
	char *logname;
	int gid;
{
	int	found=0;
	struct group *gr_ptr;
	usrauth_t *ua;
	char **q, **p;
	char buff[20];
	int indx;

	if (((ua = getuanam(logname)) == NULL) && (optn_mask & UA_MASK_m)) {
		fprintf(stderr,"Cannot find %s in the %s file.\n",
			logname,USRAUTH);
		return (0);
	}
	/*
	 * The while loop for reading GROUP entries.
	 */
	while ((gr_ptr = (struct group *) getgrent()) != NULL) {
		if (gid == gr_ptr->gr_gid) {
			for(p = gr_ptr->gr_mem; *p != NULL; p++) {
				if (!strcmp(*p, logname)) {
					/*
					 * Found the logname in the group.
					 */
					found = 1;
					/*
					 * But were adding the logname -
					 * Error.
					 */
					if (optn_mask & UA_MASK_a) {
						rid_tmpf();
						bad_pasf();
					}
				}
			}
			/*
			 * If not found and we are adding the add to group.
			 */
			if (!found && ((optn_mask & UA_MASK_a) ||
					(optn_mask & UA_MASK_m))) {
				*p = &buff[0];
				strcpy(*p,logname);
				p++;
				*p = NULL;
			}
		}
		/*
		 * Special case when upd_all is modifying the group gid
		 * The usrauth file has not been updated and will contain the
		 * original gid number, while the new gid number will be
		 * passed into this routine.  The above UA_MASK_m code will
		 * add the logname to the new gid number.  The following
		 * code will remove the logname from the orignal gid number.
		 */
		else if ((optn_mask & UA_MASK_m) &&
				(ua->ua_gid == gr_ptr->gr_gid)) {
					for(p = gr_ptr->gr_mem; *p != NULL; p++)
						if (!strcmp(*p, logname))
							for (q = p;*q != 0; ++q)
								*q = *(q + 1);
		}
		if (indx = putgrent(gr_ptr, fp_gtemp)) {
			rid_tmpf();
			file_error(NO_LOCK);
		}
	}
	fclose(fp_gtemp);
}

update_devlist(user)
char	*user;
{
int	child, status;

	/* devmgmt -m -u user device(s) */
	if ((child = fork()) == 0) {
		uadevs[0] = devpname;
		uadevs[1] = "-m";
		uadevs[2] = "-u";
		uadevs[3] = user;
		execv(devpname,uadevs);
	}
	if ((pid_t)wait(&status) != (pid_t)child) {
		perror("wait");
		return (-1);
	}
	if (WIFEXITED(status))
		return (WEXITSTATUS(status));
	return (-1);
}
