#	START NEW ARIX SCCS HEADER
#
#	@(#) passmgmt.mk: version 25.1 created on 12/2/91 at 16:45:11
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)passmgmt.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
include $(IROOT)/macdefs

INSDIR		= $(SECROOT)/bin
DEFPROF		= userprof
PROFDIR		= $(SECROOT)/etc/default

SVID_FLAG=
LOCAL_CFLAGS	= -I. -DSECON
LOCAL_LDFLAGS	= -lsec

OBJS		= \
		access.o \
		devmgmt.o \
		isnumber.o \
		listta.o \
		listua.o \
		loaddefs.o \
		loadprof.o \
		main.o \
		passchk.o \
		passerr.o \
		passmgmt.o \
		passutil.o \
		passupd.o \
		sendamask.o \
		sendroles.o \
		setdefs.o \
		setprof.o \
		uidmap.o \
		utilprof.o

PROG1		= passmgmt
PROG2		= devmgmt
PROGS		= $(PROG1) $(PROG2)

secall all:		$(PROGS)

$(PROG1):	$(OBJS)
		$(CC) -o $(PROG1) $(OBJS) $(LDFLAGS)

$(PROG2):	$(PROG1)
		-ln $(PROG1) $(PROG2)

access.c:	passmgmt.h
devmgmt.c:	passmgmt.h passext.h
loaddefs.c:	loaddefs.h
loadprof.c:	userprof.h loadprof.h
passchk.c:	userprof.h loadprof.h passmgmt.h passext.h
passerr.c:	passmgmt.h passext.h
passmgmt.c:	passmgmt.h passext.h
passutil.c:	userprof.h loadprof.h passmgmt.h passext.h
passupd.c:	userprof.h loadprof.h passmgmt.h passext.h
setdefs.c:	loaddefs.h passmgmt.h
setprof.c:	passmgmt.h userprof.h loadprof.h
uidmap.c:	loaddefs.h
utilprof.c:	userprof.h loadprof.h

.c.o:
		$(CC) $(CFLAGS) -c $(<F)

secinstall install:	all
		$(INS) passmgmt $(INSDIR)/passmgmt
		chmod 4755 $(INSDIR)/passmgmt
		chown root $(INSDIR)/passmgmt
		chgrp sys $(INSDIR)/passmgmt
		-ln $(INSDIR)/passmgmt $(INSDIR)/devmgmt
		$(INS) $(DEFPROF) $(PROFDIR)
		chown root $(PROFDIR)/$(DEFPROF)
		chgrp sys $(PROFDIR)/$(DEFPROF)
		chmod 640 $(PROFDIR)/$(DEFPROF)

secclean clean:
		rm -f $(OBJS) core make.out

secclobber clobber:	clean
		rm -f $(PROGS)
