/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passmgmt.c: version 25.1 created on 12/2/91 at 16:45:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passmgmt.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <shadow.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>
#include <auth.h>
#include "passmgmt.h"
#include "passext.h"

FILE	*fp_ptemp, *fp_gtemp;

ublk_t	*uid_sp;

uint	optn_mask = 0;
uint	info_mask = 0;

char	defdir[] = "/usr/";	/* default home dir for new user */
char	*pass_opt_args = "IFf:c:h:u:g:s:ot:adlmp:P:R:T:A:M:G:Zx:k:D:";

uint	amask[2];

passmgmt(argc,argv)
int		argc;
char		**argv;
{
usrauth_t	tmp_ua, *ua_st, *ual;
usrstat_t	tmp_us, *us_st;
struct	passwd	tmp_pd, *pwd_st;
char		*char_p;
int		c, value, lck_pass, lck_grp;

	/*
	 * Check if the usr_auth relevant files exist.
	 */
	info_mask = UAUTH_PROFILE;
	info_mask |= chk_access();
	pwd_st = &tmp_pd;
	ua_st  = &tmp_ua;
	us_st  = &tmp_us;
	/*
	 * Set all the defaults for the structures.
	 */
	setuausdefs(pwd_st,ua_st,us_st,info_mask);
	/*
	 * Parse the command line.
	 */
	while ((c = getopt(argc,argv,pass_opt_args)) != -1) {
		switch (c) {
		case 'f': /* Allows profile to be specified */
			if (optn_mask & ~(UA_MASK_a | UA_MASK_m))
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_f;
			/*
			* Override defaults by options from a profile.
			*/
			if (setuausprof(optarg,lognamp,pwd_st,
					ua_st,us_st,info_mask) < 0)
				return  (1);
			break;

		case 'F': /* Use profile name as user name */
			if (optn_mask & ~(UA_MASK_a | UA_MASK_m))
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_F;
			/*
			* Override defaults by options from a profile.
			*/
			if (setuausprof(lognamp,lognamp,pwd_st,
					ua_st,us_st,info_mask) < 0)
				return  (1);
			break;

		case 'I': /* Allows default profile to be used */
			if (optn_mask & ~(UA_MASK_a | UA_MASK_m))
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_I;
			/*
			* Override defaults by options from a profile.
			*/
			if (setuausprof(0,lognamp,pwd_st,
					ua_st,us_st,info_mask) < 0)
				return  (1);
			break;

		case 'c': /* The gecos field */
			if ((UA_MASK_d|UA_MASK_c) & optn_mask)
				bad_usage("Invalid combination of options");
			if ((strlen(optarg) >CMT_SIZE) || strpbrk(optarg,":\n"))
				bad_arg("Invalid argument to option -c");
			optn_mask |= UA_MASK_c;
			pwd_st->pw_comment = strdup(optarg);
			pwd_st->pw_gecos = pwd_st->pw_comment;
			strncpy(ua_st->ua_gecos,optarg,MAXCOMMENT);
			break;

		case 'h': /* The home directory */
			if ((UA_MASK_d|UA_MASK_h) & optn_mask)
				bad_usage("Invalid combination of options");
			if ((strlen(optarg) >DIR_SIZE) || strpbrk(optarg,":\n"))
				bad_arg("Invalid argument to option -h");
			optn_mask |= UA_MASK_h;
			pwd_st->pw_dir = strdup(optarg);
			strncpy(ua_st->ua_defdir,optarg,MAXPATH);
			break;

		case 'u': /* The uid */
			if ((UA_MASK_d|UA_MASK_u) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_u;
			pwd_st->pw_uid = (uid_t) strtol(optarg,&char_p,10);
			ua_st->ua_uid = pwd_st->pw_uid;
			us_st->us_uid = pwd_st->pw_uid;
			if ((*char_p != '\0') || (pwd_st->pw_uid < 0) ||
					(strlen(optarg) == 0))
				bad_arg("Invalid argument to option -u");
			break;

		case 'o': /* Override unique uid */
			if ((UA_MASK_d|UA_MASK_o) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_o;
			break;

		case 'g': /* The gid */
			if ((UA_MASK_d|UA_MASK_g) & optn_mask)
				bad_usage("Invalid combination of options");
			/* chk_group() exits on errors */
			pwd_st->pw_gid = (gid_t) chk_group(optarg);
			ua_st->ua_gid  = pwd_st->pw_gid;
			optn_mask |= UA_MASK_g;
			break;

		case 's': /* The shell */
			if ((UA_MASK_d|UA_MASK_s) & optn_mask)
				bad_usage("Invalid combination of options");
			if ((strlen(optarg) >SHL_SIZE) || strpbrk(optarg,":\n"))
				bad_arg("Invalid argument to option -s");
			optn_mask |= UA_MASK_s;
			pwd_st->pw_shell = strdup(optarg);
			strncpy(ua_st->ua_defshell,optarg,MAXPATH);
			break;

		case 'p': /* ua_min_pwdlife */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = strtol(optarg, &char_p, 10);
			if ((*char_p != '\0') || (strlen(optarg) == 0))
				bad_arg("Invalid argument to option -p");
			ua_st->ua_min_pwdlife = value;
			optn_mask |= UA_MASK_p;
			break;

		case 'P': /* ua_max_pwdlife */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = strtol(optarg, &char_p, 10);
			if ((*char_p != '\0') || (strlen(optarg) == 0))
				bad_arg("Invalid argument to option -p");
			ua_st->ua_max_pwdlife = value;
			optn_mask |= UA_MASK_P;
			break;

		case 'x': /* ua_maxtries */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = strtol(optarg, &char_p, 10);
			if ((*char_p != '\0') || (value < 0) ||
					(strlen(optarg) == 0))
				bad_arg("Invalid argument to option -x");
			ua_st->ua_maxtries = value;
			optn_mask |= UA_MASK_x;
			break;

		case 'k': /* ua_amask[2] */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = chk_amask(optarg,&amask[0]);
			if (value < 0)
				bad_arg("Invalid argument to option -k");
			ua_st->ua_amask[0] = amask[0];
			ua_st->ua_amask[1] = amask[1];
			optn_mask |= UA_MASK_k;
			break;

		case 'R': /* ua_role */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = chk_role(optarg);
			if (value < 0)
				bad_arg("Invalid argument to option -R");
			ua_st->ua_role = value;
			optn_mask |= UA_MASK_R;
			break;

		case 'T': /* ua_times */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			if ((value = times_atob(ua_st,optarg)) != 0) {
		if (value == -2)
			bad_arg("Invalid start time argument to option -T");
		if (value == -3)
			bad_arg("Invalid end time argument to option -T");
				bad_arg("Invalid argument to option -T");
			}
			optn_mask |= UA_MASK_T;
			break;

		case 'A': /* ua_acctstat */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = chk_stat(optarg);
			if (value < 0)
				bad_arg("Invalid argument to option -A");
			ua_st->ua_acctstat = (char) value;
			optn_mask |= UA_MASK_A;
			break;

		case 'D': /* devlist */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			if (chk_devlist(optarg) < 0)
				bad_arg("Invalid argument to option -D");
			optn_mask |= UA_MASK_D;
			break;

		case 'M': /* ua_mode */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = chk_pwmode(optarg);
			if (value < 0)
				bad_arg("Invalid argument to option -M");
			ua_st->ua_mode &= ~MODE_MASK;
			ua_st->ua_mode |= (value << MODE_SHIFT) & MODE_MASK;
			optn_mask |= UA_MASK_M;
			break;

		case 'G': /* ua_mode */
			if ((UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			value = chk_pwgen(optarg);
			if (value < 0)
				bad_arg("Invalid argument to option -G");
			ua_st->ua_mode &= ~PWGEN_MASK;
			ua_st->ua_mode |= value & PWGEN_MASK;
			optn_mask |= UA_MASK_G;
			break;

		case 'l': /* List */
			if ((UA_MASK_d|UA_MASK_m|
					UA_MASK_c|UA_MASK_l|
					UA_MASK_h|UA_MASK_u|
					UA_MASK_g|UA_MASK_s|
					UA_MASK_T|UA_MASK_o|
					UA_MASK_a) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_l;
			break;

		case 'a': /* Add */
			if ((UA_MASK_a|UA_MASK_m|
					UA_MASK_d|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_a;
			break;

		case 'd': /* Delete (Retire) */
			if ((UA_MASK_d|UA_MASK_m|
					UA_MASK_c|UA_MASK_l|
					UA_MASK_h|UA_MASK_u|
					UA_MASK_g|UA_MASK_s|
					UA_MASK_T|UA_MASK_o|
					UA_MASK_a) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_d;
			break;

		case 'm': /* Modify */
			if ((UA_MASK_a|UA_MASK_d|
					UA_MASK_m|UA_MASK_l) & optn_mask)
				bad_usage("Invalid combination of options");
			optn_mask |= UA_MASK_m;
			break;

		case '?':
			bad_usage("");
			break;

		case 'Z':
			dump_dev_uid();
			return (0);
		}
	}
	/*
	 * Check command syntax for the following errors:
	 * too few or too many arguments, or
	 * no -a -m -l or -d option, or
	 * -o without -u, or
	 * -m with no other option.
	 */
	if ((optind == argc) || (argc > (optind+1)) ||
		!((UA_MASK_a | UA_MASK_m | UA_MASK_d | UA_MASK_l) & optn_mask)||
		((optn_mask & UA_MASK_o) && !(optn_mask & UA_MASK_u))  ||
		((optn_mask & UA_MASK_m) && !(optn_mask &
		(UA_MASK_p | UA_MASK_P | UA_MASK_R | UA_MASK_T | UA_MASK_A |
		UA_MASK_M | UA_MASK_G | UA_MASK_c | UA_MASK_h | UA_MASK_u |
		UA_MASK_g | UA_MASK_s | UA_MASK_T | UA_MASK_f | UA_MASK_F |
		UA_MASK_x | UA_MASK_k | UA_MASK_D | TA_MASK_I))))
		bad_usage("Invalid command syntax");
	/*
	 * Null string argument or bad characters?
	 */
	if ((strlen(argv[optind]) == 0) || strpbrk (argv[optind], ":\n"))
		bad_arg("Invalid name");
	if (strcmp(lognamp,argv[optind]))
		bad_arg("Invalid name position in command line");
	/*
	 * If we are adding a new user or modifying an existing user
	 * then copy logname into the data structures.
	 */
	if ((UA_MASK_a & optn_mask) || (UA_MASK_l & optn_mask) ||
			(UA_MASK_m & optn_mask)) {
		pwd_st->pw_name = argv [optind];
		if (UAUTH_FLAG & info_mask)
			strncpy(ua_st->ua_name,argv[optind],NAME_MAX);
	}
	/*
	 * To list out the information in the binary files.
	 */
	if ((UA_MASK_l & optn_mask) && (UAUTH_FLAG & info_mask)) {
		if ((ual = getuanam(pwd_st->pw_name)) != NULL) {
			listua(ual);
			return  (0);
		} else {
			fprintf(stderr,"Cannot find %s in %s file.\n",
				pwd_st->pw_name,USRAUTH);
			return  (1);
		}
	}
	/*
	 * Put in directory if we are adding and we need a default.
	 */
	if (!(optn_mask & UA_MASK_h) && (optn_mask & UA_MASK_a)) {
		if ((pwd_st->pw_dir = malloc((unsigned)DIR_SIZE)) == NULL)
			file_error (NO_LOCK);
		*pwd_st->pw_dir = '\0';
		strcat (pwd_st->pw_dir, defdir);
		strcat (pwd_st->pw_dir, lognamp);
	}
	/*
	 * Open the temporary file(s) with appropriate permission mask
	 * and the appropriate owner.
	 */
	if ((PASS_FLAG & info_mask)) {
		fp_ptemp = open_temp (PASSTEMP, PASSWD, 0444);
		info_mask |= PASS_UPDATE;
	}
	if ((GROUP_FLAG & info_mask)) {
		fp_gtemp = open_temp (GRPTMP, GRPFLE, 0444);
		info_mask |= GROUP_UPDATE;
	}
	if ((UAUTH_FLAG & info_mask) && !((UA_MASK_m & optn_mask))) {
		info_mask |= UAUTH_UPDATE;
	}
	/*
	 * Default uid needed?
	 */
	if (!(optn_mask & UA_MASK_u) && (optn_mask & UA_MASK_a)) {
		/* mark it in the information mask */
		info_mask |= NEED_DEF_UID;
		/*
		 * Create the head of the uid number list.
		 */
		if ((uid_sp = (ublk_t *)malloc(sizeof(ublk_t))) == NULL) {
			rid_tmpf();
			file_error (NO_LOCK);
		}
		uid_sp->link = NULL;
		uid_sp->low = (UID_MIN -1);
		uid_sp->high = (UID_MIN -1);
	}
	if (info_mask & PASS_UPDATE) {
		if ((lck_pass = lcksec(PASSWD)) == -1)
			no_lock (PASSWD);
		upd_all(lognamp, pwd_st, ua_st, us_st);
	}
	if (info_mask & GROUP_UPDATE) {
		if ((lck_grp = lcksec(GRPFLE)) == -1)
			no_lock (GRPFLE);
		upd_group(lognamp, pwd_st->pw_gid);
	}
	/*
	 * Ignore all signals.
	 */
	for (value = 1; value < NSIG; value++)
		sigset (value, SIG_IGN);
	errno = 0;		/* For correcting sigset to SIGKILL */
	if (info_mask & PASS_UPDATE) {
		move_files(PASSTEMP, PASSWD, OPASSWD, PASS_CHANGED, lck_pass);
		ulcksec(lck_pass);
	}
	if (info_mask & GROUP_UPDATE) {
		move_files(GRPTMP, GRPFLE, OGRPFLE, GROUP_CHANGED, lck_grp);
		ulcksec(lck_grp);
	}
	if (!(optn_mask & UA_MASK_d) && (info_mask & UAUTH_UPDATE)) {
		if (updateuaent(ua_st, us_st, DO_BOTH) < 0) {
			fprintf(stderr,"Cannot update '%s'.\n",USRAUTH);
			perror("updateuaent");
			return (1);
		}
		if (optn_mask & UA_MASK_R) {
			if (sendroles() < 0) {
				fprintf(stderr,
			"Error during the down load of modified roles\n");
				perror("sendroles");
				return (1);
			}
		}
		if (optn_mask & UA_MASK_k) {
			if (sendamask(&ua_st->ua_amask[0]) < 0) {
				fprintf(stderr,"%s: cannot set audit mask.\n",
					prognamp);
				perror("sendamask");
				return (1);
			}
		}
	}
	return (0);
}
