/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passerr.c: version 25.1 created on 12/2/91 at 16:44:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passerr.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include 	<auth.h>
#include	"passmgmt.h"
#include	"userprof.h"
#include	"passext.h"

bad_perm()
{
	fprintf(stderr, "%s: Permission denied\n", prognamp);
	exit (1);
}

bad_login_group(str)
char *str;
{
	(void) fprintf(stderr, "Default login group <%s doesn't exist> failure\n",str);
	exit(1);
}

bad_usage(sp)
char *sp;
{
if (strlen(sp) != 0)
	fprintf(stderr,"%s: %s\n", prognamp, sp);
fprintf(stderr,"Usage:\n");
fprintf(stderr,
"%s -a [-c gecos] [-h homedir] [-u uid [-o]] [-g gid] [-s shell]\n",
	prognamp);
fprintf(stderr,
"\t[-k audit mask] [-p min pass life (days)] [-P max pass life (days)]\n");
fprintf(stderr,
"\t[-A account status #] [-T login times] [-R role #] [-M mode #]\n");
fprintf(stderr,
"\t[-G auto pass generator #] [-x max login tries] [-D device list] name\n");

fprintf(stderr,"%s -a -f profile name\n", prognamp);
fprintf(stderr,"\t'profile' is a full pathname or name of profile in '%s'\n",
	PROFILE_PATH);
fprintf(stderr,"%s -a -F name\n", prognamp);
fprintf(stderr,"\tuses '%s/\"name\"' as default profile for that name\n",
	PROFILE_PATH);
fprintf(stderr,"%s -a -I name\n", prognamp);
fprintf(stderr,"\tuses '%s/%s' as default profile for that name\n",
	PROFILE_PATH,DEF_PROFILE);

fprintf(stderr,
"%s -m [-c gecos] [-h homedir] [-u uid [-o]] [-g gid] [-s shell]\n",
	prognamp);
fprintf(stderr,
"\t[-k audit mask] [-p min pass life (days)] [-P max pass life (days)]\n");
fprintf(stderr,
"\t[-A account status #] [-T login times] [-R role #] [-M mode #]\n");
fprintf(stderr,
"\t[-G auto pass generator #] [-x max login tries] [-D device list] name\n");

fprintf(stderr,"%s -m -f profile name\n", prognamp);
fprintf(stderr,"\t'profile' is a full pathname or name of profile in '%s'\n",
	PROFILE_PATH);
fprintf(stderr,"%s -m -F name\n", prognamp);
fprintf(stderr,"\tuses '%s/\"name\"' as default profile for that name\n",
	PROFILE_PATH);
fprintf(stderr,"%s -m -I name\n", prognamp);
fprintf(stderr,"\tuses '%s/%s' as default profile for that name\n",
	PROFILE_PATH,DEF_PROFILE);

fprintf(stderr,"%s -d name\n", prognamp);
fprintf(stderr,"%s -l name\n", prognamp);
	exit (2);
}

bad_arg(s)
char *s;
{
	fprintf(stderr, "%s: %s\n",prognamp, s);
	exit (3);
}

bad_name(s)
char *s;
{
	fprintf(stderr, "%s: %s\n",prognamp, s);
	exit (9);
}

bad_uid(s)
char *s;
{
	fprintf(stderr, "%s: %s\n", prognamp, s);
	exit (4);
}

bad_pasf()
{
	fprintf(stderr, "%s: Inconsistent password files\n", prognamp);
	exit (5);
}

file_error(lck_fd)
int lck_fd;
{
	fprintf(stderr,"%s: Unexpected failure.  Password files unchanged\n",
		prognamp);
	if (lck_fd)
		ulcksec(lck_fd);
	exit (6);
}

bad_news(lck_fd)
int lck_fd;
{
	fprintf(stderr,"%s: Unexpected failure.  Password file(s) missing\n",
		prognamp);
	rid_tmpf();
	ulcksec(lck_fd);
	exit (7);
}

no_lock(Fname)
char *Fname;
{
	fprintf(stderr,"%s: %s file busy.  Try again later\n",prognamp,Fname);
	exit (8);
}
