/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) passchk.c: version 25.1 created on 12/2/91 at 16:44:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)passchk.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<stdio.h>
#include	<string.h>
#include	<shadow.h>
#include	<pwd.h>
#include	<grp.h>
#include	<errno.h>
#include	<auth.h>
#include	"userprof.h"
#include	"loadprof.h"
#include	"passmgmt.h"
#include	"passext.h"

gid_t
chk_group(arg)
char		*arg;
{
struct	group	*grp;
gid_t		gid;

	if (!arg || !*arg)
		return (-1);
	if (isdigit(*arg)) {
		gid = (gid_t)atoi(arg);
		if ((grp = getgrgid(gid)) != NULL)
			return (grp->gr_gid);
		fprintf(stderr,"%s: invalid group id %d for option -g\n",
			prognamp,(uint)gid);
		exit (-1);
	}
	if ((grp = getgrnam(arg)) != NULL)
		return (grp->gr_gid);
	fprintf(stderr,"%s: invalid group name '%s' for option -g\n",
		prognamp,arg);
	exit (-1);
}

chk_role(arg)
char		*arg;
{
roldef_t	*role,	*getrolent();
uint		n;

	if (!arg || !*arg)
		return (-1);
	if (isdigit(*arg)) {
		n = (uint)atoi(arg);
		arg = 0;
	}
	setrlent();
	while ((role = getrolent()) != NULL) {
		if (arg) {
			if (strcmp(role->r_name,arg) == 0) {
				endrlent();
				return (role->r_rolenumber);
			}
		} else	{
			if (role->r_rolenumber == n) {
				endrlent();
				return (role->r_rolenumber);
			}
		}
	}
	endrlent();
	return (-1);
}

roldef_t *
get_role_id(id)
int		id;
{
roldef_t	*role,	*getrolent();

	setrlent();
	while ((role = getrolent()) != NULL) {
		if (role->r_rolenumber == id) {
			endrlent();
			return (role);
		}
	}
	endrlent();
	return ((roldef_t *)0);
}

chk_stat(arg)
char	*arg;
{
int	stat;

	if (!arg || !*arg)
		return (-1);
	if (isdigit(*arg)) {
		stat = atoi(arg);
		if ((stat < 0) || (stat > RETIRE))
			return (-1);
	} else	{
		mkupper(arg);			/* up-case option only */
		if ((stat = prof_match(arg,&stattable[0])) < 0)
			return (-1);
	}
	return (stat);
}

chk_sak(arg,ta_st)
char		*arg;
ttyauth_t	*ta_st;
{
int		val, key1, key2, key3;
char		*comma;

	/*
	 *	Basically there are five options on the SAK keys:
	 *		SAK_BREAK - Enable SAK on a break.
	 *		SAK_CARR  - Enable SAK on carrier drop (DCD/DSR).
	 *		SAK_1KEY  - Enable SAK on one character.
	 *		SAK_2KEYS - Enable SAK on two characters.
	 *		SAK_3KEYS - Enable SAK on three characters.
	 */
	if (!arg || !*arg)
		return (-1);
	prof_compact(arg);		/* remove spaces and tabs	 */
	if (comma = strchr(arg,','))	/* separate option from sak keys */
		*comma++ = '\0';
	if (isdigit(*arg)) {
		if ((*arg == '0') && ((*(arg+1) == 'x') || (*(arg+1) == 'X')))
			sscanf((arg+2),"%x",&val);
		else
			val = atoi(arg);
		ta_st->ta_sak.flags = (uchar) val;
		return (0);
	}
	mkupper(arg);			/* up-case option only */
	if ((val = prof_match(arg,&saktable[0])) < 0)
		return (-1);
	if (val & SAK_BREAK) {
		ta_st->ta_sak.flags = (uchar) SAK_BREAK;
		return (0);
	}
	if (val & SAK_CARR) {
		ta_st->ta_sak.flags = (uchar) SAK_CARR;
		return (0);
	}
	if (val & SAK_KEYS) {
		if (!comma || !*comma)
			return (-1);
		arg = comma;
		if (comma = strchr(arg,','))
			*comma++ = '\0';
		key1 = chk_key(arg);
		if (key1 < 0)
			return (-1);
		if (val & (SAK_2KEYS | SAK_3KEYS)) {
			if (!comma || !*comma)
				return (-1);
			arg = comma;
			if (comma = strchr(arg,','))
				*comma++ = '\0';
			key2 = chk_key(arg);
			if (key2 < 0)
				return (-1);
		}
		if (val & SAK_3KEYS) {
			if (!comma || !*comma)
				return (-1);
			arg = comma;
			if (comma = strchr(arg,','))
				*comma++ = '\0';
			key3 = chk_key(arg);
			if (key3 < 0)
				return (-1);
		}
		/*
		 * We repeat the checks below because we don't want to
		 * clobber existing values in the structure passed in
		 * if any of the error conditions arise.
		 */
		if (val & SAK_KEYS) {
			ta_st->ta_sak.flags	= (uchar) SAK_1KEY;
			ta_st->ta_sak.sak_key1	= (uchar) key1;
			ta_st->ta_sak.sak_key2	= (uchar) 0;
			ta_st->ta_sak.sak_key3	= (uchar) 0;
		}
		if (val & (SAK_2KEYS | SAK_3KEYS)) {
			ta_st->ta_sak.flags	= (uchar) SAK_2KEYS;
			ta_st->ta_sak.sak_key2	= (uchar) key2;
			ta_st->ta_sak.sak_key3	= (uchar) 0;
		}
		if (val & SAK_3KEYS) {
			ta_st->ta_sak.flags	= (uchar) SAK_3KEYS;
			ta_st->ta_sak.sak_key3	= (uchar) key3;
		}
		return (0);
	}
	return (-1);
}

chk_key(arg)
char	*arg;
{
int	val;
char	*uc;

	if (!arg || !*arg)
		return (-1);
	if (isdigit(*arg) && *(arg+1)) {
		if ((*arg == '0') && ((*(arg+1) == 'x') || (*(arg+1) == 'X')))
			sscanf((arg+2),"%x",&val);
		else
			val = atoi(arg);
		if (val > 0177)
			return (-1);
		return (val);
	}
	if ((*arg == '^') && *(arg+1)) {
		arg++;
		if (*arg == '?')		/* ^?	*/
			return (0177);		/* DEL	*/
		mkupperlen(arg,1);
		if ((*arg < 'A') || (*arg > '_'))
			return ((int)'^');
		return ((int)(*arg & ~0100));
	}
	uc = strdup(arg);
	if (uc == NULL)
		return ((int)*arg);
	mkupper(uc);
	if (strncmp(uc,"DEL",3) == 0) {
		free(uc);
		return (0177);				/* DEL	*/
	}
	if (strncmp(uc,"ESC",3) == 0) {
		free(uc);
		return (033);				/* ESC	*/
	}
	if (strncmp(uc,"TAB",3) == 0) {
		free(uc);
		return (011);				/* TAB	*/
	}
	free(uc);
	return ((int)*arg);
}

chk_tausers(arg)
char		*arg;
{
struct	passwd	*pwd;
int		val;
char		*uc;

	if (!arg || !*arg)
		return (-1);
	if (*arg == '*')
		return (TA_USERS_ALL);
	if (isdigit(*arg)) {
		if ((*arg == '0') && ((*(arg+1) == 'x') || (*(arg+1) == 'X')))
			sscanf((arg+2),"%x",&val);
		else
			val = atoi(arg);
		if (val < 0)
			return (-1);
		if ((pwd = getpwuid((uid_t)val)) == NULL)
			return (-1);
	} else	{
		uc = strdup(arg);	/* keep original name unchanged */
		mkupper(uc);
		if (strcmp(uc,"ALL") == 0)
			return (TA_USERS_ALL);
		if ((pwd = getpwnam(arg)) == NULL)
			return (-1);
		val = pwd->pw_uid;
	}
	if (val > UID_MAX)
		return (-1);
	return (val);
}

chk_tagroups(arg)
char		*arg;
{
struct	group	*grp;
int		val;
char		*uc;

	if (!arg || !*arg)
		return (-1);
	if (*arg == '*')
		return (TA_GROUPS_ALL);
	if (isdigit(*arg)) {
		if ((*arg == '0') && ((*(arg+1) == 'x') || (*(arg+1) == 'X')))
			sscanf((arg+2),"%x",&val);
		else
			val = atoi(arg);
		if (val < 0)
			return (-1);
		if ((grp = getgrgid((gid_t)val)) == NULL)
			return (-1);
	} else	{
		uc = strdup(arg);	/* keep original name unchanged */
		mkupper(uc);
		if (strcmp(uc,"ALL") == 0)
			return (TA_GROUPS_ALL);
		if ((grp = getgrnam(arg)) == NULL)
			return (-1);
		val = grp->gr_gid;
	}
	if (val > UID_MAX)
		return (-1);
	return (val);
}

chk_devlist(arg)
char	*arg;
{
char	*uc, *comma;

	if (ndevs || !arg || !*arg)
		return (-1);
	prof_compact(arg);		/* remove spaces and tabs	*/
#ifdef	NOTYET
	if (*arg == '*')
		return (-1);
	uc = strdup(arg);		/* keep original name unchanged	*/
	mkupper(uc);
	if (strcmp(uc,"ALL") == 0) {
		free(uc);
		return (-1);
	}
	free(uc);
#endif	/* NOTYET */
	while (arg && (ndevs < NUADEVS)) {
		if (comma = strchr(arg,','))
			*comma++ = '\0';
		if (*arg == '/') {
			if ((uadevs[ndevs+DEVSKIP] = strdup(arg)) == NULL) {
				fprintf(stderr,
				"%s: out of memory adding '%s' device\n",
					prognamp,arg);
				ndevs = 0;
				return (-1);
			}
		} else {
			if ((uc = malloc(strlen(DEF_DEVDIR)+strlen(arg)+1))
				== NULL) {
				fprintf(stderr,
				"%s: out of memory adding '%s' device\n",
					prognamp,arg);
				ndevs = 0;
				return (-1);
			}
			strcpy(uc,DEF_DEVDIR);
			strcat(uc,arg);
			uadevs[ndevs+DEVSKIP] = uc;
		}
		ndevs++;
		arg = comma;
	}
	uadevs[ndevs+DEVSKIP] = NULL;
	return (0);
}

chk_min_label(arg,ta_st)
char		*arg;
ttyauth_t	*ta_st;
{
slabel_t	label, *l, *tl;
int		i;

	l = &label;
	if (!cvt_sym_slabel(arg,l))
		return (-1);
	tl = &ta_st->ta_minlabel;
	tl->level = l->level;
	for (i = 0; i < MAXCATLST; i++)
		tl->catlst[i] = l->catlst[i];
	return (0);
}

chk_max_label(arg,ta_st)
char		*arg;
ttyauth_t	*ta_st;
{
slabel_t	label, *l, *tl;
int		i;

	l = &label;
	if (!cvt_sym_slabel(arg,l))
		return (-1);
	tl = &ta_st->ta_maxlabel;
	tl->level = l->level;
	for (i = 0; i < MAXCATLST; i++)
		tl->catlst[i] = l->catlst[i];
	return (0);
}

/*
 * Check for valid audit mask.
 */
chk_amask(arg,amask)
char	*arg;
uint	*amask;
{
	if (!arg || !*arg)
		return (-1);
	amask[0] = 0;
	amask[1] = 0;
	prof_compact(arg);
	if (parseamask(arg,amask) < 0)
		return (-1);
	return (0);
}

chk_pwmode(arg)
char	*arg;
{
int	mode, val;

	if (!arg || !*arg)
		return (-1);
	prof_compact(arg);
	mode = 0;
	while (*arg) {
		if (isdigit(*arg)) {
			if ((*arg == '0') && ((*(arg+1) == 'x') ||
					(*(arg+1) == 'X')))
				sscanf((arg+2),"%x",&val);
			else
				val = atoi(arg);
		} else	{
			val = prof_match(arg,&modetable[0]);
		}
		if (val < 0)
			return (-1);
		mode |= val;
		if ((arg = strchr(arg,',')) == NULL)
			return (mode);
		arg++;
	}
	return (-1);
}

chk_pwgen(arg)
char	*arg;
{
int	pwgen;

	if (!arg || !*arg)
		return (-1);
	if (isdigit(*arg)) {
		if ((*arg == '0') && ((*(arg+1) == 'x') || (*(arg+1) == 'X')))
			sprintf((arg+2),"%x",&pwgen);
		else
			pwgen = atoi(arg);
		if ((pwgen < PWGEN0) || (pwgen > PWGEN7))
			return (-1);
	} else	{
		if ((pwgen = prof_match(arg,&pwgentable[0])) < 0)
			return (-1);
	}
	return (pwgen);
}
