/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) loadprof.c: version 25.1 created on 12/2/91 at 16:44:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)loadprof.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>
#include	<values.h>
#include	<auth.h>
#include	"userprof.h"
#include	"loadprof.h"

/*
 * Last entry must be all zeroes (0) to mark the end of the table.
 */
prof_t	prof_all[] = {
	{ "UA_USER_ID",			UA_USER_ID,	PR_UID,    0,	0, },
	{ "UA_GROUP_NAME",		UA_GROUP_NAME,	PR_STR,    0,	0, },
	{ "UA_GROUP_ID",		UA_GROUP_ID,	PR_GID,    0,	0, },
	{ "UA_GECOS",			UA_GECOS,	PR_STR,    0,	0, },
	{ "UA_HOME_PATH",		UA_HOME_PATH,	PR_STR,    0,	0, },
	{ "UA_HOME_DIR",		UA_HOME_DIR,	PR_STR,    0,	0, },
	{ "UA_SHELL",			UA_SHELL,	PR_STR,    0,	0, },
	{ "UA_ROLE",			UA_ROLE,	PR_ROLE,   0,	0, },
	{ "UA_PASSWORD_MODE",	  UA_PASSWORD_MODE,	PR_MODE,   0,	0, },
	{ "UA_PASSWORD_GEN",	  UA_PASSWORD_GEN,	PR_PWGEN,  0,	0, },
	{ "UA_MIN_PASSWORD_LIFE", UA_MIN_PASSWORD_LIFE,	PR_INT, DAYS_YR,0, },
	{ "UA_MAX_PASSWORD_LIFE", UA_MAX_PASSWORD_LIFE,	PR_INT, DAYS_YR,0, },
	{ "UA_MAX_LOGIN_TRIES",	  UA_MAX_LOGIN_TRIES,	PR_INT, MAXINT,	0, },
	{ "UA_ACCT_STATUS",	  UA_ACCT_STATUS,	PR_STAT,   0,	0, },
	{ "UA_AUDIT_MASK",	  UA_AUDIT_MASK,	PR_AMASK,  0,	0, },
	{ "UA_ACCESS_TIMES",	  UA_ACCESS_TIMES,	PR_TIMES,  0,	0, },
	{ "UA_DEVICE_LIST",	  UA_DEVICE_LIST,	PR_DEVLIST,0,	0, },
	{ "TA_MAX_LOGIN_TRIES",	  TA_MAX_LOGIN_TRIES,	PR_INT, MAXINT, 0, },
	{ "TA_DELAY",			TA_DELAY,	PR_INT, MAXINT, 0, },
	{ "TA_SAK_KEYS",		TA_SAK_KEYS,	PR_SAK,    0,	0, },
	{ "TA_MAX_INACTIVE",		TA_MAX_INACTIVE,PR_INT, MAXINT,	0, },
	{ "TA_MIN_LABEL",		TA_MIN_LABEL,	PR_LABEL,  0,	0, },
	{ "TA_MAX_LABEL",		TA_MAX_LABEL,	PR_LABEL,  0,	0, },
	{ "TA_ADD_USERS",		TA_ADD_USERS,	PR_USERS,  0,	0, },
	{ "TA_DEL_USERS",		TA_DEL_USERS,	PR_USERS,  0,	0, },
	{ "TA_ADD_GROUPS",		TA_ADD_GROUPS,	PR_GROUPS, 0,	0, },
	{ "TA_DEL_GROUPS",		TA_DEL_GROUPS,	PR_GROUPS, 0,	0, },
	{ 0,				0,		0,	   0,	0, },
};

valtab_t	modetable[] = {
	"NO_PASS_CHANGE",	AUTO_MODE(NO_PASS_CHANGE),
	"NO_PASS_NEED",		AUTO_MODE(NO_PASS_NEED),
	0,			0,
};

valtab_t	stattable[] = {
	"NOLOCK",		NOLOCK,
	"UNLOCK",		NOLOCK,
	"LOCKED",		LOCKED,
	"LOCK",			LOCKED,
	"RETIRE",		RETIRE,
	0,			0,
};

valtab_t	pwgentable[] = {
	"PWGEN0",		PWGEN0,
	"PWGEN1",		PWGEN1,
	"PWGEN2",		PWGEN2,
	"PWGEN3",		PWGEN3,
	"PWGEN4",		PWGEN4,
	"PWGEN5",		PWGEN5,
	"PWGEN6",		PWGEN6,
	"PWGEN7",		PWGEN7,
	0,			0,
};

valtab_t	saktable[] = {
	"BREAK",	SAK_BREAK,
	"SAK_BREAK",	SAK_BREAK,
	"CARR",		SAK_CARR,
	"SAK_CARR",	SAK_CARR,
	"CARRIER",	SAK_CARR,
	"SAK_CARRIER",	SAK_CARR,
	"ONEKEY",	SAK_1KEY,
	"SAK_1KEY",	SAK_1KEY,
	"SAK_1KEYS",	SAK_1KEY,
	"TWOKEYS",	SAK_2KEYS,
	"SAK_2KEYS",	SAK_2KEYS,
	"THREEKEYS",	SAK_3KEYS,
	"SAK_3KEYS",	SAK_3KEYS,
	"KEYS",		SAK_3KEYS,
	0,		0,
};

prof_t	*prtable;

char	profile_path[PATH_MAX+1];
char	*uadevs[NUADEVS+DEVSKIP+1];

int	ndevs;

extern	char	*prognamp;		/* program name - in passmgmt.c */

/*
 *	The lines can be freeform and follow standard 'sh' conventions
 *	for comments.  Values (right side of '=') assigned to
 *	parameters (left side of '=') can be enclosed in
 *	single (') or double (") or reverse (`) quotes.
 *	The outside-most quotes will be discarded and everything within
 *	them becomes the parameter's value.
 */
loadprof(prfile)
register char		*prfile;
{
register FILE		*prfp;
register prof_t		*prbp;
register char		*t, *t2, *tend, *tcmnt, quote;
register int		totcnt, prcnt, lenn, lenv;
static	 char		prline[PROFLINESZ+1];	/* +1 for NULL	*/

	if ((prfp = fopen(prfile,"r")) == NULL) {
		fprintf(stderr,"%s: '%s': ",prognamp,prfile);
		perror("fopen #1");
		prtable = NULL;
		return (-1);
	}
	totcnt = 0;
	prline[PROFLINESZ] = '\0';	/* requires size+1 above	*/
	/*
	 * Scan the profile file counting all lines which have an '='
	 * in them.
	 */
	while (fgets(prline,PROFLINESZ,prfp) != NULL) {
		/*
		 * Point to beginning of the input line.
		 */
		t = prline;
		/*
		 * Point physical end of input line to
		 * where the last newline is detected or
		 * to maximum buffer size if there was no newline.
		 */
		if (tend = strrchr(prline,'\n'))
			*tend = '\0';
		else
			tend  = &prline[PROFLINESZ];
		while (t < tend) {
			if (*t == '=') {
				totcnt++;
				break;
			}
			t++;
		}
	}
	fclose(prfp);
	if (!totcnt) {
		prtable = NULL;
		return (0);
	}
	if ((prfp = fopen(prfile,"r")) == NULL) {
		fprintf(stderr,"%s: '%s': ",prognamp,prfile);
		perror("fopen #2");
		prtable = NULL;
		return (-2);
	}
	if ((prbp = (prof_t *)malloc((totcnt + 1) * sizeof(prof_t))) == NULL) {
		fprintf(stderr,"%s: can't get %d bytes: ",prognamp,
			((totcnt + 1) * sizeof(prof_t)));
		perror("malloc");
		fclose(prfp);
		prtable = NULL;
		return (-3);
	}
	bzero((char *)prbp,((totcnt + 1) * sizeof(prof_t)));
	prtable = prbp;
	prcnt = 0;
	prline[PROFLINESZ] = '\0';	/* requires size+1 above	*/
	while (fgets(prline,PROFLINESZ,prfp) != NULL) {
		if (prcnt < totcnt) {
			/*
			 * Point to beginning of the input line.
			 */
			t = prline;
			/*
			 * Point physical end of input line to
			 * where the last newline is detected or
			 * to maximum buffer size if there was no
			 * newline.
			 */
			if (tend = strrchr(prline,'\n'))
				*tend = '\0';
			else
				tend  = &prline[PROFLINESZ];
			/*
			 * Save location of what could be start of
			 * the comment part of the line unless it
			 * is later determined to be within quotes.
			 */
			if ((tcmnt = strchr(prline,'#')) == NULL)
				tcmnt = tend;
			/*
			 * Skip spaces/tabs at beginning of line.
			 */
			while (*t && (t < tend) && ((*t == ' ') ||
				(*t == '\t')))
				t++;
			/*
			 * If out of data or this line is a comment,
			 * skip it.
			 */
			if ((*t == '\0') || (t >= tend) || (*t == '#'))
				continue;
			/*
			 * Save start of parameter name.
			 */
			t2 = t;
			/*
			 * Its length initially is zero.
			 */
			lenn = 0;
			/*
			 * Scan until end of the parameter name.
			 */
			while (*t && (t < tend) &&
				(*t != ' ') &&
				(*t != '\t') &&
				(*t != '#') &&
				(*t != '=') &&
				(*t != '\n'))
				t++, lenn++;
			/*
			 * If out of data or past an embedded comment
			 * delimiter (#) then skip this line.
			 */
			if ((*t == '\0') || (t >= tend) || (t >= tcmnt))
				continue;
			/*
			 * Skip spaces/tabs after parameter name.
			 */
			while (*t && (t < tend) &&
					((*t == ' ') || (*t == '\t')))
				t++;
			/*
			 * If not '=' or out of data then
			 * skip this line.
			 */
			if ((*t != '=') || (t >= tend))
				continue;
			t++;	/* skip '=' */
			/*
			 * NULL terminate name of the parameter and then
			 * copy it to our table after making it upper case.
			 */
			*(t2 + lenn)  = '\0';
			mkupper(t2);
			prbp->pr_name = strdup(t2);
			/*
			 * Skip spaces/tabs after '=' in line.
			 */
			while (*t && (t < tend) &&
					((*t == ' ') || (*t == '\t')))
				t++;
			/*
			 * If out of data or this line is a comment,
			 * mark the entry with name but no value and
			 * continue.
			 */
			if ((*t == '\0') || (t >= tend) || (*t == '#')) {
				prbp->pr_str  = NULL;
				prbp->pr_type = PR_UNFORMATED;
				prbp->pr_flag = PR_FLAG_NULL;
				prcnt++;
				prbp++;
				continue;
			}
			/*
			 * Remove outmost quotes, if any.
			 * The opening quote must be the first
			 * non-space character after the '='.
			 * If there is no closing quote then we just
			 * ignore the opening quote and continue
			 * as if there were no quotes at all.
			 * Anything after the closing quote is
			 * ignored.
			 */
			lenv = 0;	/* initial value length is 0 */
			if ((*t == '"') || (*t == '\'') || (*t == '`')) {
				quote = *t;
				/*
				 * Shift left rest of the line
				 * clobbering opening quote.
				 */
				for (t2 = t; t2 < tend; t2++)
					*t2 = *(t2+1);
				/*
				 * Find closing quote and if it
				 * exists, then replace it with a NULL.
				 * We also save the length
				 * of the quoted string.
				 */
				if (t2 = strrchr(t,quote)) {
					lenv = t2 - t;
					*t2 = '\0';
				}
			}
			if (lenv == 0) {
				/*
				 * Save start of parameter value.
				 */
				t2 = t;
				/*
				 * Scan until end of the parameter value.
				 * Last 2 checks are redundunt but
				 * robustness is the name of the game.
				 * Then, NULL terminate the string.
				 */
				while (*t2 && (t2 < tend) && (t2 < tcmnt) &&
						(*t2 != ' ') &&
						(*t2 != '\t') &&
						(*t2 != '#') &&
						(*t2 != '\n'))
					t2++, lenv++;
				*t2 = '\0';
			}
			/*
			 * At this point, 't' points to beginning of
			 * parameter value in line and 'lenv' has its
			 * length.
			 */
			if (lenv > 0) {
				prbp->pr_str  = strdup(t);
				prbp->pr_flag = PR_FLAG_DEFINED;
			} else	{
				prbp->pr_str  = NULL;
				prbp->pr_flag = PR_FLAG_NULL;
			}
			prbp->pr_type = PR_UNFORMATED;
			prcnt++;
			prbp++;
		}
	}
	fclose(prfp);
	if (prtable == prbp) {
		prtable = NULL;
		return (0);
	}
	/*
	 * Mark parameter table end with NULL pointers.
	 */
	prbp->pr_name = NULL;
	prbp->pr_str  = NULL;
	return (prcnt);
}

fillprof(ptab)
register prof_t	*ptab;
{
register prof_t	*prbp;
register int	prcnt;
register char	*p;

	if ((prtable == NULL) || (ptab == NULL))
		return (0);
	prcnt = 0;
	prbp  = prtable;
	while (ptab->pr_name) {
		mkupper(ptab->pr_name);	/* convert to upper case	*/
		ptab->pr_flag = PR_FLAG_NONE;
		while (prbp->pr_name) {	/* already in upper case	*/
			if (strcmp(ptab->pr_name,prbp->pr_name) == 0) {
				prcnt++;
				ptab->pr_flag = prbp->pr_flag;
				ptab->pr_int  = 0;	/* clear by default */
				if (prbp->pr_flag != PR_FLAG_DEFINED)
					break;	/* while */
				p = prbp->pr_str;
				switch (ptab->pr_type) {
				case PR_INT:
					if (isdigit(*p)) {
						if ((*p == '0') &&
							((*(p+1) == 'x') ||
							(*(p+1) == 'X')))
							sprintf((p+2),
								"%x",
								&ptab->pr_int);
						else
							ptab->pr_int =atoi(p);
					} else	{
						mkupper(p);
						if (strcmp(p,"TRUE") == 0)
							prbp->pr_int = 1;
						else
							if (strcmp(p,"FALSE") ==
									0)
								prbp->pr_int=0;
							else {
								prbp->pr_int=0;
								prbp->pr_flag =
								PR_FLAG_NULL;
							}
					}
					break;	/* switch */

				case PR_UID:
					if ((*p == '0') && ((*(p+1) == 'x') ||
							(*(p+1) == 'X'))) {
						sprintf((p+2),"%x",
							&ptab->pr_int);
						ptab->pr_uid =
							(uid_t)ptab->pr_int;
					} else
						ptab->pr_uid = (uid_t)atoi(p);
					break;	/* switch */

				case PR_GID:
					if ((*p == '0') && ((*(p+1) == 'x') ||
							(*(p+1) == 'X'))) {
						sprintf((p+2),"%x",
							&ptab->pr_int);
						ptab->pr_gid =
							(gid_t)ptab->pr_int;
					} else
						ptab->pr_gid = (gid_t)atoi(p);
					break;	/* switch */

				case PR_STR:
				case PR_ROLE:
				case PR_MODE:
				case PR_PWGEN:
				case PR_STAT:
				case PR_AMASK:
				case PR_TIMES:
				case PR_USERS:
				case PR_LABEL:
				case PR_SAK:
				case PR_DEVLIST:
					ptab->pr_str = strdup(p);
					break;	/* switch */

				default:
					break;	/* switch */
				}
				break;	/* while */
			}
			prbp++;
		}
		ptab++;
	}
	return (prcnt);
}
