/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) loaddefs.h: version 25.1 created on 12/2/91 at 16:44:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)loaddefs.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifndef	LOADDEFS_H
#define	LOADDEFS_H

extern	FILE	*defopen();
extern  void 	defclose();
extern  char	*defread();
extern	char 	*strdup();
extern	int	load_defs();
extern	char	*user_id_to_str();
extern	uid_t	str_to_user_id();

typedef struct {
	char 	name[25];
	uint	types;
	uint	int_max;
} defs_des_t;

struct default_values {
	int def_flag;
	union def_union {
		int	d_int;
		char 	*d_charp;
		uid_t	d_uid;
		gid_t	d_gid;
		mode_t	d_mode;
	} def_vals;
};

extern	struct default_values	defs[];

/* define the values of the types for the defs_des_t */
#define DES_INT		0x01
#define DES_CHARP	0x02
#define DES_UID		0x03
#define DES_GID		0x04
#define DES_MODE	0x05
#define PASSWORD_CHOOSE	0xff

/* Some defines to get rid of the union */
#define def_int		def_vals.d_int
#define def_charp	def_vals.d_charp
#define def_uid		def_vals.d_uid
#define def_gid		def_vals.d_gid
#define	def_mode	def_vals.d_mode

/* some defines to help the length of this data structure */
#define defs_int(x)		defs[ (x) ].def_int
#define defs_char(x)	defs[ (x) ].def_charp
#define defs_uid(x)		defs[ (x) ].def_uid
#define defs_gid(x)		defs[ (x) ].def_gid
#define defs_mode(x)	defs[ (x) ].def_mode
#define defs_flag(x)	defs[ (x) ].def_flag

/* Integer defines for the forms */
#define DAYS_YR	365
#define DAYS_WK 7

/* The location of the defaults file */
#define 	AUTH_DEFAULT_FILE	"/etc/default/authsh"
#define 	SAT_DEFAULT_FILE	"/etc/default/sat"

#define NO_UID	((uid_t)(-1))
#define NO_GID	((gid_t)(-1))

/*
 * uid.c
*/

#ifndef MINUID
#define MINUID	1		/* Min legal UID value on this system	*/
#endif

#define MIN_ADMIN_UID	1	/* Min UID the administrator can choose	*/
#define MAX_ADMIN_UID	MAXUID	/* Max UID the administrator can choose	*/

#define MIN_SUGGEST_UID	200	/* Min UID this program will suggest	*/
#define MAX_SUGGEST_UID	MAXUID	/* Max UID this program will suggest	*/


enum ID_choice {
	LegalValues		/* All possible valid U/GIDs	*/
};

/*
	Assign values for the default string array

	NOTE: If you add to this list of strings you MUST add the new
		value at the bottom of the array AND add a "define".

	The possible values for the types are (defined in libdef.h):
		DES_CHARP - character pointer
		DES_MODE - when mode bits are used
		DES_UID - when uid values are changed
		DES_GID - when gid values are changed
		DES_INT - is for intergers, they also used the last field
				(int_max).  This is used a a maximum value for
				intergers.
		PASSWORD_CHOOSE - is a special value used for choosing a
				password.  converts string or number to integer.
*/
static defs_des_t defs_str[] = {
	"LOGIN_GROUP=",DES_CHARP,0,
	"SHELL=",DES_CHARP,0,
	"HOME_DIR=",DES_CHARP,0,
	"HOME_MODE=",DES_MODE,0,
	"MIN_ADMIN_UID=",DES_UID,0,
	"MAX_ADMIN_UID=",DES_UID,0,
	"MIN_SUGGEST_UID=",DES_UID,0,
	"MAX_SUGGEST_UID=",DES_UID,0,
	"MIN_ADMIN_GID=",DES_GID,0,
	"MAX_ADMIN_GID=",DES_GID,0,
	"MIN_SUGGEST_GID=",DES_GID,0,
	"MAX_SUGGEST_GID=",DES_GID,0,
	"PASSWORD_MIN=",DES_INT,DAYS_YR,
	"PASSWORD_MAX=",DES_INT,DAYS_YR,
	"PASSWORD_LIFETIME=",DES_INT,DAYS_YR,
	"PASSWORD_CHOOSE=",PASSWORD_CHOOSE,0,
	"PASSWORD_MODE=",DES_INT,DAYS_WK,
	"PRIVLEDGE=",DES_CHARP,0,
	"MAC_LABEL=",DES_CHARP,0,
	"ACCESS_TIMES=",DES_CHARP,0,
	"UNSUCCESS_LOGIN_MAX=",DES_INT,MAXINT,
	"UNSUCCESS_TTY_MAX=",DES_INT,MAXINT,
	"SAT_BUFFER=",DES_INT,MAXINT,
	"HIGH_H20_MARK=",DES_INT,MAXINT,
	"CALLOUT_TIME=",DES_INT,MAXINT,
	"FILES=",DES_CHARP,0,
	"BLOCKS=",DES_INT,MAXINT,
	"MASK=",DES_INT,MAXINT
};

#define DEFAULT_MAX  sizeof(defs_str)/sizeof(defs_des_t)

#define LOGIN_GROUP		0
#define SHELL			1
#define HOME_DIR		2
#define HOME_MODE		3
#define MIN_ADM_UID		4
#define MAX_ADM_UID		5
#define MIN_SUG_UID		6
#define MAX_SUG_UID		7
#define MIN_ADMIN_GID		8
#define MAX_ADMIN_GID		9
#define MIN_SUGGEST_GID		10
#define MAX_SUGGEST_GID		11
#define PASSWORD_MIN		12
#define PASSWORD_MAX		13
#define PASSWORD_LIFETIME	14
#define PASSWD_CHOOSE		15
#define PASSWORD_MODE		16
#define PRIVLEDGE		17
#define MAC_LABEL		18
#define ACCESS_TIMES		19
#define UNSUCCESS_LOGIN_MAX	20
#define UNSUCCESS_TTY_MAX	21
#define SAT_BUFFER		22
#define HIGH_H20_MARK		23
#define CALLOUT_TIME		24
#define FILES			25
#define BLOCKS			26
#define MASK			27

#endif	/* LOADDEFS_H */
