/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) loaddefs.c: version 25.1 created on 12/2/91 at 16:44:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)loaddefs.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<stdio.h>
#include	<values.h>
#include	<grp.h>
#include	"loaddefs.h"

load_defs(File_name)
char	*File_name;
{
	char *str;
	int	i;
	int	 val;
	unsigned u;
	uid_t uid;
	gid_t gid;
	FILE *fp;
	struct group *group_ptr;

	/* Clear out the defs array */
	(void) memset(
		(char *)defs, 0, 
		sizeof(struct default_values) * DEFAULT_MAX
	);

	if ( (fp = defopen(File_name)) == NULL )
		return (0);

	for (i = 0; i < DEFAULT_MAX; i++) {
		if ((str = defread(defs_str[i].name,fp)) != (char *)0) {
			switch (defs_str[i].types) {
			case DES_INT:
				if (is_decimal_int(str, 0, defs_str[i].int_max, &val)) {
					defs_flag(i) = 1;
					defs_int(i) = val;
				}
				break;

			case DES_CHARP:
				defs_flag(i) = 1;
				if (i == LOGIN_GROUP) {
					if ((group_ptr = getgrnam(str)) == NULL) {
						bad_login_group(str);
					}
					else
						defs_gid(i) = (gid_t) group_ptr->gr_gid;
				}
				else	
					defs_char(i) = strdup(str);
				break;

			case DES_UID:
				if ((uid = str_to_user_id(str, LegalValues,
							(char *)0, 0)) != NO_UID) {
					defs_flag(i) = 1;
					defs_uid(i) = uid;
				}
				break;

			case DES_GID:
				if ((gid = str_to_user_id(str, LegalValues,
							(char *)0, 0)) != NO_GID) {
					defs_flag(i) = 1;
					defs_gid(i) = gid;
				}
				break;

			case DES_MODE:
				if (is_octal_unsigned(str, 0, 0777, &u)) {
					defs_flag(i) = 1;
					defs_mode(i) = u;
				}
				break;

			case PASSWORD_CHOOSE:
				if (*str == 'T' || *str == 't' || *str == '1') {
					defs_flag(i) = 1;
					defs_int(i) = 1;
				}
				else if (*str == 'F' || *str == 'f' || *str == '0') {
					defs_flag(i) = 1;
					defs_int(i) = 0;
				}
				break;

			default:
				(void) fprintf(stderr,"Load Defaults: Incorrect value\n");
				break;
			}
		} /* end of if */
	} /* end of for */

	defclose(fp);
}

FILE *
defopen(file)
char *file;
{
	FILE *def_fp;

		/* Open the file */
	if ((def_fp = fopen(file, "r")) == NULL) {
		/* It failed */
		return(NULL);
	}
	else {
		/* It worked, store all in statics and return */
		return(def_fp);
	}
}

char *
defread(string, def_fp)
char *string;
FILE *def_fp;
{
	char *p, *strrchr();
	int n;
	static char buf[BUFSIZ];

	rewind(def_fp);
	n = strlen(string);

	while (fgets(buf, BUFSIZ, def_fp) != NULL)
	{
		if (strncmp(buf, string, n) == 0) {
			if ((p = strrchr(buf, '\n')) != NULL)
				*p = '\0';
			p = buf + n;
			return(p);
		}
	}

	/* not found in file */
	return(NULL);
}

void
defclose(def_fp)
FILE *def_fp;
{
	/* Give message only when a close fail occurs */
	if( fclose(def_fp) != 0 ) {
		(void) fprintf(stderr,"Defaults : Cannot close file\n");
	}
}
