/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) listua.c: version 25.1 created on 12/2/91 at 16:44:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)listua.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<grp.h>
#include	<auth.h>

static	char	day_of_week[7][10] = {
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday",
};

/*
 *	listua: prints out the usrauth file.
 */
listua(ua)
register usrauth_t	*ua;
{
register struct	group	*grp;
register int		indx, minlife, maxlife;
register roldef_t	*myrole;
extern	 roldef_t	*get_role_id();

	printf("User name                : %s\n",ua->ua_name);
	printf("User id                  : %d\n",ua->ua_uid);
	if ((grp = (struct group *)getgrgid(ua->ua_gid)) != (struct group *)0)
		printf("Group id                 : %s (%d)\n",
			grp->gr_name,ua->ua_gid);
	else
		printf("Group id                 : %d\n",
			ua->ua_gid);
	printf("Gecos (Comment field)    : %s\n",ua->ua_gecos);
	printf("Home directory           : %s\n",ua->ua_defdir);
	printf("Login shell              : %s\n",ua->ua_defshell);
	if (myrole = get_role_id(ua->ua_role))
		printf("Role                     : %s (%d)\n",
			&myrole->r_name[0],myrole->r_rolenumber);
	else
		printf("Role                     : %d\n",ua->ua_role);
	printf("Password mode            : %d\n",AUTO_MODE(ua->ua_mode));
	printf("Auto-password generator #: %d\n",AUTO_PASS(ua->ua_mode));
	minlife = ua->ua_min_pwdlife;
	maxlife = ua->ua_max_pwdlife;
	printf("Minimum password life    : %d days\n",	
		((minlife < 0) ? (minlife * -1) : minlife));
	printf("Maximum password life    : %d days%s\n",
		((maxlife < 0) ? (maxlife * -1) : maxlife),
		(((minlife < 0) || (maxlife < 0)) ?
			"\tForced Password Expiration" : ""));
	printf("Maximum login retries    : %d\n",ua->ua_maxtries);
	switch (ua->ua_acctstat) {
	case NOLOCK:
		printf("Account Status           : UNLOCKED\n");
		break;

	case LOCKED:
		printf("Account Status           : LOCKED\n");
		break;

	case RETIRE:
		printf("Account Status           : RETIRING\n");
		break;

	default:
		printf("Account Status           : RETIRED on %s",
			ctime(&ua->ua_acctstat));
		break;
	}
	printf("Audit mask (#0, #1)      : 0x%x, 0x%x\n",
		ua->ua_amask[0],ua->ua_amask[1]);
	printf("Access Times:\n");
	for (indx = 0; indx < 7; indx++) {
		/* Check if the times are "*" */
		if (ua->ua_times[indx].st_hr < 0) {
			ua->ua_times[indx].st_hr = 0;
			ua->ua_times[indx].et_hr = 24;
		}
		if (ua->ua_times[indx].st_min < 0) {
			ua->ua_times[indx].st_min = 0;
			ua->ua_times[indx].et_min = 0;
		}
		printf("\tStart %2d:%02d - %s\t - End %2d:%02d\n",
			ua->ua_times[indx].st_hr,
			ua->ua_times[indx].st_min,
			day_of_week[indx],
			ua->ua_times[indx].et_hr,
			ua->ua_times[indx].et_min);
	}
}
