/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) listta.c: version 25.1 created on 12/2/91 at 16:44:28	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)listta.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<stdio.h>
#include	<pwd.h>
#include	<sys/sakioctl.h>
#include	<auth.h>
#include	<grp.h>
#include	"passmgmt.h"

/*
 *	listta - prints out the dev_auth file.
 */
listta(ta)
ttyauth_t	*ta;
{
struct	passwd	*usr;
struct	group	*grp;
char		tmp[128], key1, key2, key3, flags, *up, *ub;
int		indx, ul, len, nl;

	printf("\n\n\nDevice Name                 : %s\n",ta->ta_ttyn);
	switch (ta->ta_status) {
		case 0:
			printf("Device Status               : UNLOCKED\n");
			break;

		case 1:
			printf("Device Status               : LOCKED\n");
			break;

		case 2:
			printf("Device Status               : RETIRED\n");
			break;

		default:
	printf("Device Status               : *** Unknown Status ***\n");
			break;
	}
	flags = ta->ta_sak.flags;
	switch (flags) {
		case SAK_CARR:
			printf("SAK Key                     : CARRIER\n");
			break;

		case SAK_BREAK:
			printf("SAK Key                     : BREAK\n");
			break;

		default:
			printf("SAK Keys                    : ");
			if (flags & SAK_KEYS) {
				key1 = ta->ta_sak.sak_key1;
				key2 = ta->ta_sak.sak_key2;
				key3 = ta->ta_sak.sak_key3;
				if (key1 < ' ')
					printf("'^%c'",(key1|0100));
				else
				    if (key1 == ' ')
					printf("' '");
				    else
					if (key1 == 0177)
						printf("'^? (DEL or 0x%x)'",
							key1);
					else
					    if (key1 > 0177)
						printf("'0x%x'",key1);
					    else
						printf("'%c'",key1);
				if (flags & (SAK_2KEYS | SAK_3KEYS)) {
					if (key2 < ' ')
						printf(", '^%c'",(key2|0100));
					else
					    if (key2 == ' ')
						printf(", ' '");
					    else
						if (key2 == 0177)
						printf(", '^? (DEL or 0x%x)'",
								key2);
						else
						    if (key2 > 0177)
							printf(", '0x%x'",key2);
						    else
							printf(", '%c'",key2);
				}
				if (flags & SAK_3KEYS) {
					if (key3 < ' ')
						printf(", '^%c'",(key3|0100));
					else
					    if (key3 == ' ')
						printf(", ' '");
					    else
						if (key3 == 0177)
						printf(", '^? (DEL or 0x%x)'",
								key3);
						else
						    if (key3 > 0177)
							printf(", '0x%x'",key3);
						    else
							printf(", '%c'",key3);
				}
				printf("\n");
			} else
				printf("*** NONE DEFINED ***\n");
			break;
	}
	printf("Maximum Bad Logins          : %d\n",ta->ta_maxtry);
	printf("Delay Between Logins        : %d second%s\n",
		ta->ta_delay,((ta->ta_delay == 1) ? "" : "s"));
	printf("Maximun Period of Inactivity: %d second%s\n",
		ta->ta_inactive,((ta->ta_inactive == 1) ? "" : "s"));
	printf("File Entry Number           : %d\n",ta->ta_tsentry);
	printf("\n");
	if (mac_name(&ta->ta_minlabel,tmp) < 0)
		printf("Minimum Label               : *** Unknown Label ***\n");
	else
		printf("Minimum Label               : %s\n",tmp);
	if (mac_name(&ta->ta_maxlabel,tmp) < 0)
		printf("Maximum Label               : *** Unknown Label ***\n");
	else
		printf("Maximum Label               : %s\n",tmp);
	printf("\n");
	up = "Users Allowed               : ";
	ul = strlen(up);
	ub = (char *) malloc(ul + 1);
	for (indx = 0; indx < ul; indx++)
		*(ub+indx) = ' ';	/* fill with spaces */
	*(ub+ul) = '\0';		/* NULL terminate */
	printf("%s",up);
	if (ta->ta_users[0] == (uid_t) TA_USERS_ALL)
		printf("*** All users  allowed! ***\n");
	else {
		len = ul;
		for (indx = 0; indx < MAXUG ; indx++) {
			if (ta->ta_users[indx] == (uid_t) -1)
				break;
			if ((usr = getpwuid(ta->ta_users[indx])) == NULL)
				break;
			nl = strlen(usr->pw_name);
			len += nl;
			if (indx > 0)
				len += 2;	/* count for comma & space */
			if (len >= 79) {	/* prevent auto newline    */
				len = ul + nl;
				printf(",\n%s%s",ub,usr->pw_name);
			} else {
				if (indx > 0)
					printf(", ");
				printf("%s",usr->pw_name);
			}
		}
		if (indx)
			printf("\n");
		else
			printf("*** No Users  Allowed! ***\n");
	}
	printf("Groups Allowed              : ");
	if (ta->ta_groups[0] == (gid_t) TA_GROUPS_ALL)
		printf("*** All groups allowed! ***\n");
	else {
		len = ul;
		for (indx = 0; indx < MAXUG ; indx++) {
			if (ta->ta_groups[indx] == (gid_t) -1)
				break;
			if ((grp = getgrgid(ta->ta_groups[indx])) == NULL)
				break;
			nl = strlen(grp->gr_name);
			len += nl;
			if (indx > 0)
				len += 2;	/* count for comma & space */
			if (len >= 79) {	/* prevent auto newline    */
				len = ul + nl;
				printf(",\n%s%s",ub,grp->gr_name);
			} else {
				if (indx > 0)
					printf(", ");
				printf("%s",grp->gr_name);
			}
		}
		if (indx)
			printf("\n");
		else
			printf("*** No Groups Allowed! ***\n");
	}
}
