/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) isnumber.c: version 25.1 created on 12/2/91 at 16:44:25	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)isnumber.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <ctype.h>
#include <values.h>
#include <limits.h>

#ifndef toint
#define	toint(x)	((x) - '0')
#endif

/*
 * is_<radix>_<type>	-- Is a string a base <radix> number fitting <type> ?
 *
 *		is_decimal_int		Decimal (base 10) `int' ?
 *		is_decimal_unsigned	Decimal (base 10) `unsigned' ?
 *		is_octal_unsigned	Octal (base 8) `unsigned' ?
 *		is_<radix>_unsigned	Arbitrary <radix> `unsigned' ?
 *
 *	Call is:
 *
 *		is_<radix>_<type>(string, low, high, pval)
 *
 *	where <radix> and <type> are as above, <low> is the minimum,
 *	<high> is the maximum, and <pval> is a pointer to where the
 *	number's value should be stored (and may be NULL).  Return
 *	is 0 if the string is not a number, would under/over-flow,
 *	or is outside the specified range; if the string is legal,
 *	then its value is placed in *<pval> and non-0 is returned.
 *
 * N.b.	leading and trailing white space are ignored, and for
 *	signed <type>s, leading "+" and "-" symbols are understood.
 */

is_decimal_int(p, lo, hi, pn)
register char *p;
int lo, hi, *pn;
{
	register int n, d;
	int is_negative;

	n = 0;
	while (isspace(*p))
		p++;
	if ((is_negative = (*p == '-')) || *p == '+') {
		do {
			p++;
		} while (isspace(*p));
	}
	if ( ! isdigit(*p))
		return (0);		/* no digits (nothing or garbage) */
	do {
		d = toint(*p);
		if ((MAXINT - d)/10 < n)
			return (0);	/* will overflow (or underflow) */
		n = (n * 10) + d;
		p++;
	} while (isdigit(*p));
	if (is_negative)
		n = -n;
	if (n < lo || hi < n)
		return (0);		/* value out-of-range */
	while (isspace(*p))
		p++;
	if (*p != '\0')
		return (0);		/* garbage characters */
	if (pn != (int *)0)
		*pn = n;
	return (1);			/* valid integer */
}

is_radix_unsigned(radix, p, lo, hi, pn)
unsigned radix;
register char *p;
unsigned lo, hi, *pn;
{
	register unsigned n, d;

	n = 0;
	while (isspace(*p))
		p++;
	if ( ! isdigit(*p))
		return (0);		/* no digits (nothing or garbage) */
	do {
		if ((d = toint(*p)) >= radix)
			return (0);	/* not a <radix> digit */
		if ((USI_MAX - d)/radix < n)
			return (0);	/* will overflow */
		n = (n * radix) + d;
		p++;
	} while (isdigit(*p));
	if (n < lo || hi < n)
		return (0);		/* value out-of-range */
	while (isspace(*p))
		p++;
	if (*p != '\0')
		return (0);		/* garbage characters */
	if (pn != (unsigned *)0)
		*pn = n;
	return (1);			/* valid unsigned integer */
}

is_decimal_unsigned(p, lo, hi, pn)
char *p;
unsigned lo, hi, *pn;
{
	return (is_radix_unsigned(10, p, lo, hi, pn));
}

is_octal_unsigned(p, lo, hi, pn)
char *p;
unsigned lo, hi, *pn;
{
	return (is_radix_unsigned(8, p, lo, hi, pn));
}
