/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) devmgmt.c: version 25.1 created on 12/2/91 at 16:44:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)devmgmt.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<stdio.h>
#include	<signal.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#include	<grp.h>
#include	<auth.h>
#include	"userprof.h"
#include	"passmgmt.h"
#include	"passext.h"

char		*dev_opt_args = "r:D:k:i:s:b:B:u:U:g:G:adlmf:FI";
char		*taprof;
char		tadevice[128];

uid_t		glob_add_uid;
uid_t		glob_del_uid;
gid_t		glob_add_gid;
gid_t		glob_del_gid;

devmgmt(argc,argv)
int	argc;
char	**argv;
{
	int		c, idx, value;
	uid_t		uid, d_uid;
	gid_t		gid, d_gid;
	char		*char_p;
	ttyauth_t 	tmp_ta;
	ttyauth_t 	*ta_st;
	ttystat_t 	tmp_ts;
	ttystat_t 	*ts_st;
	struct group 	*grp;
	struct passwd 	*pwd;
	ttyauth_t 	*tal;

	/* Check if the files exist */
	info_mask = TAUTH_PROFILE;
	info_mask |= chk_access();

	ta_st = &tmp_ta;
	ts_st = &tmp_ts;

	/* Set all the defaults for the structures */
	settatsdefs(ta_st,ts_st,info_mask);

	uid   = (uid_t) -1;
	d_uid = (uid_t) -1;
	gid   = (gid_t) -1;
	d_gid = (gid_t) -1;
	/* parse the command line */
	while((c = getopt(argc,argv,dev_opt_args)) != -1) {
		switch (c) {
		case 'f': /* Allows profile to be specified */
			if (optn_mask & ~(TA_MASK_a | TA_MASK_m))
				dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_f;
			taprof = strdup(optarg);
			break;

		case 'F': /* Use profile name same as device */
			if (optn_mask & ~(TA_MASK_a | TA_MASK_m))
				dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_F;
			taprof = NULL;
			break;

		case 'I': /* Allows default profile to be used */
			if (optn_mask & ~(TA_MASK_a | TA_MASK_m))
				dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_I;
			taprof = NULL;
			break;

		case 'r' : /* The maximum bad login field */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_r) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_r;
			ta_st->ta_maxtry = (ushort)strtol(optarg, &char_p, 10);
			if (ta_st->ta_maxtry < 0)
				bad_arg("Invalid argument to option -r");
			break;

		case 'D': /* The delay between logins */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_D) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_D;
			ta_st->ta_delay = (ushort)strtol(optarg, &char_p, 10);
			if (ta_st->ta_delay < 0)
				bad_arg("Invalid argument to option -D");
			break;

		case 'k': /* The SAK keys */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_k) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			if (chk_sak(optarg,ta_st) < 0)
				bad_arg("Invalid argument to option -k");
			optn_mask |= TA_MASK_k;
			break;

		case 'i': /* The max period of inactivity */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_i) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_i;
			ta_st->ta_inactive = (ushort)strtol(optarg,&char_p,10);
			if (ta_st->ta_inactive < 0)
				bad_arg("Invalid argument to option -i");
			break;

		case 's': /* The status of a tty (unlocked, locked, retired) */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_s) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_s;
			value = chk_stat(optarg);
			if (value < 0)
				bad_arg("Invalid argument to option -s");
			ta_st->ta_status = (ushort) value;
			break;

		case 'b': /* The minimum label of tty */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_b) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			if (chk_min_label(optarg,ta_st) < 0)
				bad_arg("Invalid argument to option -b");
			optn_mask |= TA_MASK_b;
			break;

		case 'B': /* The maximum label of tty */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_B) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			if (chk_max_label(optarg,ta_st) < 0)
				bad_arg("Invalid argument to option -B");
			optn_mask |= TA_MASK_B;
			break;

		case 'u': /* add to list of users (uid #) */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_u) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			value = chk_tausers(optarg);
			if ((value < 0) && (value != TA_USERS_ALL))
				bad_arg("Invalid argument to option -u");
			uid = (uid_t) value;
			optn_mask |= TA_MASK_u;
			break;

		case 'U': /* delete from list of users (uid #) */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_U) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			value = chk_tausers(optarg);
			if ((value < 0) && (value != TA_USERS_ALL))
				bad_arg("Invalid argument to option -U");
			d_uid = (uid_t) value;
			optn_mask |= TA_MASK_U;
			break;

		case 'g': /* add to list of groups (gid #) */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_g) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			value = chk_tagroups(optarg);
			if ((value < 0) && (value != TA_GROUPS_ALL))
				bad_arg("Invalid argument to option -g");
			gid = (gid_t) value;
			optn_mask |= TA_MASK_g;
			break;

		case 'G': /* delete from list of groups (gid #) */
			if ((TA_MASK_l | TA_MASK_d | TA_MASK_G) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			value = chk_tagroups(optarg);
			if ((value < 0) && (value != TA_GROUPS_ALL))
				bad_arg("Invalid argument to option -G");
			d_gid = (gid_t) value;
			optn_mask |= TA_MASK_G;
			break;

		case 'a': /* -a, add device option... */
			if ((TA_MASK_a | TA_MASK_m | TA_MASK_d |
					TA_MASK_l) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_a;
			break;

		case 'l': /* -l list device information... */
			if ((TA_MASK_a | TA_MASK_m | TA_MASK_d | TA_MASK_l |
				TA_MASK_r | TA_MASK_D | TA_MASK_k | TA_MASK_i |
				TA_MASK_s | TA_MASK_b | TA_MASK_B | TA_MASK_u |
				TA_MASK_g) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_l;
			break;

		case 'd': /* -d, delete (retire) device option */
			if ((TA_MASK_a | TA_MASK_m | TA_MASK_d | TA_MASK_l |
				TA_MASK_r | TA_MASK_D | TA_MASK_k | TA_MASK_i |
				TA_MASK_s | TA_MASK_b | TA_MASK_B | TA_MASK_u |
				TA_MASK_g) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_d;
			break;

		case 'm': /* -m, modify device option */
			if ((TA_MASK_a | TA_MASK_m | TA_MASK_d |
					TA_MASK_l) & optn_mask)
		        	dev_bad_usage("Invalid combination of options");
			optn_mask |= TA_MASK_m;
			break;

		case '?':
			dev_bad_usage("");
			break;
		}
	}
	/*
	 * Check command syntax for the following errors:
	 * too few or too many arguments, or
	 * no -a, -m, -l or -d option, or
	 * -m with no other option.
	 */
	if ((optind == argc) ||
		!((TA_MASK_a | TA_MASK_m | TA_MASK_d | TA_MASK_l) & optn_mask)||
		((optn_mask & TA_MASK_m) && !(optn_mask &
		(TA_MASK_r | TA_MASK_D | TA_MASK_k | TA_MASK_i | TA_MASK_s |
		TA_MASK_b | TA_MASK_B | TA_MASK_u | TA_MASK_g |
		TA_MASK_U | TA_MASK_G | TA_MASK_f | TA_MASK_F | TA_MASK_I))))
		dev_bad_usage("Invalid command syntax");
	for ( ; optind < argc; optind++) {
		/*
		 * Null string argument or bad characters?
		 */
		if ((strlen(argv[optind]) == 0) || strpbrk(argv[optind],":\n"))
			bad_arg("Invalid device name");
		if (strchr(argv[optind],'/') == NULL) {
			strcpy(tadevice,DEF_DEVDIR);
			strcat(tadevice,argv[optind]);
		} else
			strcpy(tadevice,argv[optind]);
		if (optn_mask & TA_MASK_f) {
			if (settatsprof(taprof,ta_st,ts_st,info_mask) < 0)
				continue;
			uid   = glob_add_uid;
			d_uid = glob_del_uid;
			gid   = glob_add_gid;
			d_gid = glob_del_gid;
		}
		if (optn_mask & TA_MASK_F) {
			if (taprof = strrchr(tadevice,'/'))
				taprof++;
			else
				taprof = tadevice;
			if (settatsprof(taprof,ta_st,ts_st,info_mask) < 0)
				continue;
			uid   = glob_add_uid;
			d_uid = glob_del_uid;
			gid   = glob_add_gid;
			d_gid = glob_del_gid;
		}
		if (optn_mask & TA_MASK_I) {
			if (settatsprof(0,ta_st,ts_st,info_mask) < 0)
				continue;
			uid   = glob_add_uid;
			d_uid = glob_del_uid;
			gid   = glob_add_gid;
			d_gid = glob_del_gid;
		}
		/*
		 * If we are deleting a user then copy tty name
		 * into the data structures.
		 */
		if (TA_MASK_d & optn_mask)
			strncpy(ta_st->ta_ttyn, tadevice, NAME_MAX);
		/*
		 * if we are adding, modifying, or listing a user then
		 * copy tty info into the data structures.
		 */
		if ((TA_MASK_a & optn_mask) || (TA_MASK_l & optn_mask) ||
				(TA_MASK_m & optn_mask)) {
			strncpy(ta_st->ta_ttyn, tadevice, NAME_MAX);
			if ((tal = gettanam(ta_st->ta_ttyn)) != NULL) {
				/*
				 * Have valid list of uids but want to
				 * delete all.
				 */
				if ((optn_mask & TA_MASK_U) &&
					(d_uid == (uid_t) TA_USERS_ALL)) {
					ta_st->ta_users[0] = (uid_t) -1;
					ta_st->ta_users[1] = (uid_t) -1;
				} else {
				    /*
				     * If the start of the array is '*'
				     * (allow all uids), then don't add.
				     */
				    if (tal->ta_users[0] ==
						(uid_t) TA_USERS_ALL) {
					ta_st->ta_users[0] =
						(uid_t) TA_USERS_ALL;
					ta_st->ta_users[1] = (uid_t) -1;
				    } else {
					register uid_t	    *up;

					/*
					 * Copy original array to new one
					 * deleting user ids selected for
					 * deletion.
					 * Don't add duplicate users.
					 */
					up = &ta_st->ta_users[0];
					for (idx = 0; idx < MAXUG; idx++) {
						/*
						 * Delete user id selected for
						 * deletion.
						 */
						if ((optn_mask & TA_MASK_U) &&
							(tal->ta_users[idx] ==
								d_uid)) {
							*up = (uid_t) -1;
							continue;
						}
						/*
						 * Don't add duplicate users.
						 */
						if ((optn_mask & TA_MASK_u) &&
							(tal->ta_users[idx] ==
								uid)) {
							optn_mask &= ~TA_MASK_u;
							*up = (uid_t) -1;
							continue;
						}
						/*
						 * Add uid to list of uids
						 * and stop copy because we
						 * hit end of original array.
						 */
						if ((optn_mask & TA_MASK_u) &&
							(tal->ta_users[idx] ==
								(uid_t) -1)) {
							*up++ = uid;
							*up   = (uid_t) -1;
							break;
						}
						/*
						 * Stop copy because we have
						 * hit end of original array.
						 */
						if (tal->ta_users[idx] ==
								(uid_t) -1) {
							*up = (uid_t) -1;
							break;
						}
						/*
						 * Copy user id.
						 */
						*up++ = tal->ta_users[idx];
					}
				    }
				}
				/*
				 * Have valid list of gids but want
				 * to delete all.
				 */
				if ((optn_mask & TA_MASK_G) &&
					(d_gid == (gid_t) TA_GROUPS_ALL)) {
					ta_st->ta_groups[0] = (gid_t) -1;
					ta_st->ta_groups[1] = (gid_t) -1;
				} else {
				    /*
				     * If the start of the array is '*'
				     * (allow all gids), then don't add.
				     */
				    if (tal->ta_groups[0] ==
						(gid_t) TA_GROUPS_ALL) {
					ta_st->ta_groups[0] =
						(gid_t) TA_GROUPS_ALL;
					ta_st->ta_groups[1] = (gid_t) -1;
				    } else {
					register gid_t	    *gp;

					/*
					 * Copy original array to new one
					 * deleting group ids selected
					 * for deletion.
					 * Don't add duplicate groups.
					 */
					gp = &ta_st->ta_groups[0];
					for (idx = 0; idx < MAXUG; idx++) {
						/*
						 * Delete group id selected for
						 * deletion.
						 */
						if ((optn_mask & TA_MASK_G) &&
							(tal->ta_groups[idx] ==
								d_gid)){
							*gp = (gid_t) -1;
							continue;
						}
						/*
						 * Don't add duplicate groups.
						 */
						if ((optn_mask & TA_MASK_g) &&
							(tal->ta_groups[idx] ==
								gid)) {
							optn_mask &= ~TA_MASK_g;
							*gp = (gid_t) -1;
							continue;
						}
						/*
						 * Add gid to list of gids
						 * and stop copy because we
						 * hit end of original array.
						 */
						if ((optn_mask & TA_MASK_g) &&
							(tal->ta_groups[idx] ==
								(gid_t) -1)) {
							*gp++ = gid;
							*gp   = (gid_t) -1;
							break;
						}
						/*
						 * Stop copy because we have
						 * hit end of original array.
						 */
						if (tal->ta_groups[idx] ==
								(gid_t) -1) {
							*gp = (gid_t) -1;
							break;
						}
						/*
						 * Copy group id.
						 */
						*gp++ = tal->ta_groups[idx];
					}
				    }
				}
				/*
				 * adding - Set the array to TA_USERS_ALL (-2)
				 * if uid is -2.
				 */
				if ((uid == (uid_t) TA_USERS_ALL) &&
						(optn_mask & TA_MASK_u)) {
					ta_st->ta_users[0] =
						(uid_t) TA_USERS_ALL;
					ta_st->ta_users[1] = (uid_t) -1;
				}
				/*
				 * deleting - Set the array to -1 if d_uid
				 * is TA_USERS_ALL.
				 */
				if ((d_uid == (uid_t) TA_USERS_ALL) &&
					(optn_mask & TA_MASK_U) &&
					(tal->ta_users[0] ==
						(uid_t) TA_USERS_ALL))
					ta_st->ta_users[0] = (uid_t) -1;
				if ((d_uid != (uid_t) TA_USERS_ALL) &&
						(optn_mask & TA_MASK_U) &&
					(tal->ta_users[0] ==
						(uid_t) TA_USERS_ALL)) {
					idx = 0;
					while ((pwd = getpwent()) != NULL)
						if (pwd->pw_uid != d_uid) {
							ta_st->ta_users[idx] =
								pwd->pw_uid;
							idx++;
						}
					ta_st->ta_users[idx] = (uid_t) -1;
				}
				/*
				 * adding - Set the array to TA_GROUPS_ALL (-2)
				 * if gid is -2.
				 */
				if ((gid == (gid_t) TA_GROUPS_ALL) &&
						(optn_mask & TA_MASK_g)){
					ta_st->ta_groups[0] =
						(gid_t) TA_GROUPS_ALL;
					ta_st->ta_groups[1] = (gid_t) -1;
				}
				/*
				 * deleting - Set the array to -1 if d_gid
				 * is TA_USERS_ALL (-2).
				 */
				if ((d_gid == (gid_t) TA_GROUPS_ALL) &&
						(optn_mask & TA_MASK_G) &&
					(tal->ta_groups[0] ==
						(gid_t) TA_GROUPS_ALL))
					ta_st->ta_groups[0] = (gid_t) -1;
				if ((d_gid != (gid_t) TA_GROUPS_ALL) &&
						(optn_mask & TA_MASK_G) &&
					(tal->ta_groups[0] ==
						(gid_t) TA_GROUPS_ALL)) {
					idx = 0;
					while ((grp = getgrent()) != NULL)
						if (grp->gr_gid != d_gid) {
							ta_st->ta_groups[idx] =
								grp->gr_gid;
							idx++;
						}
					ta_st->ta_groups[idx] = (gid_t) -1;
				}
			} else	{
				/*
				 * If the tty is not found then
				 * add/del to/from list.
				 */
				if (TA_MASK_u & optn_mask) {
					ta_st->ta_users[0] = uid;
					ta_st->ta_users[1] = (uid_t) -1;
				}
				if (TA_MASK_U & optn_mask) {
					ta_st->ta_users[0] = (uid_t) -1;
					ta_st->ta_users[1] = (uid_t) -1;
				}
				if (TA_MASK_g & optn_mask) {
					ta_st->ta_groups[0] = gid;
					ta_st->ta_groups[1] = (gid_t) -1;
				}
				if (TA_MASK_G & optn_mask) {
					ta_st->ta_groups[0] = (gid_t) -1;
					ta_st->ta_groups[1] = (gid_t) -1;
				}
			}
		}
		/* To list out the information in the binary files */
		if ((TA_MASK_l & optn_mask) && (TAUTH_FLAG & info_mask)) {
			if ((tal = gettanam(ta_st->ta_ttyn)) != NULL) {
				listta(tal);
				continue;
			} else {
				fprintf(stderr,"Cannot find %s in %s file.\n",
					ta_st->ta_ttyn,TTYAUTH);
				continue;
			}
		}
		if ((TAUTH_FLAG & info_mask))
			info_mask |= TAUTH_UPDATE;
		/* ignore all signals */
		for (idx = 1; idx < NSIG; idx++)
			(void)sigset(idx, SIG_IGN);
		errno = 0;		/* For correcting sigset to SIGKILL */
		if (info_mask & TAUTH_UPDATE)
			upd_tty(ta_st->ta_ttyn, ta_st, ts_st);
	}
	return (0);
}

upd_tty(tty_name, ta, ts)
char *tty_name;
ttyauth_t *ta;
ttystat_t *ts;
{
	ttyauth_t *ta_t;
	int idx;

	if ((ta_t = gettanam(tty_name)) != NULL) {
		if (optn_mask & TA_MASK_a)
			bad_arg("name already exists");
		info_mask |= FOUND;
		/* if modifying then update field */
		if (optn_mask & TA_MASK_m) {
			if (optn_mask & TA_MASK_r)
				ta_t->ta_maxtry = ta->ta_maxtry;
			if (optn_mask & TA_MASK_D)
				ta_t->ta_delay = ta->ta_delay;
			if (optn_mask & TA_MASK_k)
				ta_t->ta_sak = ta->ta_sak;
			if (optn_mask & TA_MASK_i)
				ta_t->ta_inactive = ta->ta_inactive;
			if (optn_mask & TA_MASK_s)
				ta_t->ta_status = ta->ta_status;
			if (ta->ta_minlabel.level <= ta->ta_maxlabel.level) {
				if (optn_mask & TA_MASK_b)
					ta_t->ta_minlabel.level =
						ta->ta_minlabel.level;
				if (optn_mask & TA_MASK_B)
					ta_t->ta_maxlabel.level =
						ta->ta_maxlabel.level;
			} else
				fprintf(stderr,
				"Min level > Max level - field not updated\n");
			if ((optn_mask & TA_MASK_u) || (optn_mask & TA_MASK_U))
				for (idx = 0; idx < MAXUG; idx++)
					ta_t->ta_users[idx] =
						ta->ta_users[idx];
				/*
						(ta->ta_users[idx] ==
						(uid_t) -1); idx++)
				*/
			if ((optn_mask & TA_MASK_g) || (optn_mask & TA_MASK_G))
				/*
					(ta->ta_groups[idx] == (gid_t) -1);
					idx++)
				*/
				for (idx = 0; idx < MAXUG; idx++)
					ta_t->ta_groups[idx] =
						ta->ta_groups[idx];
			if ((updatetaent(ta_t, ts, JUST_TA) < 0))
				bad_arg("Cannot update /etc/security/dev_auth");
		}
	}
	/* Cannot find the target entry and we are modifying */
	if (!(info_mask & FOUND) && (optn_mask & TA_MASK_m))
		bad_arg("tty does not exist");
	/* Deleting (retire) the tty */
	if (optn_mask & TA_MASK_d) {
		if ((ta = gettanam(tty_name)) != NULL) {
 			ta->ta_status = RETIRE;
			if ((updatetaent(ta, ts, JUST_TA) < 0))
				bad_arg("Cannot update /etc/security/dev_auth");
		} else
			fprintf(stderr,"Cannot find %s in %s cannot RETIRE\n",
				tty_name,TTYAUTH);
	}
	/* Write out the added entry now */
	if (optn_mask & TA_MASK_a) {
		if ((updatetaent(ta,ts,DO_BOTH) < 0))
			bad_arg("Cannot update /etc/security/dev_auth");
	}
	return (0);
}

dev_bad_usage(sp)
char *sp;
{
if (strlen(sp) != 0)
	fprintf(stderr,"%s: %s\n", prognamp, sp);
fprintf(stderr,"Usage:\n");

fprintf(stderr,
"%s -a [-r max # of bad logins] [-D delay between logins] [-k sak keys]\n",
	prognamp);
fprintf(stderr,
"\t[-i max time of inactivity (secs)] [-s dev status] [-b min label]\n");
fprintf(stderr,
"\t[-B max label] [-U del users (uid)] [-G del groups (gid)]\n");
fprintf(stderr,
"\t[-u add users (uid)] [-g add groups (gid)] device(s)\n");

fprintf(stderr,"%s -a -f profile device(s)\n", prognamp);
fprintf(stderr,
"\t'profile' is a full pathname or name of profile in '%s'\n",
	PROFILE_PATH);
fprintf(stderr,"%s -a -F device(s)\n", prognamp);
fprintf(stderr,
"\tuses '%s/\"device\"' as default profile for that device\n",
	PROFILE_PATH);
fprintf(stderr,"%s -a -I device(s)\n", prognamp);
fprintf(stderr,
"\tuses '%s/%s' as default profile for each device\n",
	PROFILE_PATH,DEF_PROFILE);

fprintf(stderr,
"%s -m [-r max # of bad logins] [-D delay between logins] [-k sak keys]\n",
	prognamp);
fprintf(stderr,
"\t[-i max time of inactivity (secs)] [-s dev status] [-b min label]\n");
fprintf(stderr,
"\t[-B max label] [-U del users (uid)] [-G del groups (gid)]\n");
fprintf(stderr,
"\t[-u add users (uid)] [-g add groups (gid)] device(s)\n");

fprintf(stderr,"%s -m -f profile device(s)\n", prognamp);
fprintf(stderr,
"\t'profile' is a full pathname or name of profile in '%s'\n",
	PROFILE_PATH);
fprintf(stderr,"%s -m -F device(s)\n", prognamp);
fprintf(stderr,
"\tuses '%s/\"device\"' as default profile for that device\n",
	PROFILE_PATH);
fprintf(stderr,"%s -m -I device(s)\n", prognamp);
fprintf(stderr,
"\tuses '%s/%s' as default profile for each device\n",
	PROFILE_PATH,DEF_PROFILE);

fprintf(stderr,"%s -d device(s)\n",prognamp);
fprintf(stderr,"%s -l device(s)\n",prognamp);
	exit (1);
}
