/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) openlp.c: version 25.1 created on 12/2/91 at 16:43:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)openlp.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/* 
 * openlp is needed for line printers attached to a serial connection on
 * an ARIX S90.  Starting from Arix release 3.3, the streams module "ldterm"
 * is automaticly pushed.  For a printer, we need to pop this module,
 * push "lpmod", and then hold the line open forever.  This is an ARIX 
 * original.
 */


#include <stdio.h>
#include <fcntl.h>
#include <termio.h>
#include <signal.h>
#include <sys/stropts.h>
#include <limits.h>
#include <errno.h>
#include <string.h>

struct termio term = {	
	IGNBRK | IXON,                   /* iflags */
	OPOST | ONLRET | TAB3,           /* oflags */
	B9600 | CS8 | CREAD | CLOCAL,    /* cflags */
	0, 		                       /* lflags */
	0, 		                       /* line */
	0, 0, 0, 0, 1, 0, 0, 0	        /* cc's */
};


#define DEV_DIR "/dev/"


int parse_baud();
void streams_stuff();
void usage();



/*
 *  
 */
main(argc,argv)
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind;
	char device[PATH_MAX];
	int fd;

	if ( argc != 3 )    
		usage();

	if ( *argv[1] != '/' ) {
		strcpy( device, DEV_DIR );       /* relative path name */
		strncat( device, argv[1], PATH_MAX - (strlen(device)) );
	} 
	else
		strncpy( device, argv[1], PATH_MAX );  /* full path name */
	

	term.c_cflag &= ~CBAUD;
	term.c_cflag |= parse_baud( argv[2] );
	

	/* Let the parent go */
	if (fork())
		return (0);

	if (( fd = open(device, O_RDWR )) == -1 ){
		perror("openlp: open failed:");
		exit(1);
	}
		

	signal(SIGINT, SIG_IGN);
	signal(SIGHUP, SIG_IGN);

	/* pop all the modules, push lpmod, and do a TCSETA. */
	streams_stuff(fd);

	/* hold the line open */
	while (1)
		pause();

	/* NOTREACHED */    /* not really true, but it shuts lint up */
}






/*
 *  parse_baud  -- turn the command line string into something the 
 *                 "struct termio"  can use.
 */
parse_baud(string)
char *string;
{
	int baud;

	switch (atoi(string)) {
	case 38400: 
		baud = EXTB; 
		break;
	case 19200: 
		baud = EXTA; 
		break;
	case 9600: 
		baud = B9600; 
		break;
	case 2400: 
		baud = B2400; 
		break;
	case 1200: 
		baud = B1200; 
		break;
	case 300: 
		baud = B300; 
		break;
	case 110: 
		baud = B110; 
		break;
	case 75: 
		baud = B75; 
		break;
	case 50: 
		baud = B50; 
		break;
	default: 
		usage();        
		/* NOTREACHED */
	}

	return(baud);
}






/*
 *  streams_stuff  --  pop all of the moduals off the stream, then push
 *                 the "lpmod" module, then set the terminal settings.
 */
void
streams_stuff(fd)
int fd;
{
	char mod[NAME_MAX];

	while ( ! ioctl( fd, I_LOOK, mod )) {
		if ( ! strncmp( "lpmod", mod, NAME_MAX )) 
			break;
		if ( ioctl( fd, I_POP ) == -1) {
			perror("openlp:I_POP failed:");
			exit(1);
		}
	}

	if ( errno != EINVAL ) {      /* if error other than no more mods */
		perror("openlp:");
		exit(1);
	}
	
	/* Push the ever popular lpmod */
	if ( ioctl( fd, I_PUSH, "lpmod" ) == -1){
		perror("openlp:");
		exit(1);
	}


	/* set the default terminal settings this is done after the pushes */
	term.c_iflag = 0;
	if ( ioctl( fd, TCSETA, &term ) < 0 ) {
		perror("openlp: ioctl failed:");
		exit(1);
	}

}





/*
 *  usage -- 
 */
void
usage()
{
	fprintf(stderr,"usage: openlp [/dev/]tty?? baud_rate \n");
	exit(1);
}

