#	START NEW ARIX SCCS HEADER
#
#	@(#) nawk.mk: version 25.1 created on 12/2/91 at 16:41:49
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)nawk.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	AT&T: #ident	"awk:awk.mk	2.6"			

#ident	"@(#)awk:nawk.mk	25.1"

include $(IROOT)/macdefs
RDIR = $(SROOT)/usr/src/cmd/nawk
INSDIR = $(ROOT)/usr/bin
YACCRM=-rm
TESTDIR = .
FRC =
YFLAGS=-d
#	AT&T: LIBS=	-lc_s -lm -ll
LIBS=	-lm -ll
REL = current
LIST = lp
FILES=	awk.g.o       awk.lx.o b.o lib.o main.o parse.o \
	proctab.o run.o tran.o
SOURCE=	awk.g.y awk.h awk.lx.l b.c lib.c main.c parse.c \
	proctab.c run.c tran.c

all:  nawk

nawk:	$(FILES)
	$(CC) $(CFLAGS) $(FILES)  $(LIBS) -o  $(TESTDIR)/nawk $(LDFLAGS) 

$(FILES):	awk.h prevy.tab.h $(FRC)

awk.g.o:	awk.h awk.g.c

y.tab.h awk.g.c:	awk.g.y
		$(YACC) $(YFLAGS) awk.g.y
		mv y.tab.c awk.g.c

prevy.tab.h:	y.tab.h
	-cmp -s y.tab.h prevy.tab.h || (cp y.tab.h prevy.tab.h; echo change maketab)

proctab.c:	maketab
	./maketab >proctab.c

maketab:	prevy.tab.h maketab.c
	/bin/cc maketab.c -o maketab

# dux#1: There are no LOCALINCS here, and the empty -I gives cc problems.
#	/bin/cc maketab.c -I$(LOCALINCS) -o maketab

src:	$(SOURCE) test.a awk.mk
	cp $? $(RDIR)
	touch src

get:
	for i in $(SOURCE) awk.mk; do cp $(RDIR)/$$i .; done

bin:
	cp a.out $(ROOT)/awk
	strip $(ROOT)/awk

profile:	$(FILES) mon.o
	$(CC) $(CFLAGS) -p -i $(FILES) mon.o $(LIBS)

find:
	egrep -n "$(PAT)" *.[ylhc] awk.def

list:
	-pr WISH $(SOURCE) awk.mk

lint:
	lint -pu b.c main.c tran.c run.c lib.c parse.c -lm |\
		egrep -v '^(error|free|malloc)'

diffs:
	-for i in $(SOURCE); do echo $$i:; diff $$i $(RDIR) | ind; done

lcomp:
	-rm -f  [b-z]*.o
	lcomp b.c main.c tran.c run.c lib.c parse.c proctab.c *.o $(LIBS)

FRC:

install:  nawk
	$(INS) nawk $(INSDIR)/nawk
	chmod 755 $(INSDIR)/nawk
	chgrp bin $(INSDIR)/nawk
	chown bin $(INSDIR)/nawk

build:	bldmk
	get -p -r`gsid awk $(REL)` s.awk.src $(REWIRE) | ntar -d $(RDIR) -g
	cd $(RDIR) ; $(YACC) $(YFLAGS) awk.g.y
	cd $(RDIR) ; mv y.tab.c  awk.g.c ; rm -f y.tab.h

bldmk:
	get -p -r`gsid awk.km $(REL) s.awk.mk >$(RDIR)/awk.mk

listing:
	pr awk.mk $(SOURCE) | $(LIST)

clean:
	rm -f a.out *.o t.* y.tab.* \
	./maketab proctab.c yacc.*

clobber:	clean
	-rm -f awk.g.c prevy.tab.*
	-rm  -f  $(TESTDIR)/nawk

