#	START NEW ARIX SCCS HEADER
#
#	@(#) mv.mk: version 25.1 created on 12/2/91 at 16:40:38
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mv.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"mv:mv.mk	1.16"

#ident	"@(#)mv:mv.mk	25.1"
#	Makefile for mv/cp/ln

include	$(IROOT)/macdefs

DIR = $(ROOT)/bin
ETCDIR = $(ROOT)/etc
LIBDIR = $(ROOT)/usr/lib

INC = $(ROOT)/usr/include

SIZE = size

LIST = lp

MAKEFILE = mv.mk

MAINS = mv cp ln
LIBMAIN = mv_dir

OBJECTS =  mv.o mv_dir.o

SOURCES =  mv.c mv_dir.c

ALL:		$(MAINS) $(LIBMAIN) mvdir

all : ALL

install: ALL
	$(INS) mv $(DIR)/mv
	chmod 755 $(DIR)/mv
	chown bin $(DIR)/mv
	chgrp bin $(DIR)/mv
	rm -f $(DIR)/ln
	/bin/ln $(DIR)/mv $(DIR)/ln
	rm -f $(DIR)/cp
	/bin/ln $(DIR)/mv $(DIR)/cp
	$(INS) mvdir $(ETCDIR)/mvdir
	chmod 744 $(ETCDIR)/mvdir
	chown root $(ETCDIR)/mvdir
	chgrp sys $(ETCDIR)/mvdir
	$(INS) mv_dir $(LIBDIR)/mv_dir
	chown root $(LIBDIR)/mv_dir
	chgrp sys $(LIBDIR)/mv_dir
	chmod 4755 $(LIBDIR)/mv_dir

compile: mv.o
	$(CC) $(CFLAGS)  -o mv  mv.o   $(LDFLAGS)

cp:		compile
		/bin/ln mv cp

ln:		compile
		/bin/ln mv ln

mv:		compile 

mv_dir:		mv_dir.o 
	$(CC) $(CFLAGS)  -o mv_dir  mv_dir.o   $(LDFLAGS) 

mvdir:		mvdir.sh
	/bin/cp mvdir.sh mvdir


mv.o:		 $(INCRT)/stdio.h $(INCRT)/sys/types.h \
		 $(INCRT)/sys/stat.h $(INCRT)/errno.h \
		 $(INCRT)/sys/errno.h 

mv_dir.o:	 $(INCRT)/signal.h $(INCRT)/sys/signal.h \
		 $(INCRT)/stdio.h $(INCRT)/sys/types.h \
		 $(INCRT)/sys/stat.h $(INCRT)/errno.h \
		 $(INCRT)/sys/errno.h 

GLOBALINCS = $(INCRT)/errno.h $(INCRT)/signal.h $(INCRT)/stdio.h \
	$(INCRT)/sys/errno.h $(INCRT)/sys/signal.h \
	$(INCRT)/sys/stat.h $(INCRT)/sys/types.h 


clean:
	rm -f $(OBJECTS)

clobber: clean
	rm -f $(MAINS) $(LIBMAIN) mvdir greplist tags



size: ALL
	$(SIZE) ln $(LIBMAIN)

strip: ALL
	$(STRIP) ln $(LIBMAIN)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort
	@echo $(LIBDIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS) |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'
	@echo $(LIBMAIN)  |  tr ' ' '\012'  | \
	sed 's;^;$(LIBDIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS) $(LIBMAIN)

listing:
	pr mv.mk $(SOURCE) | $(LIST)

listmk: 
	pr mv.mk | $(LIST)

ctags:
	@-if [ "$(SOURCE)" = "" ] ;\
	then 					\
	echo " usage: $(MAKE) -$(MAKEFLAGS)f b.mk ctags SOURCE=utility_name" ;\
	else				\
	ctags	$(SOURCE)	;\
	echo 'grep $$* \\' > greplist 	;\
	for i in $(SOURCE)  /dev/null	;\
	do 				\
	echo "$$i \\" >> greplist	;\
	done 				;\
	echo /dev/null >> greplist	;\
	chmod +x greplist		;\
	fi


