/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mkfs.c: version 25.1 created on 12/2/91 at 16:39:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mkfs.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	mkfs	COMPILE:	cc -O mkfs.c -s -i -o mkfs
 * Make a file system prototype.
 * NORMAL:
 * usage: mkfs [-b<bsize>] filsys blocks [i-inodes] [gap blocks/cyl]
 *        mkfs [-b<bsize>] filsys proto [gap blocks/cyl]
 */
 /*
  * Tue Sep 25 10:06:39 PDT 1984
  * change the STEPSIZE from 3 to 6 to prepare for the new
  * faster disk controller
  *
  * Dec 1984
  * add support for new logical disk format including bad block skipping.
  * size is now optional and when specified is checked
  * against the logical disk size.
  *
  * sw1 10/14/86  kld  Add temporary pointer so free will not attempt to free
  *                    memory in the middle of a block.
  *
  * sw2 hanna Wed Dec 31 13:11:06 PST 1986
  * 		Change STEPSIZE from 6 to 4 per mike marriock.
  *
  * sw3 4/25/88   shen modified for s3000 products
  *
  * hh  5/17/88   hans - added support for -D defining block size 
  *		  (FSBSIZ) and superblock s_type field (S_TYPE) at compile time.
  *		  Also cleaned up trash and rearranged a bit.  Quite s3000 
  *		  specific at this point. Removed RT ifdefs (it's midnight, 
  *		  and they're pissing me off). Replaced much V.2 carryover
  *		  code with V.3 AT&T source (all routines except main).
  *
  * sg  8/31/88   added -b option for specifying block size of file system.
  * hh  1/13/89   added checks for mounted file system and swap device.
  * mu  5/22/89   do ioctl's only for char special devices and not for proto
  *		  files, proto file processing is still not working.
  *
  * JOE 10/25/90 - removed visible traces of u option.
  */


#include <stdio.h>
#include <a.out.h>
#include <errno.h>

#include <signal.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "sys/inode.h"
#include <sys/ino.h>
#include <sys/fs/s5filsys.h>
#include <sys/fblk.h>
#include <sys/fs/s5dir.h>
#include <sys/stat.h>
#include <ustat.h>

#ifdef	_POSIX_SOURCE
#include <sys/mls.h>
#endif	/* _POSIX_SOURCE */

#define LOGDRIVE 16
#include <sys/ioctl.h>
#include <sys/fs/s5inode.h>

#undef itod
#undef itoo


#ifndef S_TYPE
#define S_TYPE 0
#endif

/* i-list starts in block 1 on large-blocked file systems - hh */
/* #define ISTART	((fsbsize > 1024) ? 1 : 2)	*/
#define ISTART	((fsbsize > 1024) ? 2 : 2) /* for now, always start at 2 */


/* boot-block size */
#define BBSIZE	512
/* super-block size */
#define SBSIZE	512
#define BSIZE4K 4096

#define SECTPB (fsbsize/BSIZE)	/* physical to logical block conversion */

#define	NIDIR	(fsbsize/sizeof(daddr_t))
#define	NFB	(NIDIR+500)	/* NFB must be greater than NIDIR+LADDR */
#define	NIDIRMAX (BSIZE4K/sizeof(daddr_t))
#define	NFBMAX	(NIDIRMAX+500)	/* NFB must be greater than NIDIR+LADDR */
#define	NDIRECT	(fsbsize/sizeof(struct direct))
#define	NBINODE	(fsbsize/dinode_size)	/* Changed for multi-sized inodes, mer */
#define	LADDR	10

/* the following default values are only used if sector and gap size are  */
/* not specified AND the ioctl's to get the values fail - hh		  */
#define SMALLDISK  290000  /* more blocks than this means larger stepsize */
#define	STEPSIZE	4	/*  stepsize if total blocks < 290000 */
#define	LG_STEPSIZE	7	/*  total blocks > 290000 */
#define	CYLSIZE		126	

#define	MAXFN	1000

#define OldINODESIZE	FsINODESIZE	/* Pre-security/posix inode size.
					 */

#define ArixINODESIZE	SEC_INODESIZE	/* Default inode size for ARIX releases
				 	 * from 3.0 to present (10/25/90)  The
					 * only publicly available inode size
					 * for 3.2 on.
				 	 */
char *ascldtype[] = {
	"NULL", "FSYS", "SWAP", "PWRF",
	"HOLE", "SPARE", "SKIP", "SPLIT"
};

int	fsbsize = BSIZE;
time_t	utime;
FILE 	*fin;
int	fsi;
int	fso;
char	*charp;
char	buf[BSIZE4K];
char	superbuf[BSIZE4K];
int	dinode_size = ArixINODESIZE;		/* Default dinode size, MER */

int work0[BSIZE4K/sizeof(int)];
struct fblk *fbuf = (struct fblk *)work0;

#if u3b || u3b5 || vax || m68k || M68020
struct {
	struct filehdr filehdr;
	struct aouthdr aouthdr;
	} head;
#else
struct exec head;
#endif
char	string[50];

int work1[BSIZE4K/sizeof(int)];
struct filsys *filsys = (struct filsys *)work1;
char	*fsys;
char	*proto;
int	f_n = CYLSIZE;
int	f_m = STEPSIZE;
int	f_s;
int	error;
ino_t	ino;
long	getnum();
daddr_t	alloc();
#ifndef	S3000
char	*blkfsys, *chr2blk();	/* misha */
#endif
unsigned short	chrmode;	/* misha */

/* JTOF - any big buffer allocation should NOT be on stack 
 *        big allocations on the stack are NOT PORTABLE 
 *        Some may argue that all machine should be able to 
 *        handle big stack allocations, but in reality, this
 *        just isn't the way all systems work!       
 */

/* used by bflist() */
daddr_t ib[NFBMAX];
char flg[MAXFN];
int adr[MAXFN];

/* used by iput() */
daddr_t ib2[NIDIRMAX];	/* a double indirect block */
daddr_t ib3[NIDIRMAX];	/* a triple indirect block */

/* inumber to disk offset */
itoo(x, bsize)
int x;
int bsize;
{
	if (dinode_size == ArixINODESIZE) {

	    if (bsize == 1024)

		return((int)((x+15)&7));

	    else if (bsize == 2048)

		return((int)((x+31)&15));

	    else if (bsize == 4096)

		return((int)((x+63)&31));
	}
	else {

	    if (bsize == 1024)

		return((int)((x+31)&15));

	    else if (bsize == 2048)

		return((int)((x+63)&31));

	    else if (bsize == 4096)

		return((int)((x+127)&63));
	}
}

/* inumber to disk address */
itod(x, bsize)
int x;
int bsize;
{
	if (dinode_size == ArixINODESIZE) {

	    if (bsize == 1024)

		return((daddr_t)(((x+15)>>3)&017777));

	    else if (bsize == 2048)

		return((daddr_t)(((x+31)>>4)&037777));

	    else if (bsize == 4096)

		return((daddr_t)(((x+63)>>5)&0177777));
	}
	else {

	    if (bsize == 1024)

		return((daddr_t)(((x+31)>>4)&017777));

	    else if (bsize == 2048)

		return((daddr_t)(((x+63)>>5)&037777));

	    else if (bsize == 4096)

		return((daddr_t)(((x+127)>>6)&0177777));
	}
}

main(argc, argv)
int argc;
char *argv[];
{
	int f, c, i, ufd ;
	long n, nb;
 	char *lastslash;
	char *ptr;
 	struct stat 	chrstat;
	struct ustat	ustatarea;
#ifndef	S3000
 	struct stat 	blkstat;
#endif
	static	int	delay = 10;	/* 10 second delay before start */

	/*
	 * open relevent files
	 */
	nb=0;
	time(&utime);
	if(argc < 2) {
		printf("usage: %s [-b<bsize>] filsys proto [gap blocks/cyl]\n",
			argv[0]);
		printf("       %s [-b<bsize>] filsys [blocks[:inodes] gap blocks/cyl]\n",
			argv[0]);
		exit(1);
	}
#ifdef needbssinit
	{
		/* initialize the buffer */
		register int *outbuf = (int *)superbuf;
		register int i;
		for(i = (BSIZE/sizeof (int));i>0;i--)*outbuf++ = 0L;
	}
#endif
	/* the following checks for the blocksize argument	*/
	/* if found, it is removed from the arglist		*/
	ptr = (char *)argv[1];
	if ((*ptr++ == '-') && (*ptr++ == 'b')) {
		if ( *ptr == 'u' ){

			ptr++;
			dinode_size = OldINODESIZE;
		}

		fsbsize = atoi(ptr);
		if ((fsbsize != 1024)&&(fsbsize != 2048)&&(fsbsize != 4096)) {
			printf("%s: illegal block size %d\n",
				argv[0],fsbsize);

			printf("%s: legal block sizes are 1024 or 4096\n",
				argv[0]);

			exit(1);
		}
		for (i = 1; i < argc-1; i++)
			argv[i] = argv[i+1];
		argc -= 1;
	}
	fsys = argv[1];
	if (stat(fsys, &chrstat) < 0) {
		printf("%s: cannot stat '%s'\n",argv[0],fsys);
		exit(1);
	}
	chrmode = chrstat.st_mode;
	if ((chrmode & S_IFMT) == S_IFBLK) {
		printf("%s: '%s' must be a raw device or a regular file\n",
			argv[0],fsys);
		exit(1);
	}
	if ((chrmode & S_IFMT) == S_IFCHR) {
#ifdef	S3000
		ufd = ustat(chrstat.st_rdev, &ustatarea);
#else	/* for A1000 */
		if ((blkfsys = chr2blk(fsys)) == NULL) {
		printf("%s: can't recognise character device name '%s'\n",
				argv[0],fsys);
			exit (1);
		}
		if (stat(blkfsys, &blkstat) < 0) {
			printf("%s: cannot stat '%s'\n",argv[0],blkfsys);
			exit (1);
		}
		if ((blkstat.st_mode & S_IFMT) != S_IFBLK) {
			printf("%s: '%s' is not a block special device\n",
				argv[0],blkfsys);
			exit (1);
		}
		ufd = ustat(blkstat.st_rdev, &ustatarea);
#endif	/* S3000 */
		/*
		 * ustat() returns a  0 if stat is on a mounted file system and
		 *         returns a -1 if the device is not mounted.
		 */
		if (ufd == 0) {
			printf("%s: '%s' is a mounted file system\n",
				argv[0],fsys);
			exit(1);
		}
	}
	fsi = open(fsys, 0);
	if (fsi < 0) {
		printf("%s: cannot open '%s'\n",argv[0],fsys);
		exit(1);
	}
	if ((chrmode & S_IFMT) == S_IFCHR) {
		/*****	get file system size  -   hh *******/
		if ((f_s = ioctl(fsi,GET_DISK_SIZE,0)) == -1) {
			printf("%s: cannot get disk size for '%s'\n",
				argv[0],fsys);
			exit(1);	
		}
	}
	if (argc > 2) {
		proto = argv[2];
		fin = fopen(proto, "r");
	} else {
		proto = NULL;
		fin = NULL;
	}
	if (fin == NULL) {
		n = 0;
		for(f=0; proto!=NULL && (c=proto[f]); f++) {
			if(c<'0' || c>'9') {
				if(c == ':') {
					nb = n;
					n = 0;
					continue;
				}
				printf("%s: cannot open '%s'\n",argv[0],proto);
				exit(1);
			}
			n = n * 10 + (c-'0');
		}
		charp = "d--777 0 0 $ ";
	} else { /* proto file valid */
		getstr(); 
		f = open(string, 0);
		if(f < 0) 
			printf("%s: cannot  open init\n", string);
		else {
			if((read(f, (char *)&head, sizeof head)) == NULL){
		printf("%s: read error on init file '%s', file ignored\n",
					argv[0],string);
				c = 0;
			}
			else {
#if u3b || u3b5 || vax || m68 || m68k || M68020
				c = head.aouthdr.tsize + head.aouthdr.dsize;
#else
				c = head.a_text + head.a_data;
#endif
			}
			if(c > BBSIZE) {
				printf("\n%s: too big\n", string);
				printf("%s: textsize( %#x ) datasize( %#x ) = total( %#x )\n",string,head.aouthdr.tsize,head.aouthdr.dsize);
				printf("%s: size cannot exceed ( %#x )\n",string,BBSIZE);
				}
			else if(c != 0){
				/* read boot program into superbuf. Superbuf */
				/* gets written after superblock is copied   */
				/* into it (below). -hh		             */	
				lseek(f, 3*sizeof(struct scnhdr) +sizeof(struct aouthdr) + sizeof(struct filehdr),0L);
				read(f, superbuf, c);

			}
			close(f);
		}

		/** get total disk size and inode block size **/
		nb = getnum();
		n = getnum();
	}  /* else (proto file valid) */
	if ((chrmode & S_IFMT) == S_IFCHR) {
		if (!n)
			n = f_s;
	}
	if (!nb) { 	/* total blocks specified, but not inodes (hh)*/
		nb = n / SECTPB; 
		n = (nb * SECTPB) / (NBINODE * 4);
	} else		/* total blocks and # inodes specified  (hh) */
	{
		nb /= SECTPB;  
		n  /= NBINODE;		/* shen 5/31/89 spr #2293 */
	}
	if ((chrmode & S_IFMT) == S_IFCHR) {
		if (nb > (f_s / SECTPB)) {
		printf("requested size (%d) > logical disk (%d), (phys blks)\n",
				nb*(fsbsize/BSIZE), f_s);
			nb = f_s;
		} else
			if (nb < (f_s / SECTPB))
		printf("requested size (%d) < logical disk (%d), (phys blks)\n",
				nb*(fsbsize/BSIZE), f_s);
	}
	filsys->s_fsize = nb;
	if (n <= 0)
		n = 1;
	if (n > (65500 / NBINODE))     /* we have more than max # inodes! */
		n = 65500 / NBINODE;
	filsys->s_isize = n + ISTART;
	/* set magic number for file system type */
	filsys->s_magic = FsMAGIC;
	filsys->s_fname[0] = filsys->s_fpack[0] = '\0';
	switch (fsbsize){
		case 512 :
			filsys->s_type = Fs1b;
			break;
		case 1024 :
			filsys->s_type =
			   (dinode_size == ArixINODESIZE ? FsSEC1 : Fs2b);
			break;
		case 2048 :
			filsys->s_type = Fs4b;
			break;
		case 4096 :
			filsys->s_type =
			   (dinode_size == ArixINODESIZE ? FsSEC4 : Fs8b);
			break;
		default	:
			filsys->s_type = S_TYPE;
	}
	if (argc >= 5) {
		f_m = atoi(argv[3]);
		f_n = atoi(argv[4]);
		if(f_n <= 0 || f_n >= MAXFN)
			f_n = CYLSIZE;
		if(f_m <= 0 || f_m > f_n)
			f_m = STEPSIZE;
	} else { 
		if ((chrmode & S_IFMT) == S_IFCHR) {
			if ((f_n = ioctl(fsi,GET_CYLINDER_SIZE,0)) == -1) 
				f_n = CYLSIZE; 
			if ( (f_m = ioctl(fsi,GET_INTERLACE,0)) == -1) 
				f_m = (nb > SMALLDISK) ? LG_STEPSIZE : STEPSIZE;
		}
	}
	filsys->s_dinfo[0] = f_m;
	filsys->s_dinfo[1] = f_n;
	f_m /= (fsbsize/BSIZE);  /* convert to fsbsize blocks */
	f_n /= (fsbsize/BSIZE);
	printf("\n%s: %s ?\n",argv[0],fsys);

	if (dinode_size == ArixINODESIZE)
		printf("Creating an ARIX%.1dk file system.\n", fsbsize/BSIZE);
	else
		printf("Creating old style file system.\n");

	printf("bytes per logical block = %d\n", fsbsize);
	printf("total logical blocks = %ld\n", filsys->s_fsize);
	printf("total inodes = %ld\n", n*NBINODE);
	printf("gap (physical blocks) = %d\n", filsys->s_dinfo[0]);
	printf("cylinder size (physical blocks) = %d\n", filsys->s_dinfo[1]);
	if (filsys->s_isize >= filsys->s_fsize) {
		printf("\n%ld/%ld: bad ratio\n",
			filsys->s_fsize, filsys->s_isize-2);
		exit(1);
	}
	filsys->s_tinode = 0;
	/*********************************************************************/
	/** hh - moved Mkfs? question so that user can verify mkfs after     */
	/**      seeing the parameters.					     */
	/*********************************************************************/
	printf("(Press DEL if wrong) %2d ",delay);
	fflush(stdout);
	sleep(1);
	for (i = (delay - 1); i >= 0; i--) {
		printf("\b\b\b\b %2d ",i);
		fflush(stdout);
		sleep(1);
	}
	printf("\b\b\b\b    \n");
	printf("Making file system %s\n",fsys);
	fso = creat(fsys, 0666);
	if (fso < 0) {
		printf("%s: cannot create '%s'\n",argv[0],fsys);
		exit(1);
	}
	for (c = 0; c < fsbsize; c++)	/* initialize i-list to zeros */
		buf[c] = 0;		
	for (n = ISTART; n != filsys->s_isize; n++) {
		wtfs(n, buf);		    
		filsys->s_tinode += NBINODE;
	}
	ino = 0;
	bflist();			/* build free list */
	cfile((struct inode *)0); 	/* create files */
	filsys->s_time = utime;
	filsys->s_state= FsOKAY - filsys->s_time;
/* first copy superblock into superbuff at SUPERBOFF (512) (first 512 bytes  */
/* make up the boot-block) : then write superbuf to file system.   -  hh   */
	{
		register long *in = work1;
		register long *out = (long *)&superbuf[SUPERBOFF];
		register long i;

		for(i= ( SBSIZE/sizeof (long)) ; i>0 ; i-- )
			*out++ = *in++;
	}
	lseek(fso, 0L, 0);
	if(write(fso,superbuf,fsbsize) != fsbsize) {
		printf("%s: write error: super-block\n",argv[0]);
		exit(1);
	}
	exit(error);
}

#ifndef	S3000
char *
chr2blk(chardev)
char	*chardev;
{
static	char	blkdev[80];

	if (strncmp(chardev,"/dev/r",6))
		return (NULL);
	strcpy(blkdev,chardev);
	strcpy(blkdev+5,blkdev+6);
	return (blkdev);
}
#endif

long dbbuffer[BSIZE]; /* disk driver on s3000 requires long aligned */

cfile(par)
struct inode *par;
{
	struct inode in;
	struct s5inode s5in;
	daddr_t bn, nblk;
	int dbc, ibc;
	char *db = (char *)dbbuffer ;
	daddr_t ib[NFBMAX];
	int i, f, c;

	/*
	 * get mode, uid and gid
	 */

	getstr();
	in.i_fsptr = (int *) &s5in;
	in.i_ftype  = gmode(string[0], "-bcd", IFREG, IFBLK, IFCHR, IFDIR, 0, 0, 0);
	s5in.s5i_mode = gmode(string[1], "-u", 0, ISUID, 0, 0, 0, 0, 0);
	s5in.s5i_mode |= gmode(string[2], "-g", 0, ISGID, 0, 0, 0, 0, 0);
	for(i=3; i<6; i++) {
		c = string[i];
		if(c<'0' || c>'7') {
			printf("%c/%s: bad octal mode digit\n", c, string);
			error = 1;
			c = 0;
		}
		s5in.s5i_mode |= (c-'0')<<(15-3*i);
	}
	in.i_uid = getnum();
	in.i_gid = getnum();

	/*
	 * general initialization prior to
	 * switching on format
	 */

	ino++;
	in.i_number = ino;
	for(i=0; i<fsbsize; i++)
		db[i] = 0;
	for(i=0; i<NFB; i++)
		ib[i] = (daddr_t)0;
	in.i_nlink = 1;
	in.i_size = 0;
	for(i=0; i<NADDR; i++)
		s5in.s5i_faddr[i] = (daddr_t)0;
	if(par == (struct inode *)0) {
		par = &in;
		in.i_nlink--;
	}
	dbc = 0;
	ibc = 0;
	switch(in.i_ftype) {

	case IFREG:
		/*
		 * regular file
		 * contents is a file name
		 */

		getstr();
		f = open(string, 0);
		if(f < 0) {
			printf("%s: cannot open\n", string);
			error = 1;
			break;
		}
		while((i=read(f, db, fsbsize)) > 0) {
			in.i_size += i;
			newblk(&dbc, db, &ibc, ib);
		}
		close(f);
		break;

	case IFBLK:
	case IFCHR:
		/*
		 * special file
		 * content is maj/min types
		 */

		i = getnum() & 0377;
		f = getnum() & 0377;
		s5in.s5i_faddr[0] = (i<<8) | f;
		break;

	case IFDIR:
		/*
		 * directory
		 * put in extra links
		 * call recursively until
		 * name of "$" found
		 */

		par->i_nlink++;
		in.i_nlink++;
		entry(in.i_number, ".", &dbc, db, &ibc, ib);
		entry(par->i_number, "..", &dbc, db, &ibc, ib);
		in.i_size = 2*sizeof(struct direct);
		for(;;) {
			getstr();
			if(string[0]=='$' && string[1]=='\0')
				break;
			entry(ino+1, string, &dbc, db, &ibc, ib);
			in.i_size += sizeof(struct direct);
			cfile(&in);
		}
		break;

	}
	if(dbc != 0)
		newblk(&dbc, db, &ibc, ib);
	iput(&in, &ibc, ib);
}

gmode(c, s, m0, m1, m2, m3, m4, m5, m6)
char c, *s;
{
	int i;

	for(i=0; s[i]; i++)
		if(c == s[i])
			return((&m0)[i]);
	printf("%c/%s: bad mode\n", c, string);
	error = 1;
	return(0);
}

long 
getnum()
{
	int i, c;
	long n;

	getstr();
	n = 0;
	for(i=0; c=string[i]; i++) {
		if(c<'0' || c>'9') {
			printf("%s: bad number\n", string);
			error = 1;
			return((long)0);
		}
		n = n*10 + (c-'0');
	}
	return(n);
}

getstr()
{
	int i, c, quit = 0;

	do {
		switch(c=getch()) {
			case ' ':
			case '\t':
			case '\n':
				break;
			case '\0':
				printf("EOF\n");
				exit(1);
			case ':':
				while(getch() != '\n');
				break;
			default : 
				quit++;
		}
	} while (!quit);

	i = 0;

	do {
		string[i++] = c;
		c = getch();
	} while(c!=' '&&c!='\t'&&c!='\n'&&c!='\0');

	string[i] = '\0';
}

rdfs(bno, bf)
daddr_t bno;
char *bf;
{
	int n;

	lseek(fsi, (long)(bno*fsbsize), 0);
	n = read(fsi, bf, fsbsize);
	if(n != fsbsize) {
		printf("read error: %ld\n", bno);
		exit(1);
	}
}

wtfs(bno, bf)
daddr_t bno;
char *bf;
{
	int n;
	lseek(fso, (long)(bno*fsbsize), 0);
	n = write(fso, bf, fsbsize);
	if(n != fsbsize) {
		printf("write error: %ld\n", bno);
		exit(1);
	}
}

daddr_t 
alloc()
{
	int i;
	daddr_t bno;

	filsys->s_tfree--;
	bno = filsys->s_free[--filsys->s_nfree];
	if(bno == 0) {
		printf("out of free space\n");
		exit(1);
	}
	if(filsys->s_nfree <= 0) {
		rdfs(bno, (char *)fbuf);
		filsys->s_nfree = fbuf->df_nfree;
		for(i=0; i<NICFREE; i++)
			filsys->s_free[i] = fbuf->df_free[i];
	}
	return(bno);
}


bfree(bno)
daddr_t bno;
{
	int i;

	filsys->s_tfree++;
	if(filsys->s_nfree >= NICFREE) {
		fbuf->df_nfree = filsys->s_nfree;
		for(i=0; i<NICFREE; i++)
			fbuf->df_free[i] = filsys->s_free[i];
		wtfs(bno, (char *)fbuf);
		filsys->s_nfree = 0;
	}
	filsys->s_free[filsys->s_nfree++] = bno;
}

entry(in, str, adbc, db, aibc, ib)
ino_t in;
char *str;
int *adbc, *aibc;
char *db;
daddr_t *ib;
{
	struct direct *dp;
	int i;

	dp = (struct direct *)db;
	dp += *adbc;
	(*adbc)++;
	dp->d_ino = in;
	for(i=0; i<DIRSIZ; i++)
		dp->d_name[i] = 0;
	for(i=0; i<DIRSIZ; i++)
		if((dp->d_name[i] = str[i]) == 0)
			break;
	if(*adbc >= NDIRECT)
		newblk(adbc, db, aibc, ib);
}

newblk(adbc, db, aibc, ib)
int *adbc, *aibc;
char *db;
daddr_t *ib;
{
	int i;
	daddr_t bno;

	bno = alloc();
	wtfs(bno, db);
	for(i=0; i<fsbsize; i++)
		db[i] = 0;
	*adbc = 0;
	ib[*aibc] = bno;
	(*aibc)++;
	if(*aibc >= NFB) {
		printf("file too large\n");
		error = 1;
		*aibc = 0;
	}
}

getch()
{

	if(charp)
		return(*charp++);
	return(getc(fin));
}

bflist()
{
	struct inode in;
	struct s5inode s5in;
	int ibc;
	int i, j;
	daddr_t f, d;

/* JTOF - FIX trace message */
	for(i=0; i<f_n; i++) {
		if ( i > MAXFN ) {
			printf( "panic: overrunning array\n" );
			printf( "f_n = %x  i = %x\n", f_n, i );
			printf( "&flg = %x   &flg[i] = %x\n",
				flg, &flg[i] );
			exit( 1 );
		}
		flg[i] = 0;
	}
	i = 0;
	for(j=0; j<f_n; j++) {
		while(flg[i])
			i = (i+1)%f_n;
		adr[j] = i+1;
		flg[i]++;
		i = (i+f_m)%f_n; /* f_m and f_n here are cylsize and 	*/
	}			 /* interlace in fsbsize blocks  (hh)	*/

	ino++;
	in.i_fsptr = (int *) &s5in;
	in.i_number = ino;
	in.i_ftype = IFREG;
	in.i_uid = 0;
	in.i_gid = 0;
	in.i_nlink = 0;
	in.i_size = 0;
	s5in.s5i_mode = 0;
	for(i=0; i<NADDR; i++)
		s5in.s5i_faddr[i] = (daddr_t)0;

	for(i=0; i<NFB; i++)
		ib[i] = (daddr_t)0;
	ibc = 0;
	bfree((daddr_t)0);
	filsys->s_tfree = 0;
#if u3b2 || u3b15
	d = filsys->s_fsize;
#else
	d = filsys->s_fsize-1;
#endif
	if (fsbsize > BSIZE) d += 1;

	while(d%f_n)
		d++;
	for(; d > 0; d -= f_n)
		for(i=0; i<f_n; i++) {
			f = d - adr[i];
			if(f < filsys->s_fsize && f >= filsys->s_isize)
				if(badblk(f)) {
					if(ibc >= NIDIR) {
						printf("too many bad blocks\n");
						error = 1;
						ibc = 0;
					}
					ib[ibc] = f;
					ibc++;
				} else {
					bfree(f);
				}
		}
	iput(&in, &ibc, ib);
}

iput(ip, aibc, ib)
register struct inode *ip;
register int *aibc;
daddr_t *ib;
{
	register struct dinode *dp;
	struct s5inode *s5ip = (struct s5inode *) ip->i_fsptr;
	daddr_t d;
	register int i,j,k;
	char	*tmp_dp;
	int	f_s_type;

	filsys->s_tinode--;
	d = itod(ip->i_number,fsbsize);
	if(d >= filsys->s_isize) {
		if(error == 0)
			printf("ilist too small\n");
		error = 1;
		return;
	}
	rdfs(d, buf);
	tmp_dp = buf + itoo(ip->i_number,fsbsize) * dinode_size;
	dp = (struct dinode *)tmp_dp;

	dp->di_mode = (ip->i_ftype | s5ip->s5i_mode) ;
	dp->di_nlink = ip->i_nlink;
	dp->di_uid = ip->i_uid;
	dp->di_gid = ip->i_gid;
	dp->di_size = ip->i_size;
	dp->di_atime = utime;
	dp->di_mtime = utime;
	dp->di_ctime = utime;

#ifdef 	_POSIX_SOURCE
		dp->di_priv = 0;
#ifdef	SECURITY
		memset ( &(dp->di_label), 0, sizeof(struct slabel));
#else	/* SECURITY */
		memset ( &dp->di_lpad[0], 0, 18);
#endif	/* SECURITY */
		dp->di_acl_inode_type = 0;
		dp->di_acl_inode = 0;
		dp->di_default_acl_inode = 0;
#endif	/* _POSIX_SOURCE */

	switch(ip->i_ftype) {

	case IFDIR:
	case IFREG:
		/* handle direct pointers */
		for(i=0; i<*aibc && i<LADDR; i++) {
			s5ip->s5i_faddr[i] = ib[i];
			ib[i] = 0;
		}
		/* handle single indirect block */
		if(i < *aibc)
		{
			for(j=0; i<*aibc && j<NIDIR; j++, i++)
				ib[j] = ib[i];
			for(; j<NIDIR; j++)
				ib[j] = 0;
			s5ip->s5i_faddr[LADDR] = alloc();
			wtfs(s5ip->s5i_faddr[LADDR], (char *)ib);
		}
		/* handle double indirect block */
		if(i < *aibc)
		{
			for(k=0; k<NIDIR && i<*aibc; k++)
			{
				for(j=0; i<*aibc && j<NIDIR; j++, i++)
					ib[j] = ib[i];
				for(; j<NIDIR; j++)
					ib[j] = 0;
				ib2[k] = alloc();
				wtfs(ib2[k], (char *)ib);
			}
			for(; k<NIDIR; k++)
				ib2[k] = 0;
			s5ip->s5i_faddr[LADDR+1] = alloc();
			wtfs(s5ip->s5i_faddr[LADDR+1], (char *)ib2);
		}
		/* handle triple indirect block */
		if(i < *aibc)
		{
			printf("triple indirect blocks not handled\n");
		}
		break;

	case IFBLK:
		break;

	case IFCHR:
		break;

	default:
		printf("bad ftype %o\n", ip->i_ftype);
		exit(1);
	}

	ltol3(dp->di_addr, s5ip->s5i_faddr, NADDR);
	wtfs(d, buf);
}

badblk(bno)
daddr_t bno;
{

	return(0);
}
