/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mkdir.c: version 25.1 created on 12/2/91 at 16:39:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mkdir.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"mkdir:mkdir.c	1.7"			*/

/* hh1 - April 25, 1985 (hans) - fixed exit value to be zero 	*/
/*				if there are no errors (was 2)	*/

#ident	"@(#)mkdir:mkdir.c	23.1"

/*
** make directory.
** If -m is used with a valid mode, directories will be
** created in that mode.  Otherwise, the default mode will
** be 777 possibly altered by the process's file mode creation
** mask.
** If -p is used, make the directory as well as
** its non-existing parent directories.
*/

#include	<signal.h>
#include	<stdio.h>
#include	<errno.h>
#include	<string.h>

extern int opterr, optind,  errno;
extern char *optarg,  *sys_errlist[];
char  *ms;

char *strrchr();

extern newmode();


main(argc, argv)
char *argv[];
int argc;
{
	int i, c, pflag, errflg, mflag, om = 0777;
	char *d, *p, *endptr,  *ptr;
 	char dfault[] = "0777";

	pflag = 0;
	mflag = 0;
	errflg = 0;
	ms = dfault;

	while ((c=getopt(argc, argv, "m:p")) != EOF)
		switch (c) {
			case 'm':
				mflag++;
				ms = optarg;
				umask (0);
				break;
			case 'p':
				pflag++;
				break;
			case '?':
				errflg++;
				break;
		}
	if(argc < 2 || errflg) {
		fprintf(stderr, "mkdir: usage: mkdir [-m mode] [-p] dirname ...\n");
		exit(2);
	}
	argc -= optind;
	argv = &argv[optind];
	errflg = 0;	/* hh1 - use errflg to exit with correct value */
        while(argc--) {
		d = *argv++;

			/* Skip extra slashes at the end of path */

		while ((endptr=strrchr(d, '/')) != NULL){
			p=endptr;
			p++;
			if (*p == '\0')
				*endptr='\0';
			else
				break;
		}

			/* When -p is set */
		if (pflag){ 
			if (mkdirp(d,ms) <0) {
				fprintf(stderr, "mkdir: \"%s\": %s\n",d,sys_errlist[errno]);
				errflg++;
				continue;
			}
			continue;
		 }
			/* No -p. Make only one directory */

				/* Check write permission of parent*/

					/* Parent is current directory */

		if ((ptr=strrchr(d,'/')) == NULL)
			if (access(".",02)) {
				fprintf(stderr, "mkdir: \"%s\": %s\n",d,sys_errlist[errno]);
				errflg++;
				continue;
			} else;
		else {
					/* Parent is / */
			if (ptr == d) {
				if (access("/",02)) {
					fprintf(stderr, "mkdir: \"%s\": %s\n",d,sys_errlist[errno]);
					errflg++;
					continue;
				} else;
					/* Parent is not / */
			} else {
				*ptr = '\0';
				if (access(d,02)) {
					*ptr='/';
					fprintf(stderr, "mkdir: \"%s\": %s\n",d,sys_errlist[errno]);
					errflg++;
					continue;
				}
				*ptr='/';
			}
		}
				/* Set id to real uid and gid */
 
		if (setuid(getuid()) || setgid(getgid())) {
			fprintf(stderr, "mkdir:  Failed to set effective user/group ids to real user/group ids");
			errflg++;
			continue;
		}
				/* Make the directory */

		if ((mkdir(d, newmode(om, d, ms))) < 0) {
                   	fprintf(stderr, "mkdir:  Failed to make directory \"%s\"; %s\n", d, sys_errlist[errno]);  
			errflg++;
			continue;
		}
	}
}
