#	START NEW ARIX SCCS HEADER
#
#	@(#) mkboot.mk: version 25.1 created on 12/2/91 at 16:38:47
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mkboot.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT: ident	"mkboot-3b2:mkboot.mk	1.6"

#ident	"@(#)cmd/mkboot:mkboot.mk	25.1"

IROOT =
include $(IROOT)/macdefs

# INC = $(ROOT)/usr/include
SOURCES = $(INC)/sys/boothdr.h mkboot.h xmkboot.l mkboot.y main.c util.c
OBJECTS = mkboot.o main.o util.o
LEXLIB = -ll

mkboot:	$(OBJECTS)
	$(CC) $(CFLAGS) $(OBJECTS) $(LEXLIB) -o mkboot

all:
#	mkboot
	echo mkboot: NOT SUPPORTED

install: all
#	install -f $(ROOT)/etc mkboot

main.o:	mkboot.h $(INCRT)/sys/boothdr.h
util.o:	mkboot.h $(INCRT)/sys/boothdr.h
mkboot.o:lex.yy.c mkboot.h $(INCRT)/sys/boothdr.h

lex.yy.c: xmkboot.l
	$(LEX) xmkboot.l


clobber:clean
	rm -f mkboot

clean:
	rm -f lex.yy.c *.o tags cscope.out

print:	mkboot.mk $(SOURCES)
	$(PR) $?
	touch print

.PRECIOUS: print

lint:	main.c util.c mkboot.y lex.yy.c
	$(YACC) mkboot.y
	lint -b $(CFLAGS) main.c util.c y.tab.c
	rm -f y.tab.c

tags:	$(SOURCES)
	ctags $(SOURCES)

cscope.out:$(SOURCES)
	@-if [ "$(RUN)" ]; \
	then \
		cscope -I$(INC) $(SOURCES) \
	else \
		cscope -I$(INC) $(SOURCES) </dev/null \
	fi
