#	START NEW ARIX SCCS HEADER
#
#	@(#) mfsck_run.sh: version 25.1 created on 12/2/91 at 16:38:13
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mfsck_run.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
# MFSCK_RUN SCRIPT FOR RUNNING FSCK ON SLICES CHOSEN BY MFSCK
# v1.2
# Per Sjoberg 04/29/91

SLICEFILE=$1

for SLICE in `cat $SLICEFILE`
do
   MSG=`fsstat $SLICE 2>&1`		# check file system status
   if [ $? -eq 1 ]
   then					# if file system status not OK;
      RSLICE=`basename ${SLICE}`	# create the "raw" special file
      if [ -c /dev/rdsk/${RSLICE} ]	# name for the partition
      then
	 RSLICE=/dev/rdsk/${RSLICE}
      elif [ -c /dev/r${RSLICE} ]
      then
	 RSLICE=/dev/r${RSLICE}
      else
	 RSLICE=${SLICE}
      fi
      echo "${MSG}; ${RSLICE} is being checked:"

      COUNT=0
      STAT=1
      while [ $STAT -ne 0 ]		# run fsck on the slice
      do				# until STAT=0 or COUNT=4
	 fsck -y -D $RSLICE
	 STAT=$?
	 COUNT=`expr $COUNT + 1`
	 if [ $COUNT -gt 4 ]
	 then
	    echo "FSCK error on $SLICE; fix!" >> /tmp/mfsck_errors
	    continue 2			# exit out for this slice
	 fi
	 if [ $STAT -ne 0 ]
	 then
	    MSG="Rechecking File System on $SLICE due to FSCK Errors!"
	    echo $MSG >> /dev/console
	 fi
      done
   else
      echo $MSG				# log why we didn't check this
   fi					# file system
   MSG="File System on $SLICE OK!"
   echo $MSG >> /dev/console
done

rm $SLICEFILE				# done, clean up!
