#	START NEW ARIX SCCS HEADER
#
#	@(#) mfsck.sh: version 25.1 created on 12/2/91 at 16:38:10
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mfsck.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
# MFSCK SCRIPT FOR ARIX S90/X5
# v1.2
# Per Sjoberg 04/29/91

(alias) >/dev/null 2>&1 || exec ksh $0 $*	# execute in ksh if not
						# already doing so
USR=

while read line			# check /etc/fstab for /usr device name
do case "$line" in
	\#*)	;;
	"")	;;
	*)	set $line
		dev=$1 ; fs=$2
		if [ "$fs" = "/usr" ]
		then USR=$dev
		fi
		;;
   esac
done < /etc/fstab 

fsstat $USR > /dev/null 2>&1	# check the current /usr slice
case "$?" in
   0)	mount /usr		# file system /usr OK - just mount it
	;;
   1)	fsck -y -D $USR
	mount /usr		# check and mount /usr to make
	;;			# /usr/bin commands available
   2)	echo "/usr already mounted"
	;;
   *)	echo "PANIC!! Don't know how to mount /usr"
	exit 1
	;;
esac

if [ -d /tmp/mfsck ]		# make sure there is a cleared
then				# /tmp/mfsck directory to
   rm -rf /tmp/mfsck		# work in
fi
mkdir /tmp/mfsck
cd /tmp/mfsck

echo "\n****************** MFSCK Started! ******************\n"

# The following part picks the currently used partitions for each controller
# from /etc/fstab and groups them together drivewise, i.e. one file of
# partition names for each drive on the system.

NOS=0
for i in `awk '$1 ~ /dev/ { print $1 }' /etc/fstab | cut -c11 | sort | uniq`
do 
   for j in `awk '$1 ~ /c'$i'/ { print $1 }' /etc/fstab | cut -c13 | sort              | uniq`
   do 
      awk '$1 ~ /c'$i'd'$j'/ { print $1 }' /etc/fstab | sort > s$i$j
   done
done

NOS=`cat /tmp/mfsck/s* | wc -w`	# check the number of slices
echo $NOS "file systems to check..."

for MSGFILE in /tmp/mfsck/.msg*	# remove old message files
do
   if [ -r $MSGFILE ]
   then
      rm -f $MSGFILE
   fi
done

for SFILE in `/bin/ls`		# run the parallel fsck's
do
   nohup /etc/mfsck_run $SFILE > /tmp/mfsck/.msg$SFILE 2>&1 &
done

NOF=99
while [ NOF -gt 0 ]		# wait until all fsck's are done,
do				# i.e. until all slice files are
   sleep 10			# removed
   NOF=`/bin/ls | wc -l`	# (count how many files running)
done

if [ -r /tmp/mfsck_errors ]	# show error messages if any
then
   echo "\n****************************************************\n"
   cat /tmp/mfsck_errors
   rm -f /tmp/mfsck_errors
fi

umount /usr			# unmount the /usr file system
echo "\n****************************************************\n"
echo "MFSCK Messages are stored in /tmp/mfsck/.msgs*!"
echo "\n***************** MFSCK Completed! *****************\n"
