/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) readspec.c: version 25.1 created on 12/2/91 at 16:37:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)readspec.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <limits.h>
#include <sys/stat.h>

#define NAME_LEN	9
#define MODE_LEN	10+1	/* length of the mode string + 1 for the */
				/*   terminating null (0) */

#define MAX_LINE	256	/* maximum length of input line */
				/* maximum uid number (0 based) */
#define MAX_OWNER	(sizeof(Ownerlist)/(sizeof(Ownerlist[0].name)+sizeof(Ownerlist[0].number)))
				/* maximum gid number (0 based) */
#define MAX_GROUP	(sizeof(Grouplist)/(sizeof(Grouplist[0].name)+sizeof(Grouplist[0].number)))


struct List {
	char name[NAME_LEN];
	int number;
};

struct List Grouplist[] = {	/* from usr/src/cmd/adm/group */
	"root",    0,
	"other",   1,
	"bin",     2,
	"sys",     3,
	"adm",     4,
	"mail",    6,
	"rje",     8,
	"daemon", 12
};

struct List Ownerlist[] = {	/* from usr/src/cmd/adm/mach/passwd */
	"root",     0,
	"daemon",   1,
	"bin",      2,
	"sys",      3,
	"adm",      4,
	"uucp",     5,
	"nuucp",    6,
	"lp",      71,
	"listen",  81
};

extern struct specification {	
	ushort	new_mode,
		new_uid,
		new_gid;
	time_t	new_time;
	char	old_name[PATH_MAX],
		new_name[PATH_MAX];
	short	n_links;
} Spec;


inputusage()
{
	printf("input must be of the form <old name><new name><owner><group><mode><option1><option2>\n");
	exit(1);
} 

getname()	/* the specification is a null-terminated string */
{	/* load a global specification structure */

#define MINARG	5	/* minimum number of items for "scan" */
#define MAXARG	7	/* maximum number of items for "scan" */
#define MAXOPT	(MAXARG - MINARG)	/* maximum number of options allowed */
#define OPTLEN	5	/* number of characters for option + termination null */
			/* maximum number of links currently is LINKS=1000 */
#define EXTRA 5		/* extra space in the array to gracefully catch */
			/* strings which are too long */

	char owner_name[NAME_LEN];
	char group_name[NAME_LEN];
	char mode_string[MODE_LEN];
	int i,ok;
	int num_arg;
	char option[MAXOPT][OPTLEN + EXTRA];	/* 0 based array */
	char *str[MAX_LINE];	/* get an input line */


	for (i=0; i<MAXOPT; i++)	/* start out with illegal value */
		option[i][0]=-1;

	/* if options are not set on sscanf, they will be unchanged on */
	/* return from sscanf */
		
	if(gets(str) == NULL)
		return(0);

	num_arg=sscanf(str,"%s %s %s %s %s %s %s %s",Spec.old_name, Spec.new_name, owner_name, group_name,mode_string,option[0],option[1]); 

	if ((num_arg == 0) || (num_arg == EOF))
		return(0);	/* we're done, but no error */

	if ((num_arg < MINARG) ||  (num_arg > MAXARG) )
		(void) inputusage(str);



		/* map owner name to a number */

	if (strlen(owner_name) > (NAME_LEN-1)) {  /* don't count terminating */
						/* null here */
		fprintf(stderr,"Error:  The maximum length of a owner name is %d characters.\n",NAME_LEN);
		printf("%s\n",str);
		return(-2);
	}
	ok=0;
	for (i=0; i<MAX_OWNER; i++){
		if (strcmp(Ownerlist[i].name,owner_name) == 0){
			Spec.new_uid=Ownerlist[i].number;
			ok=1;
			break;
		}
	}

	if (! ok){
		fprintf(stderr,"Unknown owner: %s\n",owner_name); 
		printf("%s\n",str);
		return(-2);
	}

		/* map group name to a number */

	if (strlen(group_name) > (NAME_LEN-1)) {  /* don't count terminating */
						/* null here */
		fprintf(stderr,"Error:  The maximum length of a group name is %d characters.\n",NAME_LEN);
		printf("%s\n",str);
		return(-2);
	}

	ok=0;
	for (i=0; i<MAX_GROUP; i++){
		if (strcmp(Grouplist[i].name,group_name) == 0){
			Spec.new_gid=Grouplist[i].number;
			ok=1;
			break;
		}
	}

	if (! ok){
		fprintf(stderr,"Unknown group: %s\n",group_name); 
		printf("%s\n",str);
		return(-2);
	}


		/* translate mode string to a number */

	if ((Spec.new_mode=getmode(mode_string)) == 0)
		return(-2);	

	return(-1);	/* good status */
}

/* GETMODE:  */
/* Expected ascii string: */
/*    [d,b,c,p,-] - file type */
/*    [r,-][w,-][x,-,s,S] - owner permissions (last field "s" is set uid)*/
/*    [r,-][w,-][x,-,s,l] - group permissions (last field "s" is set group id)*/
/*    [r,-][w,-][x,-,t,T] - other (world) permissions (last field is set */
/*				sticky bit */
/* (In this case, each field must have a value, the choice is within the  */
/*  brackets).  Example:   -rwsr-xr-t */
/* note that "s or t" impiles "x" in the corresponding field */
/* note that "S, l or T" impiles NO "x" in the corresponding field */
/* This display is identical to that shown by "ls -l" */
/* getmode returns "0" if error, otherwise returns the mode. */

static
int
getmode(str)
char str[MODE_LEN];
{
	int mode=0;

#ifndef S_IRGRP	/* 5.3 stat.h defines these, 5.2 stat.h does not */
#define	S_IRGRP	00040		/* read permission: group */
#define	S_IWGRP	00020		/* write permission: group */
#define	S_IXGRP	00010		/* execute permission: group */
#define	S_IROTH	00004		/* read permission: other */
#define	S_IWOTH	00002		/* write permission: other */
#define	S_IXOTH	00001		/* execute permission: other */
#endif

	if (strlen(str) != MODE_LEN-1)	/* don't count terminating null here */
		return(0);

	switch(str[0]){
		case '-':
			mode |= S_IFREG; /* regular */
			break;
		case 'd':
		case 'c':
		case 'b':
		case 'p':
		default:
			return(0);
	}
	
	if (str[1] == 'r')	/* owner modes */
		mode |= S_IREAD;
	else if (str[1] != '-')
		return(0);

	if (str[2] == 'w')
		mode |= S_IWRITE;
	else if (str[2] != '-')
		return(0);

	switch (str[3]){
		case 'x':
			mode |= S_IEXEC;
			break;
		case 's':
			mode |= S_ISUID;
			mode |= S_IEXEC;
			break;
		case 'S':
			mode |= S_ISUID;
			break;
		case '-':
			break;	/* okay */
		default:
			return(0);
	}

	if (str[4] == 'r')	/* group modes */
		mode |= S_IRGRP;
	else if (str[4] != '-')
		return(0);

	if (str[5] == 'w')
		mode |= S_IWGRP;
	else if (str[5] != '-')
		return(0);

	switch (str[6]){
		case 'x':
			mode |= S_IXGRP;
			break;
		case 's':
			mode |= S_ISGID;
			mode |= S_IXGRP;
			break;
		case 'l':
			mode |= S_ISGID;
			break;
		case '-':
			break;
		default:
			return(0);
	}

	if (str[7] == 'r')	/* world modes */
		mode |= S_IROTH;
	else if (str[7] != '-')
		return(0);

	if (str[8] == 'w')
		mode |= S_IWOTH;
	else if (str[8] != '-')
		return(0);

	switch (str[9]){
		case 'x':
			mode |= S_IXOTH;
			break;
		case 't':
			mode |= S_IXOTH;
			mode |= S_ISVTX;
			break;
		case 'T':
			mode |= S_ISVTX;
			break;
		case '-':
			break;
		default:
			return(0);
	}

	return(mode);
}
	
