/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) maketcb.c: version 25.1 created on 12/2/91 at 16:37:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)maketcb.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>

#define MAGIC 0x7777654

struct	stat	Statb;
char name[256];
char *TCB_FILE = "root_tcblist";

struct TCB{
	char name[256];
	struct stat tcb_stat;
	unsigned int tcb_cksum;
}TCB_info;

struct specification {	
	ushort	new_mode,
		new_uid,
		new_gid;
	time_t	new_time;
	char	old_name[PATH_MAX],
		new_name[PATH_MAX];
	short	n_links;
} Spec;

struct TCB *tcbptr;
struct TCB stat1;


main(argc,argv)
char **argv;
{

	int i;
	register j;
	register FILE *f,*ftcb;
	int verbose = 0;
	int userfile = 0;
	char *user_file = "/usr";
	
	int magic_number = MAGIC;

	tcbptr = &TCB_info;

	j = 1;
	if(argv[argc-1][0] == '-'){
		switch (argv[argc-1][1]){
			case 'v':
				verbose++;
				argc--;
				break;
			case 'u':
				TCB_FILE = "user_tcblist";
				userfile++;
				argc--;
				break;
			case 'r':
				TCB_FILE = "root_tcblist";
				argc--;
				break;
			case 's':
				TCB_FILE = "sa_tcblist";
				argc--;
				break;
			default:
				fprintf(stderr,"invalid option %c\n",argv[argc-1][1]);
				exit(1);
		}
	}
	if(stat(TCB_FILE, &tcbptr->tcb_stat) >= 0) 
		chmod(TCB_FILE,0600);
	if((ftcb = fopen(TCB_FILE,"w")) == NULL){
		fprintf(stderr,"cannot open %s\n",TCB_FILE);
		exit(1);
	}
	printf("Making the TCB file\n");
	fwrite(&magic_number,sizeof(magic_number),1,ftcb);
	do {
		clear_tcb(tcbptr);
		if(argc > 1) {
			if((f = fopen(argv[j], "r")) == NULL) {
				(void) fprintf(stderr, "make_tcb: Can't open %s\n", argv[j]);
				continue;
			}
			if(verbose)
				printf("%s\n",argv[j]);
			i = 0;
			while(argv[j][i]){
				tcbptr->name[i] = argv[j][i];
				i++;
			}
			if(stat(tcbptr->name, &tcbptr->tcb_stat) < 0) {
				fprintf(stderr,"can't stat %s \n", tcbptr->name);
				return(0);
			}
		} else{
			tcbptr->name[0] = '/';
			switch((j = getname())){
				case 0:
					fclose(ftcb);
					chmod(TCB_FILE,0400);
					exit(0);
				case -1:
					if(userfile){
						*(int *)tcbptr = *(int *)user_file;
						tcbptr->name[4] = '/';
						strcpy(&tcbptr->name[5],Spec.new_name);
					}
					else
						strcpy(&tcbptr->name[1],Spec.new_name);
					if(verbose)
						printf("%s\n",tcbptr->name);
					if((f = fopen(Spec.old_name, "r")) == NULL) {
						(void) fprintf(stderr, "make_tcb: Can't open %s\n", Spec.old_name);
						continue;
					}
					break;
				case -2:
					continue;
			}
		}
		if(stat(Spec.old_name, &tcbptr->tcb_stat) < 0) {
			fprintf(stderr,"can't stat %s \n", Spec.old_name);
			return(0);
		}
		tcbptr->tcb_cksum = cksum(f);
		if(verbose)
			printf("checksum %x\n",tcbptr->tcb_cksum);
		tcbptr->tcb_stat.st_mode = Spec.new_mode;
		tcbptr->tcb_stat.st_uid = Spec.new_uid;
		tcbptr->tcb_stat.st_gid = Spec.new_gid;
		fwrite(tcbptr,sizeof(*tcbptr),1,ftcb);

		fclose(f);
	} while((++j < argc) );
	fclose(ftcb);
	chmod(TCB_FILE,0400);
}



cksum(f)
register FILE *f;
{
	unsigned total,nbytes;
	int ca;
	unsigned char *sumptr;
	union {
		unsigned u_sum;
		unsigned char u_csum[4];
	}sum;


	total = 0;
	nbytes = 0;
	sumptr = (unsigned char *)&sum;

	while((ca = getc(f)) != EOF) {
		nbytes++;
		sum.u_csum[nbytes&3] = ca;
		if((nbytes & 3) == 0)
			total += sum.u_sum;	
	}
	total += sum.u_sum;

	return(total);

}


clear_tcb(tcbptr)
register char *tcbptr;
{
	register i;


	for(i=0;i<sizeof(struct TCB);i++,tcbptr++)
		*tcbptr = 0;
}
