#	START NEW ARIX SCCS HEADER
#
#	@(#) mailx.mk: version 25.1 created on 12/2/91 at 16:35:09
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mailx.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:#ident	"mailx:mailx.mk	1.14"

#ident	"@(#)mailx:mailx.mk	25.1"

#
# mailx -- a modified version of a University of California at Berkeley
#	mail program
#
# for standard Unix
#

IROOT =
SROOT =
include $(IROOT)/macdefs

VERSION=3.0
HDR=	./hdr
HELP=	help
DESTDIR= $(ROOT)/usr/bin
DESTLIB= $(ROOT)/usr/lib/mailx
HELPDIR= $(DESTLIB)

DEFINES= -DUSG -DUSG_TTY -DSECURITY
# CFLAGS=	-O -I$(HDR) $(DEFINES) 
# LDFLAGS= -n -i -s
MAILDIR = $(ROOT)/usr/mail


OBJS=	version.o \
	aux.o \
	cmd1.o \
	cmd2.o \
	cmd3.o \
	cmd4.o \
	cmdtab.o \
	collect.o \
	config.o \
	edit.o \
	fio.o \
	getname.o \
	hostname.o \
	head.o \
	usg.local.o \
	lock.o \
	lex.o \
	list.o \
	main.o \
	names.o \
	optim.o \
	popen.o \
	quit.o \
	send.o \
	stralloc.o \
	temp.o \
	tty.o \
	vars.o \
	sigretro.o \
	lpaths.o \
	extern.o 

SRCS=	aux.c \
	cmd1.c \
	cmd2.c \
	cmd3.c \
	cmd4.c \
	cmdtab.c \
	collect.c \
	config.c \
	edit.c \
	fio.c \
	getname.c \
	head.c \
	hostname.c \
	usg.local.c \
	lock.c \
	lex.c \
	list.c \
	main.c \
	names.c \
	optim.c \
	popen.c \
	quit.c \
	send.c \
	stralloc.c \
	temp.c \
	tty.c \
	vars.c \
	sigretro.c \
	lpaths.c \
	extern.c

HDRS=	$(HDR)/rcv.h \
	$(HDR)/configdefs.h \
	$(HDR)/def.h \
	$(HDR)/glob.h \
	$(HDR)/usg.local.h \
	$(HDR)/local.h \
	$(HDR)/uparm.h \
	$(HDR)/sigretro.h

SOURCE= aux.c         config.c      lex.c         popen.c       tty.c \
	cmd1.c        edit.c        list.c        quit.c        usg.local.c \
	cmd2.c        extern.c      lock.c        rmmail.c      vars.c \
	cmd3.c        fio.c         lpaths.c      send.c \
	cmd4.c        getname.c     main.c        sigretro.c \
	cmdtab.c      head.c        names.c       stralloc.c \
	collect.c     hostname.c    optim.c       temp.c

S=	$(SRCS) version.c $(HDRS)

.c.o:
	$(CC) -c $(CFLAGS) -I$(HDR) $(DEFINES) $*.c

all:	mailx rmmail

mailx:	$(OBJS)
#	-rm -f mailx
	$(CC)  -o mailx $(OBJS) $(LDFLAGS)

mailx.o: $S
	$(CC) -c $(CFLAGS) -I$(HDR) $(DEFINES) $*.c

rmmail:	rmmail.o
	$(CC) -o rmmail rmmail.o $(LDFLAGS)

rmmail.o: rmmail.c
	$(CC) $(CFLAGS) -c rmmail.c

install: ckdirs all
	$(INS) mailx $(DESTDIR)/mailx
	chown bin $(DESTDIR)/mailx
	chgrp mail $(DESTDIR)/mailx
	chmod 2755 $(DESTDIR)/mailx
	/bin/ln $(DESTDIR)/mailx $(DESTDIR)/sentto
	$(INS) rmmail $(DESTLIB)/rmmail
	chown bin $(DESTLIB)/rmmail
	chgrp mail $(DESTLIB)/rmmail
	chmod 2755 $(DESTLIB)/rmmail
	$(INS) $(HELP)/mailx.help $(HELPDIR)/mailx.help
	$(INS) $(HELP)/mailx.help.~ $(HELPDIR)/mailx.help.~
	chmod 0664 $(HELPDIR)/mailx.help*
	chown bin $(HELPDIR)/mailx.help*
	chgrp bin $(HELPDIR)/mailx.help*

version.o:	version.c
	$(CC) $(CFLAGS) -c version.c
	-rm -f version.c

version.c:
	echo \
	"char *version=\"mailx version $(VERSION)\";"\
		> version.c

clean:
	-rm -f *.o
	-rm -f version.c a.out core 

clobber:	clean
	-rm -f mailx rmmail tags greplist

ckdirs:
	if [ ! -d $(DESTLIB) ] ; then mkdir $(DESTLIB) ; fi
	if [ ! -d $(MAILDIR) ];  then mkdir $(MAILDIR);  fi
	if [ ! -d $(HELPDIR) ];  then mkdir $(HELPDIR);  fi
	if [ ! -d $(MAILDIR)/:saved ]; then mkdir $(MAILDIR)/:saved; fi
	chmod 775 $(DESTLIB)
	chgrp mail $(DESTLIB)
	chmod 775 $(MAILDIR)
	chgrp mail $(MAILDIR)
	chmod 775 $(HELPDIR)
	chgrp mail $(HELPDIR)
	chmod 775 $(MAILDIR)/:saved
	chgrp  mail $(MAILDIR)/:saved

ctags:
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE)		;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

