#	START NEW ARIX SCCS HEADER
#
#	@(#) model.mk: version 25.1 created on 12/2/91 at 16:27:45
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)model.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:model/Makefile	1.8"

#
# Makefile for lp/model
#
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

USRLIB	=	$(ROOT)/usr/lib
USRSPOOL=	$(ROOT)/usr/spool

BINDIR	=	$(USRSPOOL)/lp/bin
MODELDIR=	$(USRSPOOL)/lp/model

OWNER	=	lp
GROUP	=	bin

EMODES	=	0555
SMODES	=	04555
FMODES	=	0444

DEBUG	=	-g

INC	=	$(ROOT)/usr/include
LPINC	=	../include

CCFLAGS	=	$(CFLAGS) -I$(LPINC) 

LIBDIR	=	../lib

LIBACC	=	$(LIBDIR)/access/liblpacc.a
LIBCLS	=	$(LIBDIR)/class/liblpcls.a
LIBFLT	=	$(LIBDIR)/filters/liblpflt.a
LIBFRM	=	$(LIBDIR)/forms/liblpfrm.a
LIBFS	=	$(LIBDIR)/fs/liblpfs.a
LIBLP	=	$(LIBDIR)/lp/liblp.a
LIBMSG	=	$(LIBDIR)/msgs/liblpmsg.a
LIBOAM	=	$(LIBDIR)/oam/liblpoam.a
LIBPRT	=	$(LIBDIR)/printers/liblpprt.a
LIBREQ	=	$(LIBDIR)/requests/liblpreq.a
LIBUSR	=	$(LIBDIR)/users/liblpusr.a

LINTACC	=	$(LIBDIR)/access/llib-llpacc.ln
LINTCLS	=	$(LIBDIR)/class/llib-llpcls.ln
LINTFLT	=	$(LIBDIR)/filters/llib-llpflt.ln
LINTFRM	=	$(LIBDIR)/forms/llib-llpfrm.ln
LINTFS	=	$(LIBDIR)/fs/llib-llpfs.ln
LINTLP	=	$(LIBDIR)/lp/llib-llp.ln
LINTMSG	=	$(LIBDIR)/msgs/llib-llpmsg.ln
LINTOAM	=	$(LIBDIR)/oam/llib-llpoam.ln
LINTPRT	=	$(LIBDIR)/printers/llib-llpprt.ln
LINTREQ	=	$(LIBDIR)/requests/llib-llpreq.ln
LINTUSR	=	$(LIBDIR)/users/llib-llpusr.ln

SRCS	= \
		lp.set.c \
		lp.cat.c \
		lp.page.c \
		lp.tell.c \
		drn.output.c

.c.o:	$(SRCS)
	$(CC) $(CCFLAGS) -c $(SRCS)	
#
# Don't use $(SRCS:.c=.o) because it doesn't work on lp.cat.c
OBJS	= \
		lp.set.o \
		lp.cat.o \
		lp.page.o \
		lp.tell.o \
		drn.output.o

CMDS	= \
		lp.set \
		lp.cat \
		lp.page \
		lp.tell \
		drn.output

MODELS	= \
		standard \
		1640 \
		5310 \
		dqp10 \
		dumb \
		f450 \
		hp \
		lqp40 \
		ph.daps \
		pprx \
		prx

MISC	= \
		alert.proto

all:		$(CMDS)

install:	all
	@for cmd in $(CMDS); do \
		echo "\t$(INS)  $$cmd	$(BINDIR)/$$cmd" ; \
		$(INS)  $$cmd	$(BINDIR)/$$cmd; \
		echo "\tchmod	$(EMODES)  $(BINDIR)/$$cmd" ; \
		chmod	$(EMODES)  $(BINDIR)/$$cmd; \
		echo "\tchown	$(OWNER)  $(BINDIR)/$$cmd" ; \
		chown	$(OWNER)  $(BINDIR)/$$cmd; \
		echo "\tchgrp	$(GROUP) $(BINDIR)/$$cmd" ; \
		chgrp	$(GROUP) $(BINDIR)/$$cmd; \
	done
	@for model in $(MODELS); do \
		echo "\t$(INS)  $$model	$(MODELDIR)/$$model" ; \
		$(INS)  $$model	$(MODELDIR)/$$model; \
		echo "\tchmod	$(EMODES) $(MODELDIR)/$$model" ; \
		chmod	$(EMODES) $(MODELDIR)/$$model; \
		echo "\tchown	$(OWNER)  $(MODELDIR)/$$model" ; \
		chown	$(OWNER)  $(MODELDIR)/$$model; \
		echo "\tchgrp	$(GROUP)  $(MODELDIR)/$$model" ; \
		chgrp	$(GROUP)  $(MODELDIR)/$$model; \
	done
	@for misc in $(MISC); do \
		echo "\t$(INS)  $$misc	$(BINDIR)/$$misc" ; \
		$(INS)  $$misc	$(BINDIR)/$$misc; \
		echo "\tchmod	$(FMODES)	$(BINDIR)/$$misc" ; \
		chmod	$(FMODES)	$(BINDIR)/$$misc; \
		echo "\tchown	$(OWNER)	$(BINDIR)/$$misc" ; \
		chown	$(OWNER)	$(BINDIR)/$$misc; \
		echo "\tchgrp	$(GROUP)	$(BINDIR)/$$misc" ; \
		chgrp	$(GROUP)	$(BINDIR)/$$misc; \
	done


lp.set:		lp.set.o \
			$(LIBLP)
	$(CC) -o lp.set lp.set.o $(LDFLAGS) \
			$(LIBLP) \
			-lcurses $(LIBS)

lp.cat:		lp.cat.o \
			$(LIBLP)
	$(CC) -o lp.cat lp.cat.o $(LDFLAGS) \
			$(LIBLP) $(LIBS)

lp.page:	lp.page.o
	$(CC) -o lp.page lp.page.o $(LDFLAGS) $(LIBS)

lp.tell:	lp.tell.o \
			$(LIBMSG) \
			$(LIBLP)
	$(CC) -o lp.tell lp.tell.o $(LDFLAGS) \
			$(LIBMSG) \
			$(LIBLP) $(LIBS)

drn.output:	drn.output.o \
			$(LIBLP)
	$(CC) -o drn.output drn.output.o $(LDFLAGS) \
			$(LIBLP) $(LIBS)

lint:
	lint $(CCFLAGS) lp.set.c \
			$(LINTLP)
	lint $(CCFLAGS) lp.cat.c
	lint $(CCFLAGS) lp.page.c
	lint $(CCFLAGS) lp.tell.c \
			$(LINTLP) \
			$(LINTMSG)
	lint $(CCFLAGS) drn.output.c

strip:
	$(STRIP) $(CMDS)

clean:
	$(RM) $(OBJS) core a.out

clobber:	clean
	$(RM) $(CMDS)
