#	START NEW ARIX SCCS HEADER
#
#	@(#) lp.mk: version 25.1 created on 12/2/91 at 16:21:45
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lp.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved
#
#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#
#ident	"@(#)nlp:lib/Makefile	1.5"
#
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

DEBUG		=

OWNER		= lp
GROUP		= bin
DMODES		= 0775
PRIMODE		= 0771
PUBMODE		= 0773

USRSPOOL	= $(ROOT)/usr/spool
SPOOLDIR	= $(USRSPOOL)/lp
LPDSPOOL	= $(USRSPOOL)/lpd
FIFODIR		= $(SPOOLDIR)/fifos
FIFOPRI		= $(FIFODIR)/private
FIFOPUB		= $(FIFODIR)/public

#
# The following directory list is sorted - don't change it without sorting.
#
DIRS		= \
		$(USRSPOOL) \
		$(LPDSPOOL) \
		$(LPDSPOOL)/remote \
		$(SPOOLDIR) \
		$(SPOOLDIR)/admins \
		$(SPOOLDIR)/admins/lp \
		$(SPOOLDIR)/admins/lp/classes \
		$(SPOOLDIR)/admins/lp/forms \
		$(SPOOLDIR)/admins/lp/interfaces \
		$(SPOOLDIR)/admins/lp/logs \
		$(SPOOLDIR)/admins/lp/printers \
		$(SPOOLDIR)/admins/lp/pwheels \
		$(SPOOLDIR)/bin \
		$(SPOOLDIR)/class \
		$(SPOOLDIR)/interface \
		$(SPOOLDIR)/logs \
		$(SPOOLDIR)/member \
		$(SPOOLDIR)/model \
		$(SPOOLDIR)/request \
		$(SPOOLDIR)/requests \
		$(SPOOLDIR)/system \
		$(SPOOLDIR)/temp \
		$(FIFODIR) \
		$(FIFOPRI) \
		$(FIFOPUB)

INSTDIRS	= cmd etc filter model terminfo

ALLDIRS		= lib $(INSTDIRS)

all prof lprof clean clobber:
	@for dir in $(ALLDIRS) ; \
	do \
		echo "cd $$dir" ; \
		cd $$dir ; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk $@" ; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk $@ ; \
		echo "cd .." ; \
		cd .. ; \
	done

install:	all new strip dirs
	@for dir in $(INSTDIRS) ; \
	do \
		echo "cd $$dir" ; \
		cd $$dir ; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk install" ; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk install ; \
		echo "cd .." ; \
		cd .. ; \
	done

new:
	@if [ ! -d $(LPDSPOOL) ] ; \
	then \
		echo "\tmkdir $(LPDSPOOL)" ; \
		mkdir $(LPDSPOOL) ; \
		echo "\tmkdir $(LPDSPOOL)/remote" ; \
		mkdir $(LPDSPOOL)/remote ; \
		echo "\ttouch $(NEWDATE) $(LPDSPOOL)/errs" ; \
		touch $(NEWDATE) $(LPDSPOOL)/errs ; \
		echo "\ttouch $(NEWDATE) $(LPDSPOOL)/remote/errs" ; \
		touch $(NEWDATE) $(LPDSPOOL)/remote/errs ; \
	fi
	@if [ ! -d $(SPOOLDIR) ] ; \
	then \
		echo "\tmkdir $(SPOOLDIR)" ; \
		mkdir $(SPOOLDIR) ; \
	fi
	@if [ ! -d $(SPOOLDIR)/model ] ; \
	then \
		echo "\tmkdir $(SPOOLDIR)/model" ; \
		mkdir $(SPOOLDIR)/model ; \
	fi
	@echo "\tcd $(SPOOLDIR)" ; \
	cd $(SPOOLDIR) ; \
	for i in class interface member request ; \
	do \
		if [ ! -d $$i ] ; \
		then \
			echo "\tmkdir $$i" ; \
			mkdir $$i ; \
		fi ; \
	done ; \
	$(CH)echo "\tchmod 755 . class interface member model request" ; \
	$(CH)chmod 755 . class interface member model request ; \
	echo ">pstatus >qstatus" ; \
	>pstatus >qstatus ; \
	echo "\ttouch  $(NEWDATE) pstatus" ; \
	touch $(NEWDATE) pstatus ; \
	echo "\ttouch $(NEWDATE) qstatus" ; \
	touch $(NEWDATE) qstatus ; \
	$(CH)echo "\tchmod 644 pstatus qstatus" ; \
	$(CH)chmod 644 pstatus qstatus ; \
	$(CH)echo "\tchown $(OWNER) . *" ; \
	$(CH)chown $(OWNER) . * ; \
	$(CH)echo "\tchgrp $(GROUP) . *"
	$(CH)chgrp $(GROUP) . *

dirs:
	@for d in $(DIRS) ; \
	do \
		if [ ! -d $$d ] ; \
		then \
			echo "\tmkdir -p $$d" ; \
			mkdir -p $$d ; \
		fi ; \
	done
	$(CH)chown $(OWNER) $(DIRS)
	$(CH)chgrp $(GROUP) $(DIRS)
	$(CH)chmod $(DMODES) $(DIRS)
	$(CH)chmod $(PRIMODE) $(FIFOPRI)
	$(CH)chmod $(PUBMODE) $(FIFOPUB)

strip:
	@if [ -n "$(STRIP)" ] ; \
	then \
		echo "$(MAKE) STRIP=$(STRIP) -$(MAKEFLAGS)f lp.mk realstrip";\
		$(MAKE) STRIP=$(STRIP) -$(MAKEFLAGS)f lp.mk realstrip ; \
	else \
		echo "$(MAKE) STRIP=strip -$(MAKEFLAGS)f lp.mk realstrip"; \
		$(MAKE) STRIP=strip -$(MAKEFLAGS)f lp.mk realstrip ; \
	fi

realstrip:
	@for dir in $(INSTDIRS) ; \
	do \
		echo "cd $$dir" ; \
		cd $$dir ; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk STRIP=$(STRIP) strip" ; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk STRIP=$(STRIP) strip ; \
		echo "cd .." ; \
		cd .. ; \
	done

lint lintlib lintsrc:
	@for dir in $(ALLDIRS) ; \
	do \
		echo "cd $$dir" ; \
		cd $$dir ; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk FUNCDLC=\"$(FUNCDCL)\" $@"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk FUNCDLC="$(FUNCDCL)" $@ ; \
		echo "cd .." ; \
		cd .. ; \
	done
