/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) getrequest.c: version 25.1 created on 12/2/91 at 16:26:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)getrequest.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)nlp:lib/requests/getrequest.c	1.6"
/* EMACS_MODES: !fill, lnumb, !overwrite, !nodelete, !picture */

#include "stdio.h"
#include "string.h"
#include "errno.h"
#include "sys/types.h"

#include "lp.h"
#include "requests.h"

extern int		atoi();

extern long		strtol();

extern void		free();

extern struct {
	char			*v;
	short			len;
}			reqheadings[];

/**
 ** getrequest() - EXTRACT REQUEST STRUCTURE FROM DISK FILE
 **/

REQUEST			*getrequest (file)
	char			*file;
{
	static REQUEST		reqbuf;

	char			buf[BUFSIZ],
				*path,
				*p;

	FILE			*fp;

	int			fld;


	if (!Lp_Temp) {
		getpaths ();
		if (!Lp_Temp)
			return (0);
	}
	if (!(path = makepath(Lp_Temp, file, (char *)0)))
		return (0);

	if (!(fp = open_lpfile(path, "r"))) {
		free (path);
		return (0);
	}
	free (path);

	reqbuf.copies		= 1;
	reqbuf.destination	= 0;
	reqbuf.file_list	= 0;
	reqbuf.form		= 0;
	reqbuf.actions		= 0;
	reqbuf.alert		= 0;
	reqbuf.options		= 0;
	reqbuf.priority		= -1;
	reqbuf.pages		= 0;
	reqbuf.charset		= 0;
	reqbuf.modes		= 0;
	reqbuf.title		= 0;
	reqbuf.input_type	= 0;
	reqbuf.user		= 0;
	reqbuf.outcome		= 0;
	reqbuf.ruid		= 0;	

	while (fgets(buf, BUFSIZ, fp) != NULL) {

		buf[strlen(buf) - 1] = 0;

		for (fld = 0; fld < RQ_MAX; fld++)
			if (
				reqheadings[fld].v
			     && reqheadings[fld].len
			     && STRNEQU(
					buf,
					reqheadings[fld].v,
					reqheadings[fld].len
				)
			) {
				p = buf + reqheadings[fld].len;
				break;
			}

		if (fld >= RQ_MAX) {
			close_lpfile (fp);
			errno = EBADF;
			return (0);
		}

		switch (fld) {

		case RQ_COPIES:
			reqbuf.copies = atoi(p);
			break;
		case RQ_DEST:
			reqbuf.destination = strdup(p);
			break;
		case RQ_FILE:
			appendlist (&reqbuf.file_list, p);
			break;
		case RQ_FORM:
			if (!STREQU(p, NAME_ANY))
				reqbuf.form = strdup(p);
			break;
		case RQ_HANDL:
			if (STREQU(p, NAME_RESUME))
			{
				reqbuf.actions |= ACT_RESUME;
			}
			else if (STREQU(p, NAME_HOLD))
			{
				reqbuf.actions |= ACT_HOLD;
			}
			else if (STREQU(p, NAME_IMMEDIATE))
			{
				reqbuf.actions |= ACT_IMMEDIATE;
			}
			break;
		case RQ_NOTIFY:
			if (STREQU(p, "M"))
				reqbuf.actions |= ACT_MAIL;
			else if (STREQU(p, "W"))
				reqbuf.actions |= ACT_WRITE;
			else
				reqbuf.alert = strdup(p);
			break;
		case RQ_OPTS:
			reqbuf.options = strdup(p);
			break;
		case RQ_PRIOR:
			reqbuf.priority = atoi(p);
			if (reqbuf.actions==0) reqbuf.actions = ACT_PRIORITY;
			break;
		case RQ_PAGES:
			reqbuf.pages = strdup(p);
			break;
		case RQ_CHARS:
			if (!STREQU(p, NAME_ANY))
				reqbuf.charset = strdup(p);
			break;
		case RQ_TITLE:
			reqbuf.title = strdup(p);
			break;
		case RQ_MODES:
			reqbuf.modes = strdup(p);
			break;
		case RQ_TYPE:
			reqbuf.input_type = strdup(p);
			break;
		case RQ_USER:
			reqbuf.user = strdup(p);
			break;
		case RQ_RAW:
			reqbuf.actions |= ACT_RAW;
			break;
		case RQ_FAST:
			reqbuf.actions |= ACT_FAST;
			break;
		case RQ_STAT:
			reqbuf.outcome = (ushort)strtol(p, (char **)0, 16);
			break;
		case RQ_RUID:
			reqbuf.ruid = atoi(p); 
			break;
		}

	}
	if (ferror(fp)) {
		int			save_errno = errno;

		close_lpfile (fp);
		errno = save_errno;
		return (0);
	}
	close_lpfile (fp);

	/*
	 * Now go through the structure and see if we have
	 * anything strange.
	 */
	if (
		reqbuf.copies <= 0
	     || !reqbuf.file_list || !*(reqbuf.file_list)
	     || reqbuf.priority < -1 || 39 < reqbuf.priority
	     || STREQU(reqbuf.input_type, NAME_ANY)
	     || STREQU(reqbuf.input_type, NAME_TERMINFO)
	) {
		freerequest (&reqbuf);
		errno = EBADF;
		return (0);
	}

	/*
	 * Guarantee some return values won't be null or empty.
	 */
	if (!reqbuf.destination || !*reqbuf.destination) {
		if (reqbuf.destination)
			free (reqbuf.destination);
		reqbuf.destination = strdup(NAME_ANY);
	}
	if (!reqbuf.input_type || !*reqbuf.input_type) {
		if (reqbuf.input_type)
			free (reqbuf.input_type);
		reqbuf.input_type = strdup(NAME_SIMPLE);
	}

	return (&reqbuf);
}
