/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) startdmn.c: version 25.1 created on 12/2/91 at 16:26:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)startdmn.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)startdmn.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)startdaemon.c	5.1 (Berkeley) 6/6/85"; */
#endif /* not lint */

/*
 * Tell the printer daemon that there are new files in the spool directory.
 */

#include <stdio.h>
#include <sys/types.h>
#include <tiuser.h>
#include <syslog.h>
#include <sys/socket.h>
#ifdef	S3000
#  include "sys/in.h"
#else
#  include "netinet/in.h"
#endif
#include <netdb.h>
#include <fcntl.h>
#include <string.h>
#include "lpd.local.h"

startdaemon(printer)
	char *printer;
{
	register int s, n, i;
	char	buf[256], *p, tbuf[256];
	int	flags;

	if (Gethostname(buf, sizeof(buf)) < 0) {
		syslog(LOG_ERR, "Gethostname: %m");
		return(0);
	}

	if ((s = getport(buf)) < 0) {
		syslog(LOG_ERR, "getport failed");
		return(0);
	}

	/*
	 * Prepare to send request to daemon
	 */
	(void) sprintf(buf, "\1%s\n", printer);
	n = strlen(buf);

	if (t_snd(s, buf, n, 0) != n) {
		tsyslog(LOG_ERR, s, "t_snd");
		(void) t_unbind(s);
		(void) t_close(s);
		return(0);
	}

	/* read acknowledgement */
	if ((n = t_rcv(s, buf, 1, &flags)) == 1) {
		if (buf[0] == '\0') {		/* everything is OK */
			(void) t_snddis(s, (struct t_call *) NULL);
			(void) t_unbind(s);
			(void) t_close(s);
			return(1);
		}
	}

	i = 0;
	if (n == 1) {
		tbuf[i++] = buf[0];
	}

	while (t_rcv(s, buf, 1, &flags) > 0)
		tbuf[i++] = buf[0];

	tbuf[i] = '\0';
	sleep(1);	/* let lpd get message in */
	syslog(LOG_ERR, "daemon acknowlegement failed");
	syslog(LOG_DEBUG, tbuf);

	(void) t_rcvdis(s, NULL);
	(void) t_unbind(s);
	(void) t_close(s);
	return(0);
}

/*
 * Create a connection to the (possibly) remote printer server.
 * Most of this code comes from rcmd.c. (not anymore)
 */
getport(rhost)
	char *rhost;
{
	int s, lport, rport = IPPORT_RESERVED - 1;
	int event;
	struct hostent		*hp;
	struct servent		*sp;
	struct sockaddr_in	sin, *inetaddr;
	struct t_info		tinfo;
	struct t_call		*call;
	struct t_bind		*req, *ret;

	/*
	 * Get the host address and port number to connect to.
	 */
	if (rhost == (char *) NULL) {
		syslog(LOG_ERR, "no remote host to connect to");
		return(-1);
	}

	hp = gethostbyname(rhost);
	if (hp == (struct hostent *) NULL) {
		syslog(LOG_ERR, "unknown host %s", rhost);
		return(-1);
	}

	sp = getservbyname("printer", "tcp");
	if (sp == (struct servent *) NULL) {
		syslog(LOG_ERR, "printer/tcp: unknown service");
		return(-1);
	}

	/*
	 * Establish a transport-endpoint
	 */
	s = t_open(TLI_DEV, O_RDWR, &tinfo);
	if (s < 0) {
		tsyslog(LOG_ERR, s, "t_open");
		return(-1);
	}

	/*
	 * Initialize t_bind structures for bind
	 */
	req = (struct t_bind *) t_alloc(s, T_BIND, T_ALL);
	ret = (struct t_bind *) t_alloc(s, T_BIND, T_ALL);
	if (req == (struct t_bind *) NULL || ret == (struct t_bind *) NULL) {
		tsyslog(LOG_ERR, s, "t_alloc");
		(void) t_close(s);
		return(-1);
	}

	(void) memset((char *) &sin, '\0', sizeof(sin));
	sin.sin_family = hp->h_addrtype;
	req->addr.len = req->addr.maxlen = tinfo.addr;
	ret->addr.maxlen = tinfo.addr;
	req->qlen = 0;

	/*
	 * Run through reserved ports until we get one
	 */
	for (lport = rport; lport > 0; --lport) {
		sin.sin_port = htons(lport);
		inetaddr = (struct sockaddr_in *) (req->addr.buf);
		(void) memcpy((char *) inetaddr, (char *) &sin, tinfo.addr);

		if (t_bind(s, req, ret) < 0) {
			tsyslog(LOG_ERR, s, "t_bind");
			(void) t_free(req, T_BIND);
			(void) t_free(ret, T_BIND);
			(void) t_close(s);
			return(-1);
		}

		inetaddr = (struct sockaddr_in *) (ret->addr.buf);
		if (ntohs(inetaddr->sin_port) <= rport)
			break;

		(void) t_unbind(s);
	}

	(void) t_free(req, T_BIND);
	(void) t_free(ret, T_BIND);

	if (lport <= 0) {
		syslog(LOG_ERR, "getport: couldn't obtain reserved port");
		(void) t_close(s);
		return(-1);
	}

	/*
	 * Initialize t_call structure for connect
	 */
	call = (struct t_call *) t_alloc(s, T_CALL, T_ALL);
	if (call == (struct t_call *) NULL) {
		tsyslog(LOG_ERR, s, "t_alloc");
		(void) t_close(s);
		return(-1);
	}

	(void) memset((char *) &sin, '\0', sizeof(sin));
	(void) memcpy((char *) &sin.sin_addr, (char *) hp->h_addr,
			(size_t) hp->h_length);
	sin.sin_family = hp->h_addrtype;
	sin.sin_port = sp->s_port;

	inetaddr = (struct sockaddr_in *) (call->addr.buf);
	(void) memcpy((char *) inetaddr, (char *) &sin, tinfo.addr);
	call->addr.len = call->addr.maxlen = tinfo.addr;
	call->opt.maxlen = call->opt.len = 0;
	call->udata.maxlen = call->udata.len = 0;

	/*
	 * Try connecting to the server.
	 */
	if (t_connect(s, call, (struct t_call *) NULL) < 0) {
		tsyslog(LOG_ERR, "t_connect");
		(void) t_free(call, T_CALL);
		(void) t_close(s);
		return(-1);
	}

	(void) t_free(call, T_CALL);
	return(s);
}
