/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) getremote.c: version 25.1 created on 12/2/91 at 16:25:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)getremote.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)getremote.c	25.1"

#include "stdio.h"
#include "string.h"
#include "netdb.h"

/**
 ** getremote() - DETERMINE IF PRINTER IS REMOTE
 **/

extern char *pgetstr();

int
getremote(printer)
	char	*printer;
{
	char	line[BUFSIZ], pbuf[BUFSIZ/2], *bp = pbuf;
	char	name[256], *rm;
	int	status;
	struct hostent	*hp;

	if (!printer || !*printer) {
		return (0);
	}

	if ((status = pgetent(line, printer)) < 0) {
		/* couldn't open description file */
		return (0);
	}
	else if (status == 0) {
		/* unknown printer */
		return (0);
	}

	rm =  pgetstr("rm", &bp);

	if (rm == (char *) NULL) {
		return(0);
	}

	/*
	 * The rest of this routine is trying to verify that the
	 * remote machine specified is not the local machine.
	 */
	if (Gethostname(name, sizeof(name)) < 0)
		return(1);

	name[sizeof(name)-1] = '\0';
	hp = gethostbyname(name);
	if (hp == (struct hostent *) NULL) {
		/* local name lookup failed, consider it remote */
		return(1);
	}
	(void) strcpy(name, hp->h_name);

	hp = gethostbyname(rm);
	if (hp == (struct hostent *) NULL) {
		/* remote name lookup failed, consider it remote anyway */
		return(1);
	}

	if (strcmp(name, hp->h_name) == 0) {
		/* remote is local! */
		return(0);
	}

	return(1);
}
