#	START NEW ARIX SCCS HEADER
#
#	@(#) msgs.mk: version 25.1 created on 12/2/91 at 16:24:31
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)msgs.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:lib/msgs/Makefile	1.6"
#
# Makefile for messagemgmt(lp) routines
#
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

USE_FIFOS=	-DUSE_FIFOS

DEBUG	=	-g

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

INC	=	$(ROOT)/usr/include
LPINC	=	../../include

CCFLAGS	=	$(CFLAGS) -I$(LPINC) $(USE_FIFOS)

LIBRARY	=	liblpmsg.a
PLIBRARY=	p$(LIBRARY)
QLIBRARY=	q$(LIBRARY)

LINTSRC	=	llib-llpmsg
LINTLIB	=	$(LINTSRC).ln

SRCS	= \
		_getmsg.c \
		_putmsg.c \
		getmessage.c \
		hslconv.c \
		putmessage.c \
		msgfmts.c \
		mclos.c \
		mneeds.c \
		mopen.c \
		mrecv.c \
		msend.c \
		read_fifo.c \
		write_fifo.c

LINTS	= \
		../lp/llib-llp.ln

OBJS	=	$(SRCS:.c=.o)
POBJS	=	$(SRCS:.c=.p)
QOBJS	=	$(SRCS:.c=.q)

.SUFFIXES:	.o .p .q

.c.p:
	@-if [ -f $*.o ] ; then mv $*.o tmp ; fi
	$(CC) -p $(CCFLAGS) -c $*.c
	@-mv $*.o $*.p
	@-if [ -f tmp ] ; then mv tmp $*.o ; fi

.c.q:
	@-if [ -f $*.o ] ; then mv $*.o tmp ; fi
	$(CC) -ql $(CCFLAGS) -c $*.c
	@-mv $*.o $*.q
	@-if [ -f tmp ] ; then mv tmp $*.o ; fi

#all:		$(LIBRARY) $(LINTLIB)
all:		$(LIBRARY)

install:	all
	@echo "Not a delivered part of LP - not installed"
	@false

clean:
	$(RM) $(OBJS) $(POBJS) $(QOBJS) *.o core
	$(RM) mopen.c mclos.c mrecv.c msend.c

clobber:	clean
	$(RM) $(LIBRARY) $(PLIBRARY) $(QLIBRARY) $(LINTLIB) *.a

strip:
	$(STRIP) $(LIBRARY)


$(OBJS):	$(LPINC)/msgs.h

$(LIBRARY):	$(OBJS)
	$(AR) rv $(LIBRARY) $?

prof:		$(PLIBRARY)

$(PLIBRARY):	$(POBJS)
	$(AR) rv $(PLIBRARY) $?

lprof:		$(QLIBRARY)

$(QLIBRARY):	$(QOBJS)
	$(AR) rv $(QLIBRARY) $?

change:
	@-touch mopen.c mclos.c mrecv.c msend.c msgfmts.c

concat:
	@( \
		echo '#if	defined(USE_FIFOS)'; \
		cat $(COMPONENT)_fifo.c; \
		echo '#else	/* USE_FIFOS */'; \
		cat $(COMPONENT)_ipc.c; \
		echo '#endif	/* USE_FIFOS */'; \
	) >$(COMPONENT).c

mopen.c:	mopen_fifo.c mopen_ipc.c
	$(MAKE) -$(MAKEFLAGS)f msgs.mk COMPONENT=$(@:.c=) concat

mclos.c:	mclos_fifo.c mclos_ipc.c
	$(MAKE) -$(MAKEFLAGS)f msgs.mk COMPONENT=$(@:.c=) concat

mrecv.c:	mrecv_fifo.c mrecv_ipc.c
	$(MAKE) -$(MAKEFLAGS)f msgs.mk COMPONENT=$(@:.c=) concat

msend.c:	msend_fifo.c msend_ipc.c
	$(MAKE) -$(MAKEFLAGS)f msgs.mk COMPONENT=$(@:.c=) concat

lint:
	lint -ux $(CCFLAGS) $(SRCS) $(LINTS)

lintsrc:	$(LINTSRC)

$(LINTSRC):	$(SRCS)
	if [ -n "$(FUNCDCL)" ]; then $(FUNCDCL) $(SRCS) >$(LINTSRC); fi

lintlib:	$(LINTLIB)

$(LINTLIB):	$(LINTSRC)
	$(CC) -E -C $(CCFLAGS) -Dlint $(LINTSRC) | /usr/lib/lint1 -vx -H./LINT_WORK > $(LINTLIB)
	$(RM) ./LINT_WORK

$(OBJS):
	$(CC) $(CCFLAGS) -c $<
