#	START NEW ARIX SCCS HEADER
#
#	@(#) lib.mk: version 25.1 created on 12/2/91 at 16:21:12
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lib.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:lib/Makefile	1.5"
#
# Makefile for LP private libraries
#
include $(IROOT)/macdefs

DEBUG	=

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

##########
#
# If you add directories other than one level deep
# you'll have to change the code below.
##########
LIBDIRS	= \
		access \
		bsd \
		class \
		filters \
		forms \
		fs \
		lp \
		msgs \
		oam \
		remote \
		requests \
		printers \
		users

all:		libs

install:
	@echo "Not a delivered part of LP - not installed"
	@false

clean:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk clean"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk clean; \
		cd ..; \
	done

clobber:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk clobber"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk clobber; \
		cd ..; \
	done

strip:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk STRIP=$(STRIP) strip"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk STRIP=$(STRIP) strip; \
		cd ..; \
	done

libs:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk; \
		cd ..; \
	done

prof:		plibs

plibs:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk prof"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk prof; \
		cd ..; \
	done

lprof:		qlibs

qlibs:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk lprof"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk lprof; \
		cd ..; \
	done

mdl:		mlibs

mlibs:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk mdl"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk mdl; \
		cd ..; \
	done

lint:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk lint"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk lint; \
		cd ..; \
	done

lintsrc:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk FUNCDLC="$(FUNCDCL)" lintsrc"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk FUNCDLC="$(FUNCDCL)" lintsrc; \
		cd ..; \
	done

lintlib:
	@for dir in $(LIBDIRS); \
	do \
		echo "cd $$dir"; \
		cd $$dir; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$dir.mk lintlib"; \
		$(MAKE) -$(MAKEFLAGS)f $$dir.mk lintlib; \
		cd ..; \
	done
