/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) loadflt.c: version 25.1 created on 12/2/91 at 16:19:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)loadflt.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)nlp:lib/filters/loadfilters.c	1.5"
/* EMACS_MODES: !fill, lnumb, !overwrite, !nodelete, !picture */

#include "stdio.h"
#include "string.h"
#include "errno.h"

#include "lp.h"
#include "filters.h"

extern char		*malloc(),
			*realloc();

extern void		free(),
			qsort();

_FILTER			*filters;

int			nfilters;

static int		getfields(),
			fs_cmp();

/**
 ** loadfilters() - READ FILTERS FROM FILTER TABLE INTO INTERNAL STRUCTURE
 **/

int			loadfilters (file)
	char			*file;
{
	register _FILTER	*pf;

	FILE			*fp;

	char			*filt[FL_MAX],
				buf[BUFSIZ];

	int			nalloc;

	if (filters) {
		nalloc = nfilters;
		trash_filters ();
	} else
		nalloc = FL_MAX_GUESS;

	if (!(fp = open_filtertable(file, "r")))
		return (-1);

	/*
	 * Preallocate space for the internal filter table.
	 * Our guess is the number of filters previously read in,
	 * if any have been read in before (see above).
	 */
	filters = (_FILTER *)malloc((nalloc + 1) * sizeof(_FILTER));
	if (!filters) {
		close_filtertable (fp);
		errno = ENOMEM;
		return (-1);
	}

	for (
		pf = filters, nfilters = 0;
		getfields(fp, filt, buf, BUFSIZ, FL_MAX, FL_SEP) != -1;
		pf++
	) {

		char			**list;

		/*
		 * Allocate more space if needed.
		 */
		if (++nfilters > nalloc) {
			nalloc = nfilters;
			filters = (_FILTER *)realloc(
				filters,
				(nalloc + 1) * sizeof(_FILTER)
			);
			if (!filters) {
				close_filtertable (fp);
				errno = ENOMEM;
				return (-1);
			}
			pf = &filters[nfilters - 1];
		}

#define DFLT(X)	(filt[X] && *filt[X]? filt[X] : NAME_ANY)

		pf->name = strdup(filt[FL_NAME]);
		pf->type = s_to_filtertype(filt[FL_TYPE]);
		pf->command = strdup(filt[FL_CMD]);

		pf->printers = getlist(DFLT(FL_PRTRS), LP_WS, LP_SEP);

		list = getlist(DFLT(FL_PTYPS), LP_WS, LP_SEP);
		pf->printer_types = sl_to_typel(list);
		freelist (list);

		list = getlist(DFLT(FL_ITYPS), LP_WS, LP_SEP);
		pf->input_types = sl_to_typel(list);
		freelist (list);

		list = getlist(DFLT(FL_OTYPS), LP_WS, LP_SEP);
		pf->output_types = sl_to_typel(list);
		freelist (list);

		/*
		 * Note the use of "" instead of LP_WS. The
		 * "sl_to_templatel()" routine will take care
		 * of stripping leading blanks. Stripping trailing
		 * blanks would be nice but shouldn't matter.
		 */

/* quote reason #3 (in "getlist()") */
		list = getlist(filt[FL_TMPS], "", LP_SEP);

/* quote reason #4 (in "s_to_template()") */
		pf->templates = sl_to_templatel(list);
		freelist (list);

	}
	if (ferror(fp)) {
		int			save_errno = errno;

		freefilter (pf);
		close_filtertable (fp);
		errno = save_errno;
		return (-1);
	}
	close_filtertable (fp);

	/*
	 * If we have more space allocated than we need,
	 * return the extra.
	 */
	if (nfilters != nalloc) {
		filters = (_FILTER *)realloc(
			filters,
			(nfilters + 1) * sizeof(_FILTER)
		);
		if (!filters) {
			errno = ENOMEM;
			return (-1);
		}
	}
	filters[nfilters].name = 0;

	/*
	 * Sort the filters, putting ``fast'' filters before
	 * ``slow'' filters. This preps the list for "insfilter()"
	 * so that it can easily pick fast filters over otherwise
	 * equivalent slow filters. This sorting is done every
	 * time we read in the table; one might think that if
	 * "putfilter()" would insert in the correct order then
	 * the table, when written out to disk, would be sorted
	 * already--removing the need to sort it here. We don't
	 * take that approach, because (1) sorting it isn't that
	 * expensive and (2) someone might tamper with the table
	 * file.
	 */
	qsort ((char *)filters, nfilters, sizeof(_FILTER), fs_cmp);

	return (0);
}

/**
 ** getfields() - PARSE NON-COMMENT LINE FROM FILE INTO FIELDS
 **/

static int		getfields (fp, fields, buf, bufsiz, max, seps)
	FILE			*fp;
	char			*fields[];
	register char		*buf;
	int			bufsiz,
				max;
	register char		*seps;
{
	register char		*p,
				*q;

	register int		n	= 0;

	while (fgets(buf, bufsiz, fp) != NULL) {
		buf[strlen(buf) - 1] = 0;
		p = buf + strspn(buf, " \t");
		if (*p && *p != '#') {
			for (fields[n++] = q = p; *p; ) {
				if (*p == '\\') {
					if (
/* quote reason #1 */				p[1] == '\\'
/* quote reason #2 */			     || strchr(seps, p[1])
					)
						p++;
					*q++ = *p++;
				} else if (strchr(seps, *p)) {
					*q++ = 0;
					p++;
					if (n < max)
						fields[n++] = q;
				} else
					*q++ = *p++;
			}
			*q = 0;
			while (n < max)
				fields[n++] = "";
			return (n);
		}
	}
	return (-1);
}

/**
 ** fs_cmp() - COMPARE TWO FILTERS BY "FILTERTYPE"
 **/

static int		fs_cmp (pfa, pfb)
	_FILTER			*pfa,
				*pfb;
{
	if (pfa->type == pfb->type)
		return (0);
	else if (pfa->type == fl_fast)
		return (-1);
	else
		return (1);
}
