#	START NEW ARIX SCCS HEADER
#
#	@(#) filters.mk: version 25.1 created on 12/2/91 at 16:19:29
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)filters.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:lib/filters/Makefile	1.3"
#
# Makefile for filtermgmt(lp) routines
#
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

DEBUG	=	-g

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

INC	=	$(ROOT)/usr/include
LPINC	=	../../include

CCFLAGS	=	$(CFLAGS) -I$(LPINC)

LIBRARY	=	liblpflt.a
PLIBRARY=	p$(LIBRARY)
QLIBRARY=	q$(LIBRARY)

LINTSRC	=	llib-llpflt
LINTLIB	=	$(LINTSRC).ln

SRCS	= \
		conv.c \
		delfilter.c \
		dumpfilt.c \
		freefilter.c \
		getfilter.c \
		filtertbl.c \
		insfilter.c \
		loadflt.c \
		putfilter.c \
		search.c \
		trash.c

LINTS	= \
		../lp/llib-llp.ln

OBJS	=	$(SRCS:.c=.o)
POBJS	=	$(SRCS:.c=.p)
QOBJS	=	$(SRCS:.c=.q)

.SUFFIXES:	.o .p .q
.c.p:
	@-if [ -f $*.o ] ; then mv $*.o tmp ; fi
	$(CC) -p $(CCFLAGS) -c $*.c
	@-mv $*.o $*.p
	@-if [ -f tmp ] ; then mv tmp $*.o ; fi

.c.q:
	@-if [ -f $*.o ] ; then mv $*.o tmp ; fi
	$(CC) -ql $(CCFLAGS) -c $*.c
	@-mv $*.o $*.q
	@-if [ -f tmp ] ; then mv tmp $*.o ; fi

#all:		$(LIBRARY) $(LINTLIB)
all:		$(LIBRARY)

install:	all
	@echo "Not a delivered part of LP - not installed"
	@false

clean:
	$(RM) $(OBJS) $(POBJS) $(QOBJS) *.o core

clobber:	clean
	$(RM) $(LIBRARY) $(PLIBRARY) $(QLIBRARY) $(LINTLIB) *.a

strip:
	$(STRIP) $(LIBRARY)

$(LIBRARY):	$(OBJS)
	$(AR) rv $(LIBRARY) $?

prof:		$(PLIBRARY)

$(PLIBRARY):	$(POBJS)
	$(AR) rv $(PLIBRARY) $?

lprof:		$(QLIBRARY)

$(QLIBRARY):	$(QOBJS)
	$(AR) rv $(QLIBRARY) $?

lint:
	lint -ux $(CCFLAGS) $(SRCS) $(LINTS)

lintsrc:	$(LINTSRC)

$(LINTSRC):	$(SRCS)
	if [ -n "$(FUNCDCL)" ]; then $(FUNCDCL) $(SRCS) >$(LINTSRC); fi

lintlib:	$(LINTLIB)

$(LINTLIB):	$(LINTSRC)
	$(CC) -E -C $(CCFLAGS) -Dlint $(LINTSRC) | /usr/lib/lint1 -vx -H./LINT_WORK > $(LINTLIB)
	$(RM) ./LINT_WORK

$(OBJS):
	$(CC) $(CCFLAGS) -c $<
