/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) syslog.c: version 25.1 created on 12/2/91 at 16:18:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)syslog.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	This facility attempts to replace the BSD facility.
 *	NOT ALL FEATURES ARE IMPLEMENTED.
 */

#ident	"@(#)syslog.c	25.1"

#include "sys/types.h"
#include "syslog.h"
#include "string.h"
#include "stdio.h"
#include "time.h"
#include "unistd.h"
#include "fcntl.h"

#define	DEF_LOG		"/usr/adm/syslog"
#define	DEF_LOG1	"/dev/console"

static char	*Ident = NULL;
static int	Options;

extern char	*strdup();

/*ARGSUSED*/
openlog(ident, logopt, facility)
	char *ident;
	int logopt, facility;
{
	if (Ident != NULL)
		free(Ident);

	Ident = strdup(ident);
	Options = logopt;
}

#ifdef	__STDC__
#  include "stdarg.h"
#else
#  include "varargs.h"
#endif

/*
 * Open the logfile every time so we have a much greater
 * chance of appending to the file
 */
/*VARARGS*/
#ifdef	__STDC__
syslog(int priority, char *message, ...)
#else
syslog(va_alist)
	va_dcl
#endif
{
	register char	*p, *q;
	char	buf[BUFSIZ], buf1[BUFSIZ];
	char	*date;
	int	col = 0, fd = -1;
	time_t	clock;
	struct flock flock;
	va_list	ap;
#ifndef	__STDC__
	int	priority;
	char	*message;
#endif
	extern	int errno, sys_nerr;
	extern	char *sys_errlist[];

#ifdef	__STDC__
	va_start(ap, message);
#else
	va_start(ap);
	priority = va_arg(ap, int);
	message = va_arg(ap, char *);
#endif
	/*
	 * This loop only replaces the first %m
	 */
	for (p = strchr(message, '%'); p != NULL; q = p, p = strchr(q, '%'))
	{
		if (*(++p) != 'm')	/* increment so %% works */
			continue;

		col = p - message - 1;
		(void) strncpy(buf, message, col);
		buf[col] = '\0';
		(void) sprintf(&buf[col], "%s", errno < sys_nerr
				? sys_errlist[errno] : "Unknown error");
		(void) strcat(&buf[col], ++p);
		break;
	}

	if (p == NULL)
		(void) vsprintf(buf1, message, ap);
	else
		(void) vsprintf(buf1, buf, ap);

	va_end(ap);

	if ((fd = open(DEF_LOG, O_WRONLY | O_APPEND)) < 0)
		if ((fd = open(DEF_LOG1, O_WRONLY | O_APPEND)) < 0)
		{
			return;
		}

	flock.l_type = F_WRLCK;
	flock.l_whence = SEEK_SET;
	flock.l_start = 0;
	flock.l_len = 0;
	if (fcntl(fd, F_SETLKW, &flock) < 0)
	{
		(void) close(fd);
		return;
	}

	clock = time((time_t *) 0);
	date = ctime(&clock);
	date[19] = '\0';
	(void) sprintf(buf, "<%d> %s %s[%d]: ",
			priority, &date[4], Ident, getpid());
	(void) strcat(buf, buf1);

	col = strlen(buf);
	(void) write(fd, buf, col);
	if (buf[col-1] != '\n')
		(void) write(fd, "\n", 1);
	(void) close(fd);
}

closelog()
{
}
