#	START NEW ARIX SCCS HEADER
#
#	@(#) filter.mk: version 25.1 created on 12/2/91 at 16:49:32
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)filter.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:filter/Makefile	1.3"
#
# Makefile for lp/filter
#
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

USRLIB	=	$(ROOT)/usr/lib
USRSPOOL=	$(ROOT)/usr/spool

BINDIR	=	$(USRSPOOL)/lp/bin

DEBUG	=	-g

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

INC	=	$(ROOT)/usr/include
LPINC	=	../include

CCFLAGS	=	-I$(LPINC) $(CFLAGS)
LIBDIR	=	../lib

LIBACC	=	$(LIBDIR)/access/liblpacc.a
LIBCLS	=	$(LIBDIR)/class/liblpcls.a
LIBFLT	=	$(LIBDIR)/filters/liblpflt.a
LIBFRM	=	$(LIBDIR)/forms/liblpfrm.a
LIBFS	=	$(LIBDIR)/fs/liblpfs.a
LIBLP	=	$(LIBDIR)/lp/liblp.a
LIBMSG	=	$(LIBDIR)/msgs/liblpmsg.a
LIBOAM	=	$(LIBDIR)/oam/liblpoam.a
LIBPRT	=	$(LIBDIR)/printers/liblpprt.a
LIBREQ	=	$(LIBDIR)/requests/liblpreq.a
LIBUSR	=	$(LIBDIR)/users/liblpusr.a

LINTACC	=	$(LIBDIR)/access/llib-llpacc.ln
LINTCLS	=	$(LIBDIR)/class/llib-llpcls.ln
LINTFLT	=	$(LIBDIR)/filters/llib-llpflt.ln
LINTFRM	=	$(LIBDIR)/forms/llib-llpfrm.ln
LINTFS	=	$(LIBDIR)/fs/llib-llpfs.ln
LINTLP	=	$(LIBDIR)/lp/llib-llp.ln
LINTMSG	=	$(LIBDIR)/msgs/llib-llpmsg.ln
LINTOAM	=	$(LIBDIR)/oam/llib-llpoam.ln
LINTPRT	=	$(LIBDIR)/printers/llib-llpprt.ln
LINTREQ	=	$(LIBDIR)/requests/llib-llpreq.ln
LINTUSR	=	$(LIBDIR)/users/llib-llpusr.ln

SRCS	= \
		5310.c \
		hp2631a.c \
		pprx.c \
		prx.c

OBJS	=	$(SRCS:.c=.o)

CMDS	= \
		5310 \
		hp2631a \
		pprx \
		prx

MISC	= \
		slow.filter

all:		$(CMDS) $(MISC)

install:	all
	@for cmd in $(CMDS); do \
		echo "\t$(INS)  $$cmd 	$(USRLIB)/$$cmd"; \
		$(INS)  $$cmd 	$(USRLIB)/$$cmd; \
		echo "\tchmod	0555	$(USRLIB)/$$cmd"; \
		chmod	0555	$(USRLIB)/$$cmd; \
		echo "\tchown	lp	$(USRLIB)/$$cmd"; \
		chown	bin	$(USRLIB)/$$cmd; \
		echo "\tchgrp 	bin	$(USRLIB)/$$cmd"; \
		chgrp 	bin	$(USRLIB)/$$cmd; \
	done
	@for misc in $(MISC); do \
		echo "\t$(INS)  $$misc 	$(BINDIR)/$$misc"; \
		$(INS) 	$$misc	$(BINDIR)/$$misc; \
		echo "\tchmod	0555	$(BINDIR)/$$misc"; \
		chmod 	0555 	$(BINDIR)/$$misc; \
		echo "\tchown	bin	$(BINDIR)/$$misc"; \
		chown	bin 	$(BINDIR)/$$misc; \
		echo "\tchgrp 	bin	$(BINDIR)/$misccmd"; \
		chgrp	bin	$(BINDIR)/$$misc; \
	done

5310:		5310.o
	$(CC) -o 5310 5310.o $(LDFLAGS) $(LIBS)

5310.o:		5310.c
	$(CC) $(CCFLAGS) -c 5310.c

hp2631a:	hp2631a.o
	$(CC) -o hp2631a hp2631a.o $(LDFLAGS) $(LIBS)

hp2631a.o:	hp2631a.c
	$(CC) $(CCFLAGS) -c hp2631a.c

prx:		prx.o
	$(CC) -o prx prx.o $(LDFLAGS) $(LIBS)

prx.o:		prx.c
	$(CC) $(CCFLAGS) -c prx.c

pprx:		pprx.o
	$(CC) -o pprx pprx.o $(LDFLAGS) $(LIBS)

pprx.o:		pprx.c
	$(CC) $(CCFLAGS) -c pprx.c 

lint:
	lint $(CCCFLAGS) 5310.c
	lint $(CCCFLAGS) hp2631a.c
	lint $(CCCFLAGS) pprx.c
	lint $(CCCFLAGS) prx.c

strip:
	$(STRIP) $(CMDS)

clean:
	$(RM) $(OBJS) core a.out

clobber:	clean
	$(RM) $(CMDS)
