/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) request.c: version 25.1 created on 12/2/91 at 16:26:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)request.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "stdio.h"
#include "errno.h"
#include "pwd.h"
#include "sys/types.h"
#include "lp.h"
#include "printers.h"
#include "class.h"
#include "msgs.h"
#include "requests.h"
#define WHO_AM_I	I_AM_LP
#include "oam.h"

extern char		*sys_errlist[];
extern int		sys_nerr;

/**
 ** do_request()
 **/

int			do_request (list, option)
	char			**list; int option;
{
	while (*list) {
		if (STREQU(NAME_ALL, *list)) {
			send_message (S_INQUIRE_REQUEST, "", "", "", "", "");
			(void)output (R_INQUIRE_REQUEST, option);

		} else if (isrequest(*list)) {
			send_message (S_INQUIRE_REQUEST, "", "", *list, "", "");
			switch (output(R_INQUIRE_REQUEST, option)) {
			case MOK:
				return(1);
				break;
			case MOKMORE:
				return (1);
				break;
			default:
		/*		LP_ERRMSG1 (ERROR, E_STAT_DONE, *list); */
				return(0);	
				break;
			}

		} else {
			send_message (S_INQUIRE_REQUEST, "", *list, "", "", "");
			switch (output(R_INQUIRE_REQUEST, option)) {
			case MNOINFO:
				if (!isprinter(*list) && !isclass(*list)) {
					LP_ERRMSG1(ERROR,E_STAT_BADSTAT, *list);
					return(0);	
				}
				break;
			}

		}
		list++;
	}
	return(1);
}



/**
 ** output() - RECEIVE MESSAGE BACK FROM SPOOLER, PRODUCE OUTPUT
 **/

int			output (type, option)
	int			type, option;
{
	char			buffer[MSGMAX];

	int			rc;
	int			uid;
	struct passwd		*pw;	
	char			*class,
				*user,
				*reject_reason,
				*request_id,
				*printer,
				*form,
				*character_set,
				*disable_reason;

	short			printer_status,
				class_status,
				state,
				status;

	long			size,
				enable_date,
				reject_date,
				date;

	ushort	RUid, Lp_Uid;

	status = MOKMORE;
	while (status == MOKMORE) {

			if ((rc = mrecv(buffer, MSGMAX)) != type) {
				if (rc == -1 && errno == EIDRM)
				LP_ERRMSG (ERROR, E_LP_MRECV);
			else
				LP_ERRMSG1 (ERROR, E_LP_BADREPLY, rc);
	
			return(MNOINFO);	
		}

		switch(type) {

		case R_INQUIRE_REQUEST:
			if (getmessage(
				buffer,
				R_INQUIRE_REQUEST,
				&status,
				&request_id,
				&user,
				&size,
				&date,
				&state,
				&printer,
				&form,
				&character_set
			) == -1) {
				LP_ERRMSG1 (
					ERROR, 
					E_LP_GETMSG,
			(errno < sys_nerr? sys_errlist[errno]: "unknown")
				);
				return(status);	
			}

			switch (status) {

			case MOK:
			case MOKMORE:
				break;
			}
			break;
		}
	}

	switch (status) {

	case MOK:	
	case MNOINFO:
	case MNODEST:
	case MUNKNOWN:
		uid=getuid();
		setpwent();
		pw=getpwnam("root");
		RUid= pw->pw_uid;
		pw=getpwnam(LPUSER);
		Lp_Uid=pw->pw_uid;
	 	pw=getpwnam(user);
		endpwent();

		if (option==CKADMIN)
		  if ((state & RS_ADMINHELD) && (uid != RUid) && (uid!=Lp_Uid))
		    status=MNOPERM;
		if (option==CKPERM)
		  {
		    setpwent();
		    pw=getpwnam(user);
		    endpwent();
		    if ((uid != RUid) && (uid != Lp_Uid) && (uid != pw->pw_uid))
		    status=MNOPERM;
		  }
		return (status);

	default:	/* we are lost */
		LP_ERRMSG1 (ERROR, E_LP_BADSTATUS, status);
		return(status);	

	}
}
