#	START NEW ARIX SCCS HEADER
#
#	@(#) lpstat.mk: version 25.1 created on 12/2/91 at 16:16:42
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lpstat.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:cmd/lpstat/Makefile	1.5"
#
# Makefile for the lpstat command
#
include $(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

FUNCDCL	=

USRBIN	=	$(ROOT)/usr/bin

DEBUG	=	-g -DDEBUG

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

INC	=	$(ROOT)/usr/include
LPINC	=	../../include

LOCAL_CFLAGS	=	-I$(LPINC) 

LIBDIR	=	../../lib
LIBNET  =   -L../.. $(LIBDIR)/bsd/libbsd.a -lnet

LIBACC	=	$(LIBDIR)/access/liblpacc.a
LIBCLS	=	$(LIBDIR)/class/liblpcls.a
LIBFLT	=	$(LIBDIR)/filters/liblpflt.a
LIBFRM	=	$(LIBDIR)/forms/liblpfrm.a
LIBFS	=	$(LIBDIR)/fs/liblpfs.a
LIBLP	=	$(LIBDIR)/lp/liblp.a
LIBMSG	=	$(LIBDIR)/msgs/liblpmsg.a
LIBOAM	=	$(LIBDIR)/oam/liblpoam.a
LIBPRT	=	$(LIBDIR)/printers/liblpprt.a
LIBREQ	=	$(LIBDIR)/requests/liblpreq.a
LIBRMT	=	$(LIBDIR)/remote/liblprmt.a
LIBUSR	=	$(LIBDIR)/users/liblpusr.a

LINTACC	=	$(LIBDIR)/access/llib-llpacc.ln
LINTCLS	=	$(LIBDIR)/class/llib-llpcls.ln
LINTFLT	=	$(LIBDIR)/filters/llib-llpflt.ln
LINTFRM	=	$(LIBDIR)/forms/llib-llpfrm.ln
LINTFS	=	$(LIBDIR)/fs/llib-llpfs.ln
LINTLP	=	$(LIBDIR)/lp/llib-llp.ln
LINTMSG	=	$(LIBDIR)/msgs/llib-llpmsg.ln
LINTOAM	=	$(LIBDIR)/oam/llib-llpoam.ln
LINTPRT	=	$(LIBDIR)/printers/llib-llpprt.ln
LINTREQ	=	$(LIBDIR)/requests/llib-llpreq.ln
LINTRMT	=	$(LIBDIR)/remote/llib-llprmt.ln
LINTUSR	=	$(LIBDIR)/users/llib-llpusr.ln

SRCS	= \
		accept.c \
		add_mnt.c \
		charset.c \
		class.c \
		device.c \
		done.c \
		form.c \
		lpstat.c \
		output.c \
		parse.c \
		printer.c \
		request.c \
		send_mess.c

OBJS	=	$(SRCS:.c=.o)

all:		lpstat

install:	all
	$(INS) 	lpstat	$(USRBIN)/lpstat
	chmod	6755	$(USRBIN)/lpstat
	chown	lp	$(USRBIN)/lpstat
	chgrp	bin	$(USRBIN)/lpstat

clean:
	$(RM) $(OBJS)

clobber:	clean
	$(RM) lpstat

strip:
	$(STRIP) lpstat


do_printer.o:	lpstat.h do_printer.c

do_getpr.o:	lpstat.h do_getpr.c

dolist.o:	lpstat.h dolist.c

form.o:		lpstat.h form.c

lpstat.o:	lpstat.h lpstat.c

output.o:	lpstat.h output.c

parse.o:	lpstat.h parse.c

lpstat:	$(OBJS) \
			$(LIBACC) \
			$(LIBFRM) \
			$(LIBCLS) \
			$(LIBMSG) \
			$(LIBPRT) \
			$(LIBOAM) \
			$(LIBLP) \
			$(LIBRMT) \
			$(LIBFS)
	$(CC) -o lpstat $(OBJS) $(CFLAGS) $(LDFLAGS) \
			$(LIBACC) \
			$(LIBFRM) \
			$(LIBCLS) \
			$(LIBMSG) \
			$(LIBPRT) \
			$(LIBOAM) \
			$(LIBLP) \
			$(LIBRMT) \
			$(LIBFS) \
				-lPW \
				-lsec \
				-lcurses \
					$(LIBNET)


lint:
	lint $(CFLAGS) $(SRCS) \
			$(LINTACC) \
			$(LINTFRM) \
			$(LINTCLS) \
			$(LINTMSG) \
			$(LINTPRT) \
			$(LINTOAM) \
			$(LINTLP) \
			$(LINTFS)

$(OBJS):
	$(CC) $(CFLAGS) -c $<
