/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) remote.c: version 25.1 created on 12/2/91 at 16:15:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)remote.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */
/*
 * Much of this file is based on lpr.c
 */

#ident	"@(#)remote.c	25.1"

#include "lpsched.h"
#include "sys/stat.h"
#include "sys/utsname.h"
#include "syslog.h"
#include "netdb.h"
#include "lpd.local.h"

#define Done(EC,ERRNO)	done(((EC) << 8),ERRNO)

char    *tfname;		/* tmp copy of cf before linking */
char    *cfname;		/* daemon control files, linked from tf's */
char    *dfname;		/* data files */

int	nact;			/* number of jobs to act on */
int	tfd;			/* control file descriptor */
int     mailflg;		/* send mail */
char	format = 'f';		/* format char for printing files */
int	rflag;			/* remove files upon completion */	
int	inchar;			/* location to increment char in file names */
int     ncopies = 1;		/* # of copies to make */
int	iflag;			/* indentation wanted */
int	indent;			/* amount to indent */
int	hdr = 1;		/* print header or not (default is yes) */
int     userid;			/* user id */
char	*person;		/* user name */
char	*title;			/* pr'ing title */
char	*fonts[4];		/* troff font names */
char	*width;			/* width for versatec printing */
char	host[32];		/* host name */
char	*class = host;		/* class title on header page */
char    *jobname;		/* job name on header page */

int	MX;			/* maximum number of blocks to copy */
int	MC;			/* maximum number of copies allowed */
int	DU;			/* daemon user-id */
char	*SD;			/* spool directory */
char	*LO;			/* lock file name */
char	*RG;			/* restrict group */
char	*LP;			/* local port */
char	*RM;			/* remote machine */
char	*RP;			/* remote printer */
short	SC;			/* suppress multiple copies */

static int	cleanup();
extern void	done();

int
sendremote(printer, request)
	PSTATUS *printer;
	RSTATUS *request;
{
	register char **listp, *p;
	char buf[BUFSIZ];
	int i;

	openlog("lpsched", LOG_PID, LOG_LPR);
	Gethostname(host, sizeof (host));
	chk_printer(printer->printer->name);
	mktemps();
	tfd = nfile(tfname);
	(void) chown(tfname, DU, 0);	/* owned by daemon for protection */
	card('H', host);
	card('P', request->request->user);

	/*
	 * Try to choose the "best" jobname
	 */
	if (request->request->title) {
		jobname = request->request->title;
	}
	else if (*(request->request->file_list)) {
		if ((p = strrchr(*(request->request->file_list), '/')) != NULL)
		{
			(void) strcpy(buf, ++p);
			jobname = buf;
		}
		else
			jobname = *(request->request->file_list);
	}
	else {
		jobname = request->secure->req_id;
	}
	card('J', jobname);

	card('L', request->request->user);

	/* card('C', class); */
	/* if (mailflg)
	 *	card('M', person);
	 */
	/* card('W', width); */

	ncopies = request->request->copies;

	/*
	 * Read the files and spool them.
	 */
	for (listp = request->request->file_list; *listp; listp++) {
		if ((i = open(*listp, O_RDONLY)) < 0) {
			syslog(LOG_WARNING, "cannot open %s\n", *listp);
			continue;
		}
		copy(i, *listp);
		(void) close(i);
	}

	if (nact) {
		(void) close(tfd);
		tfname[inchar]--;
		/*
		 * Touch the control file to fix position in the queue.
		 */
		if ((tfd = open(tfname, O_RDWR)) >= 0) {
			char c;

			if (read(tfd, &c, 1) == 1 && lseek(tfd, 0L, 0) == 0 &&
			    write(tfd, &c, 1) != 1) {
				syslog(LOG_ERR, "cannot touch %s\n", tfname);
				tfname[inchar]++;
				cleanup(EXEC_EXIT_NOPEN, errno);
			}
			(void) close(tfd);
		}
		if (link(tfname, cfname) < 0) {
			syslog(LOG_ERR, "cannot rename %s\n", cfname);
			tfname[inchar]++;
			cleanup(EXEC_EXIT_NOPEN, errno);
		}
		(void) unlink(tfname);
		if (!startdaemon(printer->printer->name))
			syslog(LOG_WARNING,
				"jobs queued, but cannot start daemon.\n");

		Done(EXEC_EXIT_OKAY, 0);
	}
	cleanup(EXEC_EXIT_OKAY, 0);
	/* NOTREACHED */
}

/*
 * Create the file n and copy from file descriptor f.
 */
copy(f, n)
	int f;
	char n[];
{
	register int fd, i, nr, nc;
	char buf[BUFSIZ];

	for (i = 0; i < ncopies; i++)
		card(format, &dfname[inchar-2]);
	card('U', &dfname[inchar-2]);
	card('N', n);
	fd = nfile(dfname);
	nr = nc = 0;
	while ((i = read(f, buf, BUFSIZ)) > 0) {
		if (write(fd, buf, i) != i) {
			syslog(LOG_ERR, "%s: temp file write error\n", n);
			break;
		}
		nc += i;
		if (nc >= BUFSIZ) {
			nc -= BUFSIZ;
			nr++;
			if (MX > 0 && nr > MX) {
				syslog(LOG_ERR,
					"%s: copy file is too large\n", n);
				break;
			}
		}
	}
	(void) close(fd);
	if (nc==0 && nr==0) 
		syslog(LOG_WARNING, "%s: empty input file\n",
				f ? n : "stdin");
	else
		nact++;
}

/*
 * Put a line into the control file.
 */
card(c, p2)
	register char c, *p2;
{
	char buf[BUFSIZ];
	register char *p1 = buf;
	register int len = 2;

	*p1++ = c;
	while ((c = *p2++) != '\0') {
		*p1++ = c;
		len++;
	}
	*p1++ = '\n';
	write(tfd, buf, len);
}

/*
 * Create a new file in the spool directory.
 */
nfile(n)
	char *n;
{
	register f;
	int oldumask = umask(0);		/* should block signals */

	f = creat(n, 0640);
	if (f < 0) {
		syslog(LOG_ERR, "cannot create %s\n", n);
		cleanup(EXEC_EXIT_NOPEN, errno);
	}
	(void) umask(oldumask);
	if (chown(n, userid, 0) < 0) {
		syslog(LOG_ERR, "cannot chown %s\n", n);
		cleanup(EXEC_EXIT_NOPEN, errno);
	}
	if (++n[inchar] > 'z') {
		if (++n[inchar-2] == 't') {
			syslog(LOG_ERR, "too many files - break up the job\n");
			cleanup(EXEC_EXIT_NOPEN, EMFILE);
		}
		n[inchar] = 'A';
	} else if (n[inchar] == '[')
		n[inchar] = 'a';
	return(f);
}

/*
 * Cleanup after interrupts and errors.
 */
static
cleanup(code, errnum)
	int code;
	int errnum;
{
	register i;

	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	i = inchar;
	if (tfname)
		do
			unlink(tfname);
		while (tfname[i]-- != 'A');
	if (cfname)
		do
			unlink(cfname);
		while (cfname[i]-- != 'A');
	if (dfname)
		do {
			do
				unlink(dfname);
			while (dfname[i]-- != 'A');
			dfname[i] = 'z';
		} while (dfname[i-2]-- != 'd');
	Done(code, errnum);
}

/*
 * Perform lookup for printer name or abbreviation --
 */
chk_printer(s)
	char *s;
{
	int status;
	char buf[BUFSIZ];
	static char pbuf[BUFSIZ/2];
	char *bp = pbuf;
	extern char *pgetstr();

	if ((status = pgetent(buf, s)) < 0) {
		fatal(EXEC_EXIT_NOPEN, errno,
			"cannot open printer description file");
	}
	else if (status == 0)
		fatal(EXEC_EXIT_NPORT, ENOENT, "%s: unknown printer", s);
	if ((SD = pgetstr("sd", &bp)) == NULL)
		SD = DEFSPOOL;
	if ((LO = pgetstr("lo", &bp)) == NULL)
		LO = DEFLOCK;
	RG = pgetstr("rg", &bp);
	if ((MX = pgetnum("mx")) < 0)
		MX = DEFMX;
	if ((MC = pgetnum("mc")) < 0)
		MC = DEFMAXCOPIES;
	if ((DU = pgetnum("du")) < 0)
		DU = DEFUID;
	SC = pgetflag("sc");
	if ((LP = pgetstr("lp", &bp)) == NULL)
		LP = DEFDEVLP;
	RM = pgetstr("rm", &bp);
	if ((RP = pgetstr("rp", &bp)) == NULL)
		RP = DEFLP;

	if (RM != (char *) NULL) {
		char *name;
		struct utsname utsname;
		struct hostent *hp;

		uname(&utsname);

		/* get the standard network name of the local host */
		hp = gethostbyname(utsname.nodename);
		if (hp != (struct hostent *) NULL)
			name = strdup(hp->h_name);
		else
			name = strdup(utsname.nodename);

		/* get the standard network name of RM */
		hp = gethostbyname(RM);
		if (hp != (struct hostent *) NULL) {
			/* if printer is not on local machine, ignore LP */
			if (strcmp(name, hp->h_name) != 0)
				*LP = '\0';
		}

		free(name);
	}
}

/*
 * Make the temp files.
 */
mktemps()
{
	register int c, len, fd, n;
	register char *cp;
	char buf[BUFSIZ];
	struct flock	exlock;
	extern char *mktemp();

	(void) sprintf(buf, "%s/.seq", SD);
	if ((fd = open(buf, O_RDWR|O_CREAT, 0661)) < 0) {
		syslog(LOG_ERR, "cannot create %s\n", buf);
		Done(EXEC_EXIT_NOPEN, errno);
	}

	exlock.l_type = F_WRLCK;
	exlock.l_whence = SEEK_SET;
	exlock.l_start = 0;
	exlock.l_len = 0;
	if (fcntl(fd, F_SETLK, &exlock)) {
		syslog(LOG_ERR, "cannot lock %s\n", buf);
		Done(EXEC_EXIT_NOPEN, errno);
	}
	n = 0;
	if ((len = read(fd, buf, sizeof(buf))) > 0) {
		for (cp = buf; len--; ) {
			if (*cp < '0' || *cp > '9')
				break;
			n = n * 10 + (*cp++ - '0');
		}
	}
	len = strlen(SD) + strlen(host) + 8;
	tfname = mktemp("tf", n, len);
	cfname = mktemp("cf", n, len);
	dfname = mktemp("df", n, len);
	inchar = strlen(SD) + 3;
	n = (n + 1) % 1000;
	(void) lseek(fd, 0L, 0);
	sprintf(buf, "%03d\n", n);
	(void) write(fd, buf, strlen(buf));
	(void) close(fd);	/* unlocks as well */
}

/*
 * Make a temp file name.
 */
char *
mktemp(id, num, len)
	char	*id;
	int	num, len;
{
	register char *s;

	if ((s = malloc(len)) == NULL)
		fatal(EXEC_EXIT_NOMEM, ENOMEM, "out of memory");

	(void) sprintf(s, "%s/%sA%03d%.8s", SD, id, num, host);
	return(s);
}

/*VARARGS1*/
static
fatal(code, errnum, msg, a1, a2, a3)
	char *msg;
{
	syslog(LOG_ERR, msg, a1, a2, a3);
	Done(code, errnum);
}
