/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) disp1.c: version 25.1 created on 12/2/91 at 16:13:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)disp1.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@(#)nlp:cmd/lpsched/disp1.c	1.11" */
#ident	"@(#)disp1.c	25.1"

#include "sys/utsname.h"
#include "tiuser.h"
#include "ctype.h"
#include "dispatch.h"

void			endpwent();

RSTATUS			*NewRequest;
RSTATUS			*Found;
char			*Printer;
/*
char *debug1file="/tmp/debug";
FILE  *fp1;
*/
/**
 ** alloc_files() - S_ALLOC_FILES
 **/

void
alloc_files (m,n)
char			*m;
NODE			*n;
{
    char			*file_prefix;
    ushort			count;

    getmessage (m, S_ALLOC_FILES, &count);

    if ((file_prefix = _alloc_files(count, (char *)0, n->uid, n->gid)))
    {
	send (n, R_ALLOC_FILES, MOK, file_prefix);
	add_flt_act(n, FLT_FILES, file_prefix, count);
    }
    else
	send (n, R_ALLOC_FILES, MNOMEM, "");

    return;
}

/**
 ** print_request() - S_PRINT_REQUEST
 **/

void
print_request (m,n)
	char			*m;
	NODE			*n;
{
    extern char			*Local_System;
    extern struct passwd	*getpwuid();
    extern long			time();
    char			*file;
    char			*p;
    char			*req_id	= 0;
    RSTATUS			*rp;
    REQUEST			*r;
    struct passwd		*pw;
    short			err;
    short			status;
    off_t			size;


	openlog("lpsched", 0, 0);
    (void) getmessage (m, S_PRINT_REQUEST, &file);

    /*
     * "NewRequest" points to a request that's not yet in the
     * request list but is to be considered with the rest of the
     * requests (e.g. calculating # of requests awaiting a form).
     */
    if (!(rp = NewRequest = allocr()))
	status = MNOMEM;

    else
    {
	p = makepath(Lp_Temp, file, (char *)0);
	(void) Chmod(p, 0600);
	(void) Chown(p, Lp_Uid, Lp_Gid);
	free(p);
    
	if (!(r = Getrequest(file)))
	    status = MNOOPEN;
    
	else
	{
	    *(rp->request) = *r;
	    rp->request->outcome = 0;
	    rp->secure->uid = n->uid;
	    rp->secure->gid = n->gid;
	    rp->req_file = strdup(file);
    
	    if (!STREQU(n->system, Local_System))
		rp->secure->system = strdup(n->system);

	    pw = getpwuid(n->uid);
	    endpwent();
	    if (pw && pw->pw_name && *pw->pw_name)
		rp->secure->user = strdup(pw->pw_name);
	    else
	    {
#define BIGGEST "65536"		/* the biggest 16-bit number */
		rp->secure->user = strdup(BIGGEST);
		sprintf (rp->secure->user, "%d", (n->uid & 0xFFFF));
	    }

	    if ((rp->request->actions & ACT_SPECIAL) == ACT_HOLD)
		rp->request->outcome |= RS_HELD;
	    if ((rp->request->actions & ACT_SPECIAL) == ACT_RESUME)
		rp->request->outcome &= ~RS_HELD;
	    if((rp->request->actions & ACT_SPECIAL) == ACT_IMMEDIATE)
	    {
		if (!isadmin(n->uid))
		{
		    status = MNOPERM;
		    goto Return;
		}
		rp->request->outcome |= RS_IMMEDIATE;
	    }
    
	    size = chfiles(rp->request->file_list, Lp_Uid, Lp_Gid);
	    if (size < 0)
	    {
		status = MUNKNOWN;
		goto Return;
	    }
	    if (!(rp->request->outcome & RS_HELD) && size == 0)
	    {
		status = MNOPERM;
		goto Return;
	    }
	    rp->secure->size = size;
    
	    (void) time(&rp->secure->date);
    
	    if((err = validate_request(rp, &req_id, 0)) != MOK) {
		status = err;
		}
	    else
	    {
		if (p = strchr(file, '-'))
		    *p = '\0';
		req_id = makestr(req_id, "-", file, (char *)0);
		rp->secure->req_id = req_id;
		if (p)
		    *p = '-';
    
		if (
		    putsecure(file, rp->secure) == -1
		 || putrequest(file, rp->request) == -1
		)
		    status = MNOMEM;

		else
		{
		    status = MOK;
		    insertr(rp);
		    NewRequest = 0;
    
		    if (rp->slow)
			schedule (EV_SLOWF, rp);
		    else
			schedule (EV_INTERF, rp->printer);

		    del_flt_act(n, FLT_FILES);
		}
	    }
	}
    }

Return:
    NewRequest = 0;
    if (status != MOK && rp)
    {
	rmfiles(rp, 0);
	freerstatus(rp);
    }
    send(n, R_PRINT_REQUEST, status, NB(req_id), chkprinter_result);
    return;
}

/**
 ** start_change_request()
 **/

void
start_change_request (m,n)
	char			*m;
	NODE			*n;
{
    char		*req_id;
    char		*req_file;
    char		*path;
    short		status;
    RSTATUS		*rp;
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start: enter\n");
	close_lpfile(fp1);
*/
    (void) getmessage(m, S_START_CHANGE_REQUEST, &req_id);

    if (!(rp = request_by_id(req_id)))
{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:MUNKNOWN\n");
	close_lpfile(fp1);
*/
	status = MUNKNOWN;
	req_file = "";				/* shen 11/1/89 */
}
    else if (rp->request->outcome & RS_DONE)
{ 
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:M2LATE\n");
	close_lpfile(fp1);
*/
	status = M2LATE;
	req_file = rp->req_file;

}
    else if (n->uid && n->uid != Lp_Uid && n->uid != rp->secure->uid)
{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:MNOPERM 1\n");
	close_lpfile(fp1);
*/
	status = MNOPERM;
	req_file = rp->req_file;
}

    else if (rp->request->outcome & RS_CHANGING)
{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:MNOOPEN\n");
	close_lpfile(fp1);
*/
	status = MNOOPEN;
	req_file = rp->req_file;
 }   
    else if (rp->request->outcome & RS_NOTIFYING)
{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:MBUSY\n");
	close_lpfile(fp1);
*/
	status = MBUSY;
	req_file = rp->req_file;
}

    else
    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:MOK\n");
	close_lpfile(fp1);
*/
	status = MOK;

	if (
	    rp->request->outcome & RS_FILTERING
	 && !(rp->request->outcome & RS_STOPPED)
	)
	{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:1\n");
	close_lpfile(fp1);
*/
	    rp->request->outcome |= (RS_REFILTER|RS_STOPPED);
	    terminate (rp->exec);
	}

	if (
	    rp->request->outcome & RS_PRINTING
	 && !(rp->request->outcome & RS_STOPPED)
	)
	{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:2\n");
	close_lpfile(fp1);
*/
	    rp->request->outcome |= RS_STOPPED;
	    terminate (rp->printer->exec);
	}

	rp->request->outcome |= RS_CHANGING;	
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:3\n");
	close_lpfile(fp1);
*/
	/*
	 * Change the ownership of the request file to be "n->uid".
	 * Either this is identical to "rp->secure->uid", or it is
	 * "Lp_Uid" (see above) or it is root. The idea is that the
	 * person at the other end needs access, and that may not
	 * be who queued the request.
	 */
	path = makepath(Lp_Temp, rp->req_file, (char *)0);
	(void) Chown(path, n->uid, rp->secure->gid);
	free(path);

	add_flt_act(n, FLT_CHANGE, rp);
	req_file = rp->req_file;

    }
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "start:4 n.uid=%d LpUid=%d secuid=%d req=%s\n",
	n->uid, Lp_Uid, rp->secure->uid, req_file);
	close_lpfile(fp1);
*/
    send(n, R_START_CHANGE_REQUEST, status, req_file);
    return;
}

/**
 ** end_change_request()
 **/

void
end_change_request (m,n)
	char			*m;
	NODE			*n;
{
    char		*req_id;
    RSTATUS		*rp;
    off_t		size;
    off_t		osize;
    short		err;
    short		status;
    char		*file;
    REQUEST		*r		= 0;
    REQUEST		oldr;
    int			call_schedule	= 0;
    int			move_ok		= 0;


/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "S_end: enter\n");
	close_lpfile(fp1);
*/
    (void) getmessage(m, S_END_CHANGE_REQUEST, &req_id);
    if (!(rp = request_by_id(req_id)))
      {
	status = MUNKNOWN;
      }
    else if (!(rp->request->outcome & RS_CHANGING))
      {
	status = MNOSTART;
	}
    else
    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "S_end: 1\n");
	close_lpfile(fp1);
*/
	file = makepath(Lp_Temp, rp->req_file, (char *)0);
	(void) Chmod(file, 0600);
	(void) Chown(file, Lp_Uid, Lp_Gid);
	free(file);

/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: outcome=%x actions=%x\n",rp->request->outcome,
		rp->request->actions);
	close_lpfile(fp1);
*/
	rp->request->outcome &= ~(RS_CHANGING);
	del_flt_act(n, FLT_CHANGE);
	/*
	 * The RS_CHANGING bit may have been the only thing preventing
	 * this request from filtering or printing, so regardless of what
	 * happens below, we must check to see if the request can proceed.
	 */
	call_schedule = 1;

	if (!(r = Getrequest(rp->req_file)))
	    status = MNOOPEN;

	else
	{
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: 2\n");
	close_lpfile(fp1);
*/
	    oldr = *(rp->request);
	    *(rp->request) = *r;

	    move_ok = STREQU(oldr.destination, r->destination);
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: outcome=%x actions=%x\n");
	close_lpfile(fp1);
*/
	    /*
	     * Preserve the current request status!
	     */
	    rp->request->outcome = oldr.outcome;

	    if ((rp->request->actions & ACT_SPECIAL) == ACT_HOLD)
	    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: A\n");
	close_lpfile(fp1);
*/
		rp->request->outcome |= RS_HELD;
		/*
		 * To be here means either the user owns the request
		 * or he or she is the administrator. Since we don't
		 * want to set the RS_ADMINHELD flag if the user is
		 * the administrator, the following compare will work.
		 */
	/*	if (n->uid != rp->secure->uid) */
	if ((rp->request->ruid == rp->secure->uid) ||
	    (rp->request->ruid == Lp_Uid) || (rp->request->ruid==0))
		    rp->request->outcome |= RS_ADMINHELD;
	    }

	    if ((rp->request->actions & ACT_SPECIAL) == ACT_RESUME)
	    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: B\n");
	close_lpfile(fp1);
*/
		if (
		    (rp->request->outcome & RS_ADMINHELD)
		 && !isadmin(n->uid)
		)
		{
		    status = MNOPERM;
		    goto Return;
		}
		rp->request->outcome &= ~(RS_ADMINHELD|RS_HELD);
	    }
	    if (((rp->request->actions & ACT_SPECIAL) == ACT_IMMEDIATE) ||
	        ((rp->request->actions & ACT_PRIORITY) == ACT_PRIORITY)) 
	    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: D\n");
	close_lpfile(fp1);
*/
		if (!isadmin(n->uid))
		{
		    status = MNOPERM;
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: E\n");
	close_lpfile(fp1);
*/
		    goto Return;
		}
		rp->request->outcome |= RS_IMMEDIATE;
	    }

	    size = chfiles(rp->request->file_list, Lp_Uid, Lp_Gid);
	    if (size < 0)
	    {
		status = MUNKNOWN;
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: F\n");
	close_lpfile(fp1);
*/
		goto Return;
	    }
	    if (!(rp->request->outcome & RS_HELD) && size == 0)
	    {
		status = MNOPERM;
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: G\n");
	close_lpfile(fp1);
*/
		goto Return;
	    }

	    osize = rp->secure->size;
	    rp->secure->size = size;

	    if ((err = validate_request(rp, (char **)0, move_ok)) != MOK)
	    {
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,"S_end: H\n");
	close_lpfile(fp1);
*/
		status = err;
		rp->secure->size = osize;

	    }
	    else
	    {
		status = MOK;

		if ((rp->request->outcome & RS_IMMEDIATE)  ||
		    (rp->request->outcome & RS_PRIORITY ))
		{
		    remover(rp);
/*
	fp1=open_lpfile(debug1file,  "a", MODE_NOREAD);
	fprintf(fp1,  "S_end: insertr\n");
	close_lpfile(fp1);
*/
		    insertr(rp);
		}

		(void) time(&rp->secure->date);

		freerequest(&oldr);
		(void) putrequest(rp->req_file, rp->request);
		(void) putsecure(rp->req_file, rp->secure);

	    }
	}
    }

Return:
    if (status != MOK && rp)
    {
	if (r)
	{
	    freerequest(r);
	    *(rp->request) = oldr;
	}
	if (status != MNOSTART)
	    (void) putrequest(rp->req_file, rp->request);
    }
    if (call_schedule)
	maybe_schedule(rp);
    send(n, R_END_CHANGE_REQUEST, status, chkprinter_result);
    return;
}

/**
 ** cancel_request()
 **/

void
cancel_request (m,n)
	char			*m;
	NODE			*n;
{
    int			lfd;
    int			done = 0;
    char		*req_id;
    char		*person, *usr;
    char		*dest;
    char		*cp;
    RSTATUS		*rp;
    char		name[64];
    char		buf[BUFSIZ];

	openlog("lpsched", LOG_PID, LOG_LPR);
    (void) getmessage(m, S_CANCEL_REQUEST, &req_id, &person, &usr);

    if (rp = request_by_id(req_id))
    {
	if (n->uid && n->uid != Lp_Uid && n->uid != rp->secure->uid)
	{
	    send(n, R_CANCEL_REQUEST, MNOPERM);
	    return;
	}

	if (n->uid == Lp_Uid && *usr && !STREQU(usr, rp->request->user))
	{
	    send(n, R_CANCEL_REQUEST, MNOPERM);
	    return;
	}

	rp->reason = MOK;

	if (cancel(rp, (n->uid != rp->secure->uid)))
	    send(n, R_CANCEL_REQUEST, MOK);
	else
	    send(n, R_CANCEL_REQUEST, M2LATE);
	return;
    }

	/*
	 *	We get here is the request is not FOUND locally
	 *
	 *	squeeze 'dest' out of 'req_id'
	 */
	dest = strdup(req_id);
	if ((cp = strchr(dest, '-')) != (char *) NULL)
		*cp = '\0';

	if (getremote(dest)) {
		(void) Gethostname(name, sizeof(name));
		if ((lfd = getport(name)) < 0) {
			remote_error(n, "lpd not responding");
			send(n, R_CANCEL_REQUEST, MREMOTE);
			return;
		}

		/*
		 * Make request for lpd
		 */
		SPRINTF(buf, "\5%s %s %s\n", dest, person, ++cp);

		/*
		 * Send request to lpd
		 */
		if (t_snd(lfd, buf, strlen(buf), 0) < 0) {
			remote_error(n, "lost connection to lpd");
			send(n, R_CANCEL_REQUEST, MREMOTE);
			(void) t_unbind(lfd);
			(void) t_close(lfd);
			return;
		}
		else
			send(n, R_CANCEL_REQUEST, MOKREMOTE);

		/*
		 * We can't close the connection until lpd has drained
		 * the buffer, so let's "wait" for him.
		 */
		do {
			switch (t_look(lfd)) {
			  case T_DISCONNECT:
				t_rcvdis(lfd, NULL);
				done = 1;
				break;

			  case T_ORDREL:
				t_rcvrel(lfd);
				done = 1;
				break;

			  case 0:
				(void) sleep(1);
				break;

			  default:
				done = 1;
				break;
			}
		} while (!done);

		(void) t_unbind(lfd);
		(void) t_close(lfd);
		return;
	}
    send(n, R_CANCEL_REQUEST, MUNKNOWN);
}

/**
 ** inquire_request() - S_INQUIRE_REQUEST
 **/

void
inquire_request(m, n)
	char	*m;
	NODE	*n;
{
	char	*form;
	char	*dest;
	char	*pwheel;
	char	*user;
	char	*req_id;
	int	found = 0;

#ifdef	DEBUG
	openlog("lpsched", LOG_PID, LOG_LPR);
#endif
	Found = (RSTATUS *) NULL;
	(void) getmessage(m, S_INQUIRE_REQUEST, &form, &dest, &req_id,
			&user, &pwheel);

	/*
	 * if we are looking for a particular request, let's look on
	 * the local machine first.
	 * Otherwise, let's start with the remote machine.
	 */
	if (*req_id) {
		inquire_lrequest(n, form, dest, req_id, user, pwheel);

		/*
		 * only go remote if the request is not found
		 */
		if (!Found)
			inquire_rrequest(n, form, dest, req_id, user, pwheel);
	}
	else {
		inquire_rrequest(n, form, dest, req_id, user, pwheel);
		inquire_lrequest(n, form, dest, req_id, user, pwheel);
	}

	if (Found)
		send(n, R_INQUIRE_REQUEST,
		     MOK,
		     Found->secure->req_id,
		     Found->request->user,
		     Found->secure->size,
		     Found->secure->date,
		     Found->request->outcome,
		     Found->printer->printer->name,
		     (Found->form? Found->form->form->name : ""),
		     NB(Found->pwheel_name)
		);
	else
		send(n, R_INQUIRE_REQUEST, MNOINFO, "","",0L,0L,0,"","","");
}

inquire_lrequest(n, form, dest, req_id, user, pwheel)
	NODE	*n;
	char	*form;
	char	*dest;
	char	*req_id;
	char	*user;
	char	*pwheel;
{
    RSTATUS	*rp;

    for (rp = Request_List; rp != NULL; rp = rp->next)
    {
	if (*form && !SAME(form, rp->request->form))
	    continue;
	if (*dest && !STREQU(dest, rp->request->destination))
	    continue;
	if (*req_id && !STREQU(req_id, rp->secure->req_id))
	    continue;
	if (*user && !STREQU(user, rp->request->user))
	    continue;
	if (*pwheel && !SAME(pwheel, rp->pwheel_name))
	    continue;
	
	if (Found)
	    send(n, R_INQUIRE_REQUEST,
		 MOKMORE,
		 Found->secure->req_id,
		 Found->request->user,
		 Found->secure->size,
		 Found->secure->date,
		 Found->request->outcome,
		 Found->printer->printer->name,
		 (Found->form? Found->form->form->name : ""),
		 NB(Found->pwheel_name)
	    );
	Found = rp;
    }
}

/*ARGSUSED*/
inquire_rrequest(n, form, dest, req_id, user, pwheel)
	NODE	*n;
	char	*form;
	char	*dest;
	char	*req_id;
	char	*user;
	char	*pwheel;
{
	register char	*cp;
	char	buf[BUFSIZ];
	int	i, flags, c, lfd;
	int	col, sterror;
	struct	utsname	utsname;
	extern	char *getrmtline();
	extern	RSTATUS *make_request();

	/*
	 * if 'dest' is not specified, see if we can squeeze it out of 'req_id'
	 */
	if (!*dest && *req_id) {
		dest = strdup(req_id);
		if ((cp = strchr(dest, '-')) != (char *) NULL)
			*cp = '\0';
		else {
			free(dest);
			dest = "";
		}
	}

	while (getprent(buf) > 0) {
		for (cp = buf; *cp; ++cp)
			if (*cp == '|' || *cp == ':') {
				*cp = '\0';
				break;
			}

		if (STREQU(buf, "local"))
			continue;
		if (*dest && !STREQU(buf, dest))
			continue;
		if (getremote(buf) == 0)
			continue;

		(void) uname(&utsname);
		if ((lfd = getport(utsname.nodename)) < 0) {
			remote_error(n, "lpd not responding");
			continue;
		}
		Printer = strdup(buf);

		/*
		 * Put together request for lpd
		 *	\3printer [users ...] [jobs ...]\n
		 */
		SPRINTF(buf, "\3%s", Printer);
		if (*user)
			SPRINTF(buf, "%s %s", buf, user);
		if (*req_id) {
			/*
			 * Don't add it if the request-id is hosed
			 */
			if ((cp = strchr(req_id, '-')) != NULL) {
				++cp;
				SPRINTF(buf, "%s %s", buf, cp);
			}
		}
		(void) strcat(buf, "\n");

		/*
		 * Send request to lpd
		 */
		if (t_snd(lfd, buf, strlen(buf), 0) < 0) {
			remote_error(n, "lost connection to lpd");
			(void) free(Printer);
			(void) t_unbind(lfd);
			(void) t_close(lfd);
			continue;
		}

		/*
		 * Parse all output received from remote host
		 *	and determine what is an error message and
		 *	what is job information.
		 * Park on connection till it closes.
		 */
		while ((cp = getrmtline(lfd)) != NULL)
		{
			/* catch error messages and heading */
			if (!isdigit(*cp)) {
				continue;
			}

			if (Found) {
				send(n, R_INQUIRE_REQUEST,
					MOKMORE,
					Found->secure->req_id,
					Found->request->user,
					Found->secure->size,
					Found->secure->date,
					Found->request->outcome,
					Found->printer->printer->name,
					(Found->form ? Found->form->form->name
							: ""),
					NB(Found->pwheel_name));
			}

			Found = make_request(cp);
		}

		(void) free(Printer);
		(void) t_rcvdis(lfd);
		(void) t_unbind(lfd);
		(void) t_close(lfd);
	}
}

remote_error(n, s)
	int n;
	char *s;
{
	send(n, R_INQUIRE_REQUEST,
	     MREMOTE, s, "", 0L, 0L, 0, "", "", "");
}

#define	USERPOS		7
#define	ENDUSERPOS	17
#define	JOBPOS		18
#define	ENDJOBPOS	21
#define	SIZEPOS		61

RSTATUS *
make_request(s)
	char s[];
{
	char	buf[BUFSIZ];
	char	*req_id, *user;
	static	RSTATUS	req;
	static	SECURE	secure;
	static	REQUEST	request;
	static	PSTATUS	pstatus;
	static	PRINTER	printer;
	static	int entry = 0;

	if (!entry) {
		/*
		 * Setup structure
		 */
		req.secure = &secure;
		req.request = &request;
		req.printer = &pstatus;
		req.printer->printer = &printer;
		req.form = (FSTATUS *) NULL;
		entry = 1;
	}
	else {
		/*
		 * Free previously allocated fields
		 */
		free(req.secure->req_id);
		free(req.request->user);
		free(req.printer->printer->name);
	}

	/*
	 * Setup fields that are sent
	 */
	s[ENDJOBPOS] = '\0';
	SPRINTF(buf, "%s-%s", Printer, &s[JOBPOS]);
	req.secure->req_id = strdup(buf);

	s[ENDUSERPOS] = '\0';
	req.request->user = strdup(&s[USERPOS]);

	req.secure->size = atol(&s[SIZEPOS]);
	req.secure->date = 0L;		/* what to do */
	req.request->outcome = 0;		/* ditto */
	req.printer->printer->name = strdup(Printer);
	req.pwheel_name = (char *) NULL;
	return(&req);
}

/**
 ** move_request()
 **/

void
move_request  (m, n)
	char			*m;
	NODE			*n;
{
    char	*olddest;
    RSTATUS	*rp;
    short	err;
    char	*req_id;
    char	*dest;
    EXEC	*oldexec;


    (void) getmessage(m, S_MOVE_REQUEST, &req_id, &dest);

    if (!(search_ptable(dest)) && !(search_ctable(dest)))
    {
	send(n, R_MOVE_REQUEST, MNODEST, 0L);
	return;
    }

    if (rp = request_by_id(req_id))
    {
	if (STREQU(rp->request->destination, dest))
	{
	    send(n, R_MOVE_REQUEST, MOK, 0L);
	    return;
	}
	if (rp->request->outcome & (RS_DONE|RS_NOTIFYING))
	{
	    send(n, R_MOVE_REQUEST, M2LATE, 0L);
	    return;
	}
	if (rp->request->outcome & RS_CHANGING)
	{
	    send(n, R_MOVE_REQUEST, MBUSY, 0L);
	    return;
	}
	oldexec = rp->printer->exec;
	olddest = rp->request->destination;
	rp->request->destination = strdup(dest);
	if ((err = validate_request(rp, (char **)0, 1)) == MOK)
	{
	    free(olddest);
	    (void) putrequest(rp->req_file, rp->request);
	    send(n, R_MOVE_REQUEST, MOK, 0L);

	    /*
	     * If the request was being filtered or was printing,
	     * it would have been stopped in "validate_request()",
	     * but only if it has to be refiltered. Thus, the
	     * filtering has been stopped if it has to be stopped,
	     * but the printing may still be going.
	     */
	    if (
		rp->request->outcome & RS_PRINTING
	     && !(rp->request->outcome & RS_STOPPED)
	    )
	    {
		rp->request->outcome |= RS_STOPPED;
		terminate (oldexec);
	    }

	    maybe_schedule(rp);

	    return;
	}
	send(n, R_MOVE_REQUEST, err, chkprinter_result);
	free(rp->request->destination);
	rp->request->destination = olddest;
	return;
    }
    send(n, R_MOVE_REQUEST, MUNKNOWN, 0L);
}

char *
getrmtline(fd)
	int fd;
{
	static char	buf[BUFSIZ];
	static int	pos = 0,	/* current position in buf */
			num = 0,	/* number of valid chars in buf */
			disconnect = 0;	/* disconnect event received */
	int		flags;		/* flags argument for t_rcv */
	char		*p;
	int		i, n;

	for (;;) {
		/*
		 * shift unused portion of buffer to front
		 */
		if (pos > 0) {
			(void) strncpy(&buf[0], &buf[pos], num - pos);
			num -= pos;
			pos = 0;
		}
		
		/* see if we have a complete line */
		if ((p = strchr(buf, '\n')) != NULL) {
			*(p++) = '\0';
			pos = p - buf;
			return(buf);
		}

		i = t_rcv(fd, &buf[num], sizeof(buf) - num, &flags);

		if (i > 0) {
			num += i;
			buf[num] = '\0';
		}
		else if (i < 0) {
			switch ((n = t_look(fd))) {
			  case T_DISCONNECT:
			  case T_ORDREL:
				/* need to make sure we drain connection */
				if (disconnect) {
					disconnect = pos = num = 0;
					(void) t_rcvdis(fd);
					(void) t_unbind(fd);
					(void) t_close(fd);
					return(NULL);
				}

				disconnect = 1;
				break;

			  case 0:
				break;

			  default:
				syslog(LOG_ERR,
					"received unexpected event '%d'", n);
				pos = num = disconnect = 0;
				(void) t_unbind(fd);
				(void) t_close(fd);
				return(NULL);
			}
		}
	}
}

/**
 ** move_dest()
 **/

void
move_dest  (m, n)
	char			*m;
	NODE			*n;
{
    char		*dest;
    char		*fromdest;
    register RSTATUS	*rp;
    char		*olddest;
    EXEC		*oldexec;
    register char	*found = (char *)0;
    register short	num_ok = 0;

    (void) getmessage(m, S_MOVE_DEST, &fromdest, &dest);

    if (!search_ptable(fromdest) && !search_ctable(fromdest))
    {
	send(n, R_MOVE_DEST, MNODEST, fromdest, 0);
	return;
    }

    if (!(search_ptable(dest)) && !(search_ctable(dest)))
    {
	send(n, R_MOVE_DEST, MNODEST, dest, 0);
	return;
    }

    if (STREQU(dest, fromdest))
    {
	send(n, R_MOVE_DEST, MOK, "", 0);
	return;
    }

    BEGIN_WALK_BY_DEST_LOOP (rp, fromdest)
	if (!(rp->request->outcome & (RS_DONE|RS_CHANGING|RS_NOTIFYING)))
	{
	    oldexec = rp->printer->exec;
	    olddest = rp->request->destination;
	    rp->request->destination = strdup(dest);
	    if (validate_request(rp, (char **)0, 1) == MOK)
	    {
		num_ok++;
		free(olddest);
		(void) putrequest(rp->req_file, rp->request);

		/*
		 * If the request was being filtered or was printing,
		 * it would have been stopped in "validate_request()",
		 * but only if it has to be refiltered. Thus, the
		 * filtering has been stopped if it has to be stopped,
		 * but the printing may still be going.
		 */
		if (
		    rp->request->outcome & RS_PRINTING
		 && !(rp->request->outcome & RS_STOPPED)
		)
		{
		    rp->request->outcome |= RS_STOPPED;
		    terminate (oldexec);
	        }

		maybe_schedule(rp);

		continue;
	    }
	    free(rp->request->destination);
	    rp->request->destination = olddest;
	}
	
	if (found)
	    send(n, R_MOVE_DEST, MMORERR, found, 0);

	found = rp->secure->req_id;
    END_WALK_LOOP

    if (found)
	send(n, R_MOVE_DEST, MERRDEST, found, num_ok);
    else
	send(n, R_MOVE_DEST, MOK, "", num_ok);
}
