/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) startdmn.c: version 25.1 created on 12/2/91 at 16:13:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)startdmn.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)startdmn.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)startdaemon.c	5.1 (Berkeley) 6/6/85"; */
#endif /* not lint */

/*
 * Tell the printer daemon that there are new files in the spool directory.
 */

#include <stdio.h>
#include <sys/types.h>
#include <tiuser.h>
#include "lp.local.h"

extern int Daemon;

startdaemon(printer)
	char *printer;
{
	register int s, n;
	char	buf[BUFSIZ];
	int	flags;

	if (Gethostname(buf, sizeof(buf)) < 0) {
		return(0);
	}

	if ((s = getport(buf)) < 0)
		return(0);

	/*
	 * Prepare to send request to daemon
	 */
	(void) sprintf(buf, "\1%s\n", printer);
	n = strlen(buf);

	if (t_snd(s, buf, n, 0) != n) {
		terr("t_snd");
		(void) t_unbind(s);
		(void) t_close(s);
		return(0);
	}

	/* read acknowledgement */
	if (t_rcv(s, buf, 1, &flags) == 1) {
		if (buf[0] == '\0') {		/* everything is OK */
			(void) t_unbind(s);
			(void) t_close(s);
			return(1);
		}
		(void) t_snd(Daemon, buf, 1, flags);
	}

	while ((n = t_rcv(s, buf, sizeof(buf), &flags)) > 0)
		(void) t_snd(Daemon, buf, n, flags);

	(void) t_rcvdis(s, NULL);
	(void) t_unbind(s);
	(void) t_close(s);
	return(0);
}

static
perr(msg)
	char *msg;
{
	char buf[BUFSIZ];
	extern char *name;
	extern int sys_nerr;
	extern char *sys_errlist[];
	extern int errno;

	(void) sprintf(buf, "%s: %s: ", name, msg);
	(void) t_snd(Daemon, buf, strlen(buf), 0);

	if (errno < sys_nerr) {
		(void) t_snd(Daemon, sys_errlist[errno],
				strlen(sys_errlist[errno]), 0);
	}
	else
		(void) t_snd(Daemon, "Unknown error", 13, 0);

	(void) t_snd(Daemon, "\n", 1, 0);
}

static
terr(msg)
	char *msg;
{
	char buf[BUFSIZ];
	extern char *name;
	extern int t_nerr, sys_nerr;
	extern char *t_errlist[], *sys_errlist[];
	extern int t_errno, errno;

	(void) sprintf(buf, "%s: %s: ", name, msg);
	(void) t_snd(Daemon, buf, strlen(buf), 0);

	if (t_errno < t_nerr) {
		(void) t_snd(Daemon, t_errlist[t_errno],
				strlen(t_errlist[t_errno]), 0);
	}
	else
		(void) t_snd(Daemon, "Unknown error", 13, 0);

	if (t_errno == TSYSERR) {
		(void) t_snd(Daemon, ": ", 2, 0);
		if (errno < sys_nerr) {
			(void) t_snd(Daemon, sys_errlist[errno],
					strlen(sys_errlist[errno]), 0);
		}
		else
			(void) t_snd(Daemon, "Unknown error", 13, 0);
	}

	(void) t_snd(Daemon, "\n", 1, 0);
}
